/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.main;

import java.util.List;
import net.dillon.speedrunnermod.advancement.criterion.ModCriterions;
import net.dillon.speedrunnermod.block.ModBlockFamilies;
import net.dillon.speedrunnermod.block.ModBlocks;
import net.dillon.speedrunnermod.command.ModCommands;
import net.dillon.speedrunnermod.component.ModDataComponentTypes;
import net.dillon.speedrunnermod.enchantment.ModEnchantments;
import net.dillon.speedrunnermod.entity.ModEntityTypes;
import net.dillon.speedrunnermod.event.ModEventCallbacks;
import net.dillon.speedrunnermod.item.ModFuels;
import net.dillon.speedrunnermod.item.ModItemGroups;
import net.dillon.speedrunnermod.item.ModItems;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.packet.ModPackets;
import net.dillon.speedrunnermod.particle.ModParticleTypes;
import net.dillon.speedrunnermod.recipe.ModRecipes;
import net.dillon.speedrunnermod.screen.ModScreenHandlerTypes;
import net.dillon.speedrunnermod.sound.ModSoundEvents;
import net.dillon.speedrunnermod.tag.ModBlockTags;
import net.dillon.speedrunnermod.tag.ModEnchantmentTags;
import net.dillon.speedrunnermod.tag.ModFluidTags;
import net.dillon.speedrunnermod.tag.ModItemTags;
import net.dillon.speedrunnermod.tag.ModStructureTags;
import net.dillon.speedrunnermod.village.ModPointOfInterestTypes;
import net.dillon.speedrunnermod.village.ModTradeOffers;
import net.dillon.speedrunnermod.village.ModVillagers;
import net.dillon.speedrunnermod.world.ModWorldGen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpeedrunnerMod
implements ModInitializer {
    public static final String MOD_VERSION = "v1.11.8";
    public static final String MC_VERSION = "1.21.6x";
    public static final String VERSION = "Version: v1.11.8";
    public static final String THE_SPEEDRUNNER_MOD_STRING = "The Speedrunner Mod";
    public static final String OPTIONS_ERROR_MESSAGE = "Found error with speedrunner mod settings, launching in safe mode.";
    public static final String OPTIONS_WARNING_MESSAGE = "Found an unusual value in the speedrunner mod settings.";
    public static boolean safeBoot;
    private static final Logger LOGGER;

    public void onInitialize() {
        safeBoot = false;
        SpeedrunnerMod.configHandler().load();
        ModPackets.registerPackets();
        ModCommands.registerCommands();
        ModParticleTypes.registerParticles();
        ModWorldGen.initializeWorldGenFeatures();
        ModEntityTypes.initializeEntityTypes();
        ModPointOfInterestTypes.initializePois();
        ModVillagers.registerVillagerProfessions();
        ModTradeOffers.registerTradeOffers();
        ModCriterions.initializeCriterions();
        ModDataComponentTypes.initializeDataComponents();
        ModBlocks.initializeBlocks();
        ModBlockFamilies.initializeBlockFamilies();
        ModItems.initializeItems();
        ModItemGroups.registerModifiedItemGroups();
        ModEventCallbacks.registerEventCallbacks();
        ModBlockTags.initializeBlockTags();
        ModEnchantmentTags.initializeEnchantmentTags();
        ModFluidTags.initializeFluidTags();
        ModItemTags.initializeItemTags();
        ModStructureTags.initializeStructureTags();
        ModSoundEvents.initializeSoundEvents();
        ModEnchantments.initializeEnchantments();
        ModRecipes.initializeCustomRecipes();
        ModFuels.registerFuels();
        ModScreenHandlerTypes.initializeScreenHandlers();
        SpeedrunnerMod.options().advanced.modIds.getCurrentValue().clear();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            String modId = mod.getMetadata().getId();
            boolean exclude = false;
            List<String> excludedMods = List.of("fabric-", "fabricloader", "java", "mixinextras");
            for (String excludedMod : excludedMods) {
                if (!modId.startsWith(excludedMod)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            SpeedrunnerMod.options().advanced.modIds.getCurrentValue().add(modId);
        }
        SpeedrunnerMod.configHandler().save();
        if (SpeedrunnerMod.options().main.mode != null && ModOptions.isDoomMode()) {
            SpeedrunnerMod.info("You dare to attempt Doom Mode? Good luck...");
        }
        SpeedrunnerMod.info("The Speedrunner Mod v1.11.8 loaded successfully.");
    }

    public static void info(String info) {
        LOGGER.info(info);
    }

    public static void warn(String warning) {
        LOGGER.warn(warning);
    }

    public static void error(String error) {
        LOGGER.error(error);
    }

    public static void debug(String debug) {
        LOGGER.debug(debug);
    }

    public static ModOptions options() {
        return (ModOptions)ModOptions.OPTIONS.getInstance();
    }

    public static ModOptions.Handler configHandler() {
        return ModOptions.OPTIONS;
    }

    public static void saveDedicatedServerChanges() {
        SpeedrunnerMod.configHandler().save();
    }

    public static class_2960 ofSpeedrunnerMod(String path) {
        return class_2960.method_60655((String)"speedrunnermod", (String)path);
    }

    public static boolean isEnvironmentTypeServer() {
        return FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.SERVER);
    }

    static {
        LOGGER = LogManager.getLogger((String)"Speedrunner Mod");
    }
}

