/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.main;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.dillon.speedrunnermod.client.keybind.ModKeybindings;
import net.dillon.speedrunnermod.client.particle.ModParticleManager;
import net.dillon.speedrunnermod.client.render.ModRenderers;
import net.dillon.speedrunnermod.client.screen.ModHandledScreens;
import net.dillon.speedrunnermod.client.screen.base.AbstractModScreen;
import net.dillon.speedrunnermod.client.screen.feature.AbstractFeatureScreen;
import net.dillon.speedrunnermod.client.screen.feature.secretdoommode.AbstractSecretDoomModeScreen;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.option.ClientModOptions;
import net.dillon.speedrunnermod.option.Leaderboards;
import net.dillon.speedrunnermod.option.OptionValue;
import net.dillon.speedrunnermod.packet.ClientModPackets;
import net.dillon.speedrunnermod.util.AI;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_437;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

@Environment(value=EnvType.CLIENT)
public class SpeedrunnerModClient
implements ClientModInitializer {
    public static final List<Function<class_437, AbstractModScreen>> ALL_MOD_SCREENS = new ArrayList<Function<class_437, AbstractModScreen>>();
    public static final List<Function<class_437, AbstractFeatureScreen>> ALL_FEATURE_SCREENS = new ArrayList<Function<class_437, AbstractFeatureScreen>>();
    public static boolean speedrunIGTMissing = false;

    @AI
    public void onInitializeClient() {
        Function<class_437, AbstractModScreen> creator;
        Constructor constructor;
        ClientModPackets.registerClientPackets();
        ModParticleManager.registerDefaults();
        ModRenderers.initializeRenderers();
        ModHandledScreens.registerScreens();
        ModKeybindings.initializeKeybinds();
        SpeedrunnerModClient.clientConfigHandler().load();
        if (SpeedrunnerMod.options().main.leaderboardsMode.getCurrentValue().booleanValue() && !SpeedrunnerModClient.isSpeedrunIGTLoaded()) {
            speedrunIGTMissing = true;
            SpeedrunnerMod.warn("Detected that SpeedrunIGT is not loaded, you should probably download this mod if you would like to submit speedruns to the leaderboards.");
        }
        Reflections modScreenDirectory = new Reflections("net.dillon.speedrunnermod.client.screen", new Scanner[]{Scanners.SubTypes});
        Reflections featureScreenDirectory = new Reflections("net.dillon.speedrunnermod.client.screen.feature", new Scanner[]{Scanners.SubTypes});
        Set modScreenClasses = modScreenDirectory.getSubTypesOf(AbstractModScreen.class);
        Set featureScreenClasses = featureScreenDirectory.getSubTypesOf(AbstractFeatureScreen.class);
        for (Class modScreen : modScreenClasses) {
            try {
                constructor = modScreen.getConstructor(class_437.class);
                creator = parent -> {
                    try {
                        return (AbstractModScreen)((Object)((Object)constructor.newInstance(parent)));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to instantiate " + modScreen.getName(), e);
                    }
                };
                ALL_MOD_SCREENS.add(creator);
            }
            catch (NoSuchMethodException e) {
                SpeedrunnerMod.debug("Skipping " + modScreen.getName() + ": doesn't have (Screen) constructor.");
            }
        }
        for (Class featureScreen : featureScreenClasses) {
            if (featureScreen == AbstractSecretDoomModeScreen.class) continue;
            try {
                constructor = featureScreen.getConstructor(class_437.class);
                creator = parent -> {
                    try {
                        return (AbstractFeatureScreen)((Object)((Object)constructor.newInstance(parent)));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to instantiate " + featureScreen.getName(), e);
                    }
                };
                ALL_FEATURE_SCREENS.add(creator);
            }
            catch (NoSuchMethodException e) {
                SpeedrunnerMod.debug("Skipping " + featureScreen.getName() + ": doesn't have (Screen) constructor.");
            }
        }
        Leaderboards.initializeLeaderboards();
        SpeedrunnerMod.debug("The client-side for The Speedrunner Mod has successfully loaded.");
    }

    @Environment(value=EnvType.CLIENT)
    public static ClientModOptions clientOptions() {
        return (ClientModOptions)ClientModOptions.CLIENT_OPTIONS.getInstance();
    }

    @Environment(value=EnvType.CLIENT)
    public static ClientModOptions.Handler clientConfigHandler() {
        return ClientModOptions.CLIENT_OPTIONS;
    }

    @Environment(value=EnvType.CLIENT)
    public static void saveClientChanges() {
        SpeedrunnerModClient.clientConfigHandler().save();
    }

    @Environment(value=EnvType.CLIENT)
    public static void saveAllChanges() {
        SpeedrunnerMod.saveDedicatedServerChanges();
        SpeedrunnerModClient.saveClientChanges();
    }

    public static boolean isSpeedrunIGTLoaded() {
        return FabricLoader.getInstance().isModLoaded("speedrunigt");
    }

    public static boolean isSimpleKeybindsLoaded() {
        return FabricLoader.getInstance().isModLoaded("simplekeybinds");
    }

    public static void fixAllBrokenOptions() {
        for (OptionValue<?> option : OptionValue.getBrokenOptions()) {
            if (!option.isBroken()) continue;
            option.reset();
            option.setFixed();
        }
        SpeedrunnerModClient.saveAllChanges();
    }

    public static double getMinBrightness() {
        return SpeedrunnerModClient.clientOptions().client.minimumBrightness.getCurrentValue();
    }

    public static double getMaxBrightness() {
        return SpeedrunnerModClient.clientOptions().client.maximumBrightness.getCurrentValue();
    }
}

