/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.mixin.main.entity;

import java.util.ArrayList;
import java.util.List;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.packet.client.UpdateLastCompletedTutorialStepTranslationsS2CPacket;
import net.dillon.speedrunnermod.server.ServerStorage;
import net.dillon.speedrunnermod.tutorial.TutorialStep;
import net.dillon.speedrunnermod.util.ModUtil;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1560;
import net.minecraft.class_1570;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1510.class}, priority=999)
public class EnderDragonEntityMixin
extends class_1308 {
    @Shadow
    @Final
    public class_1508 field_7017;

    public EnderDragonEntityMixin(class_1299<? extends class_1510> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void changeEnderDragonMaxHealth(CallbackInfo ci) {
        ModUtil.modifyMaxHealth((class_1309)this, ModUtil.getEnderDragonMaxHealth());
    }

    @ModifyArg(method={"tickWithEndCrystals"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/boss/dragon/EnderDragonEntity;setHealth(F)V"))
    private float changeTickCrystalHealAmount(float value) {
        return this.method_6032() + ModUtil.getEnderDragonEndCrystalHealingValue();
    }

    @ModifyArg(method={"damageLivingEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/damage/DamageSource;F)Z"), index=2)
    private float changeEnderDragonDamageValue(float amount) {
        return ModUtil.getEnderDragonDamageValue();
    }

    @ModifyArg(method={"crystalDestroyed"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/boss/dragon/EnderDragonEntity;damagePart(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/boss/dragon/EnderDragonPart;Lnet/minecraft/entity/damage/DamageSource;F)Z"), index=3)
    private float changeEnderDragonCrystalDestroyedDamage(float amount) {
        return ModUtil.getEnderDragonDestroyedEndCrystalDamageValue();
    }

    @Inject(method={"damagePart"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/boss/dragon/phase/Phase;modifyDamageTaken(Lnet/minecraft/entity/damage/DamageSource;F)F")}, cancellable=true)
    private void cancelOutDamage(class_3218 world, class_1508 part, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (ModOptions.isDoomMode() && this.method_6032() <= 1.0f && SpeedrunnerMod.options().advanced.dragonImmunityFromGoliathAndWither.getCurrentValue().booleanValue() && this.isGiantOrWitherAlive()) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyConstant(method={"damagePart"}, constant={@Constant(floatValue=0.25f)})
    private float increaseDragonStayTime(float constant) {
        return ModUtil.getEnderDragonSittingTime();
    }

    @Redirect(method={"destroyBlocks"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;isIn(Lnet/minecraft/registry/tag/TagKey;)Z", ordinal=1))
    private boolean makeBedsImmuneOnDoomMode(class_2680 blockState, class_6862<?> tagKey) {
        return ModOptions.isDoomMode() ? blockState.method_26164(class_3481.field_17753) || blockState.method_26164(class_3481.field_16443) : blockState.method_26164(class_3481.field_17753);
    }

    @Inject(method={"updatePostDeath"}, at={@At(value="TAIL")})
    public void killNearbyHostiles(CallbackInfo ci) {
        class_1937 class_19372;
        if (SpeedrunnerMod.options().advanced.dragonKillsNearbyHostileEntities.getCurrentValue().booleanValue() && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_1510 dragon = (class_1510)this;
            class_1937 world = this.method_37908();
            List hostiles = world.method_8390(class_1588.class, dragon.method_5829().method_1009((double)SpeedrunnerMod.options().advanced.dragonMassKillRadius.getCurrentValue().getFirst().intValue(), (double)SpeedrunnerMod.options().advanced.dragonMassKillRadius.getCurrentValue().get(1).intValue(), (double)SpeedrunnerMod.options().advanced.dragonMassKillRadius.getCurrentValue().get(2).intValue()), entity -> true);
            for (class_1588 hostile : hostiles) {
                if (hostile instanceof class_1560 || hostile.method_16914()) continue;
                hostile.method_5768(serverWorld);
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        class_1510 dragon = (class_1510)this;
        class_1657 player = dragon.method_37908().method_18460((class_1297)dragon, 300.0);
        if (!this.isGiantOrWitherAlive()) {
            ModUtil.completeStepS2C(TutorialStep.KILL_WITHER, player, "speedrunnermod.tutorial_mode.wither_died", "speedrunnermod.tutorial_mode.kill_dragon");
        }
    }

    public void method_6078(class_1282 source) {
        class_1510 dragon = (class_1510)this;
        this.preventDragonFromDying(dragon);
        class_1309 livingEntity = dragon.method_6065();
        if (livingEntity instanceof class_3222) {
            boolean bl;
            class_3222 serverPlayer = (class_3222)livingEntity;
            boolean bl2 = bl = ServerStorage.isTutorialModeEnabledForPlayer(serverPlayer.method_5667()) && !ServerStorage.hasCompletedStep(serverPlayer, TutorialStep.USE_DRAGONS_PEARL) && !ModOptions.isBalancedMode();
            if (this.preventDragonFromDying(dragon) || bl) {
                this.method_6033(1.0f);
                if (bl && !this.isGiantOrWitherAlive()) {
                    ArrayList<String> translations = new ArrayList<String>();
                    String s = "speedrunnermod.tutorial_mode.use_dragons_pearl";
                    translations.add(s);
                    ModUtil.sendWithPrefix(s, (class_1657)serverPlayer);
                    ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new UpdateLastCompletedTutorialStepTranslationsS2CPacket(translations));
                }
            } else {
                class_1657 player = dragon.method_37908().method_18460((class_1297)((class_1510)this), 300.0);
                ModUtil.completeStepS2C(TutorialStep.KILL_DRAGON, player, ModOptions.isDoomMode() ? "speedrunnermod.tutorial_mode.killed_dragon.doom" : "speedrunnermod.tutorial_mode.killed_dragon");
                super.method_6078(source);
            }
        }
    }

    @Unique
    private boolean preventDragonFromDying(class_1510 dragon) {
        boolean bl;
        boolean bl2 = bl = ModOptions.isDoomMode() && SpeedrunnerMod.options().advanced.dragonImmunityFromGoliathAndWither.getCurrentValue() != false && this.isGiantOrWitherAlive();
        if (bl) {
            dragon.method_6033(1.0f);
        }
        return bl;
    }

    @Unique
    private boolean isGiantOrWitherAlive() {
        class_1510 dragon = (class_1510)this;
        List giants = this.method_37908().method_8390(class_1570.class, dragon.method_5829().method_1009((double)SpeedrunnerMod.options().advanced.dragonImmunityDetectionRadiusForGoliath.getCurrentValue().getFirst().intValue(), (double)SpeedrunnerMod.options().advanced.dragonImmunityDetectionRadiusForGoliath.getCurrentValue().get(1).intValue(), (double)SpeedrunnerMod.options().advanced.dragonImmunityDetectionRadiusForGoliath.getCurrentValue().get(2).intValue()), entity -> true);
        List withers = this.method_37908().method_8390(class_1528.class, dragon.method_5829().method_1009((double)SpeedrunnerMod.options().advanced.dragonImmunityDetectionRadiusForWither.getCurrentValue().getFirst().intValue(), (double)SpeedrunnerMod.options().advanced.dragonImmunityDetectionRadiusForWither.getCurrentValue().get(1).intValue(), (double)SpeedrunnerMod.options().advanced.dragonImmunityDetectionRadiusForWither.getCurrentValue().get(2).intValue()), entity -> true);
        for (class_1570 giant : giants) {
            if (!giant.method_5805()) continue;
            return true;
        }
        for (class_1528 wither : withers) {
            if (!wither.method_5805()) continue;
            return true;
        }
        return false;
    }
}

