/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.mixin.plugin;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.util.AI;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

@AI
public class ConditionalMixinPlugin
implements IMixinConfigPlugin {
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean bl = this.shouldNotApply(mixinClassName);
        if (bl) {
            SpeedrunnerMod.warn("Skipping mixin " + mixinClassName + " for target " + targetClassName + " because it should not be applied.");
        }
        return !bl;
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private boolean shouldNotApply(String mixinClassName) {
        return !ConditionalMixinPlugin.readOptionAsBoolean() && mixinClassName.equals("net.dillon.speedrunnermod.mixin.main.world.TBSurfaceRuleDataMixin");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AI
    private static boolean readOptionAsBoolean() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "speedrunnermod-config_1.11.1.json");
        if (!configFile.exists()) {
            return true;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (!json.has("mixins")) return true;
            JsonObject mixins = json.getAsJsonObject("mixins");
            if (!mixins.has("terra_blender_surface_rule_data_mixin")) return true;
            JsonObject optionValue = mixins.getAsJsonObject("terra_blender_surface_rule_data_mixin");
            if (!optionValue.has("current_value")) return true;
            boolean bl = optionValue.get("current_value").getAsBoolean();
            return bl;
        }
        catch (Exception e) {
            if (SpeedrunnerMod.isEnvironmentTypeServer()) {
                throw new IllegalStateException("Failed to read config for mixin plugin: " + e.getMessage() + ". This is likely caused to updating to the newest version of the speedrunner mod, please relaunch the server and everything should work.");
            }
            SpeedrunnerMod.error("Failed to read config for mixin plugin: " + e.getMessage());
            ModOptions.isSafe(false);
        }
        return true;
    }
}

