/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.option;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.option.IntegerOptionValue;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.option.OptionValue;
import net.dillon.speedrunnermod.util.AI;
import net.fabricmc.loader.api.FabricLoader;

public abstract class BaseOptions<T> {
    public static final String CURRENT_VALUE = "current_value";
    private final Gson GSON = this.createGson();
    private final String fileName;
    private File file;
    protected T instance;
    private final String space = " ";
    private final String pertaining = "Pertaining to: ";
    protected final String related = " Pertaining to: ";

    protected BaseOptions(String fileName) {
        this.fileName = fileName;
        this.instance = this.createDefault();
    }

    protected abstract T createDefault();

    protected abstract Class<T> getConfigClass();

    protected abstract void safeCheck();

    public void setBroken(OptionValue<?> option, String value) {
        SpeedrunnerMod.error("Found error with speedrunner mod settings, launching in safe mode. Pertaining to: speedrunnermod.options." + value);
        ModOptions.isSafe(false);
        option.setBroken();
    }

    @AI
    public Gson createGson() {
        GsonBuilder builder = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().registerTypeAdapter(IntegerOptionValue.class, (Object)new TypeAdapter<IntegerOptionValue>(this){

            public void write(JsonWriter out, IntegerOptionValue value) throws IOException {
                out.beginObject();
                out.name("minValue").value((long)value.getMinValue());
                out.name("maxValue").value((long)value.getMaxValue());
                out.name("requires_restart").value(value.requiresRestart());
                out.name("default_value").value((Number)value.getDefaultValue());
                out.name(BaseOptions.CURRENT_VALUE).value((Number)value.getCurrentValue());
                out.name("broken").value(value.isBroken());
                out.endObject();
            }

            public IntegerOptionValue read(JsonReader in) throws IOException {
                in.beginObject();
                int minValue = 0;
                int maxValue = 0;
                int defaultValue = 0;
                int currentValue = 0;
                boolean requiresRestart = false;
                boolean broken = false;
                while (in.hasNext()) {
                    switch (in.nextName()) {
                        case "minValue": {
                            minValue = in.nextInt();
                            break;
                        }
                        case "maxValue": {
                            maxValue = in.nextInt();
                            break;
                        }
                        case "requires_restart": {
                            requiresRestart = in.nextBoolean();
                            break;
                        }
                        case "default_value": {
                            defaultValue = in.nextInt();
                            break;
                        }
                        case "current_value": {
                            currentValue = in.nextInt();
                            break;
                        }
                        case "broken": {
                            broken = in.nextBoolean();
                        }
                    }
                }
                in.endObject();
                IntegerOptionValue value = new IntegerOptionValue(defaultValue, requiresRestart, minValue, maxValue);
                value.set(currentValue);
                if (broken) {
                    value.setBroken();
                }
                return value;
            }
        });
        return builder.create();
    }

    public T getInstance() {
        return this.instance;
    }

    public void resetToDefault() {
        T defaults = this.createDefault();
        String json = this.GSON.toJson(defaults);
        this.instance = this.GSON.fromJson(json, this.getConfigClass());
    }

    public void throwNullPointerException(String option, Object[] values) {
        throw new NullPointerException("Option \"" + option + "\" is NULL. Most likely, it is set to an invalid value in the \"speedrunnermod-options.config.json\" file. You can either delete the config file to automatically re-generate it correctly upon next launch, or set it to a valid value. Valid values for \"" + option + "\" are: " + Arrays.toString(values));
    }

    public void throwNumberLessThanOneException(String option) {
        throw new IllegalStateException("Option \"" + option + "\" cannot be set to a value less than 1.");
    }

    public void load() {
        File configFile = this.getConfigFile();
        for (File oldConfigFile : this.oldConfigFiles()) {
            if (!oldConfigFile.exists() || !oldConfigFile.delete()) continue;
            SpeedrunnerMod.warn("Found old speedrunner mod config file, deleting.");
        }
        if (!configFile.exists()) {
            this.instance = this.createDefault();
        } else {
            try (FileReader reader = new FileReader(configFile);){
                this.instance = this.GSON.fromJson((Reader)reader, this.getConfigClass());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.instance = this.createDefault();
            }
        }
        this.safeCheck();
        this.save();
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.getConfigFile());){
            writer.write(this.GSON.toJson(this.instance));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void match(T sentOptions) {
        this.instance = sentOptions;
        this.save();
    }

    public File getConfigFile() {
        if (this.file == null) {
            this.file = this.ofFile(this.fileName);
        }
        return this.file;
    }

    private File ofFile(String fileName) {
        return new File(FabricLoader.getInstance().getConfigDir().toFile(), fileName);
    }

    private List<File> oldConfigFiles() {
        return List.of(this.ofFile("speedrunnermod-config.json"), this.ofFile("speedrunnermod-client_config.json"), this.ofFile("speedrunnermod-options.json"));
    }
}

