/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.option;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.main.SpeedrunnerModClient;
import net.dillon.speedrunnermod.option.BaseOptions;
import net.dillon.speedrunnermod.option.IntegerOptionValue;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.option.OptionValue;
import net.dillon.speedrunnermod.tutorial.TutorialStep;
import net.dillon.speedrunnermod.util.AI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_7291;

@Environment(value=EnvType.CLIENT)
public class ClientModOptions {
    public final Client client = new Client();
    public final Mixins mixins = new Mixins();
    public final StoredValues storedValues = new StoredValues();
    public final TutorialMode tutorialMode = new TutorialMode();
    public static final Handler CLIENT_OPTIONS = new Handler();

    public static boolean isActionbar() {
        return SpeedrunnerModClient.clientOptions().client.itemMessages.getCurrentValue().equals((Object)ItemMessages.ACTIONBAR);
    }

    @AI
    public static void resetAllOptions() {
        SpeedrunnerMod.configHandler().resetToDefault();
        ClientModOptions.resetTutorialModeProgression();
    }

    @AI
    public static void resetAllClientOptions() {
        SpeedrunnerModClient.clientConfigHandler().resetToDefault();
    }

    public static void resetTutorialModeProgression() {
        for (TutorialStep step : TutorialStep.values()) {
            try {
                SpeedrunnerModClient.clientOptions().tutorialMode.setStep(step, false);
                SpeedrunnerModClient.clientOptions().storedValues.lastCompletedTutorialStepMessageTranslations.getCurrentValue().clear();
            }
            catch (Exception e) {
                SpeedrunnerMod.error("Error resetting tutorial mode option: " + step.name());
                e.printStackTrace();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public OptionValue<Boolean> tutorialMode = new OptionValue<Boolean>(false, true);
        public OptionValue<Boolean> fog = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> fullBright = new OptionValue<Boolean>(false, false);
        public OptionValue<ItemMessages> itemMessages = new OptionValue<ItemMessages>(ItemMessages.ACTIONBAR, false);
        public OptionValue<Boolean> fastWorldCreation = new OptionValue<Boolean>(true, false);
        public OptionValue<GameMode> gameMode = new OptionValue<GameMode>(GameMode.SURVIVAL, false);
        public OptionValue<Difficulty> difficulty = new OptionValue<Difficulty>(Difficulty.EASY, false);
        public OptionValue<Boolean> allowCheats = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> showResetButton = new OptionValue<Boolean>(true, false);
        public IntegerOptionValue iCarusFireworksInventorySlot = new IntegerOptionValue(1, false, 1, 36);
        public IntegerOptionValue infiniPearlInventorySlot = new IntegerOptionValue(1, false, 1, 36);
        public OptionValue<Boolean> increasedLavaVision = new OptionValue<Boolean>(true, false);
        public OptionValue<Double> minimumBrightness = new OptionValue<Double>(0.0, false);
        public OptionValue<Double> maximumBrightness = new OptionValue<Double>(12.0, false);
        public OptionValue<Boolean> canCloseEndCredits = new OptionValue<Boolean>(false, false);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Mixins {
        public OptionValue<Boolean> fogMixins = new OptionValue<Boolean>(true, true);
        public OptionValue<Boolean> simpleOptionMixin = new OptionValue<Boolean>(true, true);
        public OptionValue<Boolean> logoDrawerMixin = new OptionValue<Boolean>(true, true);
        public OptionValue<Boolean> renderLayersMixin = new OptionValue<Boolean>(true, true);
    }

    @Environment(value=EnvType.CLIENT)
    public static class StoredValues {
        public OptionValue<Boolean> firstTimePlaying = new OptionValue<Boolean>(true, false);
        public OptionValue<List<String>> lastCompletedTutorialStepMessageTranslations = new OptionValue(new ArrayList(), false);
        public OptionValue<Boolean> enterFeaturesScreen = new OptionValue<Boolean>(false, false);
    }

    @Environment(value=EnvType.CLIENT)
    @AI
    public static class TutorialMode
    implements net.dillon.speedrunnermod.tutorial.TutorialMode {
        public OptionValue<Boolean> enterWorld = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedSpeedrunnerPickaxe = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedSpeedrunnerPaddle = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedSpeedrunnerBoat = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedSpeedrunnerArmorSet = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedSpeedrunnerShield = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedInfernoEye = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> usedInfernoEye = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedPiglinAwakener = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> usedPiglinAwakener = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedBlazeSpotter = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> usedBlazeSpotter = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedSpeedrunnersEye = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> changedSpeedrunnersEyeLocator = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> usedSpeedrunnersEye = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedEnderEye = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> usedEnderEye = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedDragonsPearl = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedAnnulEye = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> usedAnnulEye = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> enteredEnd = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedTotem = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> freeFalledIntoVoid = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedSpeedrunnersTotem = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> brokenDoomBlock = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> killedGoliath = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> killedWither = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> usedDragonsPearl = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> killedDragon = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> exitEnd = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> brokenExperienceOre = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedSpeedrunnersWorkbench = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> transferedEnchantments = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> interactedWithRetiredSpeedrunner = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedEnderThruster = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> usedEnderThruster = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedDragonsSword = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedWitherBone = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedWitherSword = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedEnderMatter = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> obtainedInfiniPearl = new OptionValue<Boolean>(false, false);

        @Override
        public boolean getStep(TutorialStep step) {
            return switch (step) {
                default -> throw new MatchException(null, null);
                case TutorialStep.ENTER_WORLD -> this.enterWorld.getCurrentValue();
                case TutorialStep.CRAFT_SPEEDRUNNER_PICKAXE -> this.obtainedSpeedrunnerPickaxe.getCurrentValue();
                case TutorialStep.CRAFT_SPEEDRUNNER_PADDLE -> this.obtainedSpeedrunnerPaddle.getCurrentValue();
                case TutorialStep.CRAFT_SPEEDRUNNER_BOAT -> this.obtainedSpeedrunnerBoat.getCurrentValue();
                case TutorialStep.CRAFT_SPEEDRUNNER_ARMOR -> this.obtainedSpeedrunnerArmorSet.getCurrentValue();
                case TutorialStep.CRAFT_SPEEDRUNNER_SHIELD -> this.obtainedSpeedrunnerShield.getCurrentValue();
                case TutorialStep.CRAFT_INFERNO_EYE -> this.obtainedInfernoEye.getCurrentValue();
                case TutorialStep.USE_INFERNO_EYE -> this.usedInfernoEye.getCurrentValue();
                case TutorialStep.CRAFT_PIGLIN_AWAKENER -> this.obtainedPiglinAwakener.getCurrentValue();
                case TutorialStep.USE_PIGLIN_AWAKENER -> this.usedPiglinAwakener.getCurrentValue();
                case TutorialStep.CRAFT_BLAZE_SPOTTER -> this.obtainedBlazeSpotter.getCurrentValue();
                case TutorialStep.USE_BLAZE_SPOTTER -> this.usedBlazeSpotter.getCurrentValue();
                case TutorialStep.CRAFT_SPEEDRUNNERS_EYE -> this.obtainedSpeedrunnersEye.getCurrentValue();
                case TutorialStep.CHANGE_SPEEDRUNNERS_EYE_LOCATOR -> this.changedSpeedrunnersEyeLocator.getCurrentValue();
                case TutorialStep.USE_SPEEDRUNNERS_EYE -> this.usedSpeedrunnersEye.getCurrentValue();
                case TutorialStep.USE_ENDER_EYE -> this.usedEnderEye.getCurrentValue();
                case TutorialStep.CRAFT_ANNUL_EYE -> this.obtainedAnnulEye.getCurrentValue();
                case TutorialStep.CRAFT_DRAGONS_PEARL -> this.obtainedDragonsPearl.getCurrentValue();
                case TutorialStep.CRAFT_ENDER_EYE -> this.obtainedEnderEye.getCurrentValue();
                case TutorialStep.USE_ANNUL_EYE -> this.usedAnnulEye.getCurrentValue();
                case TutorialStep.ENTER_END -> this.enteredEnd.getCurrentValue();
                case TutorialStep.OBTAIN_TOTEM_OF_UNDYING -> this.obtainedTotem.getCurrentValue();
                case TutorialStep.FREE_FALL_INTO_VOID -> this.freeFalledIntoVoid.getCurrentValue();
                case TutorialStep.OBTAIN_SPEEDRUNNERS_TOTEM -> this.obtainedSpeedrunnersTotem.getCurrentValue();
                case TutorialStep.BREAK_DOOM_BLOCK -> this.brokenDoomBlock.getCurrentValue();
                case TutorialStep.KILL_GOLIATH -> this.killedGoliath.getCurrentValue();
                case TutorialStep.KILL_WITHER -> this.killedWither.getCurrentValue();
                case TutorialStep.USE_DRAGONS_PEARL -> this.usedDragonsPearl.getCurrentValue();
                case TutorialStep.KILL_DRAGON -> this.killedDragon.getCurrentValue();
                case TutorialStep.EXIT_END -> this.exitEnd.getCurrentValue();
                case TutorialStep.MINE_EXPERIENCE_ORE -> this.brokenExperienceOre.getCurrentValue();
                case TutorialStep.CRAFT_SPEEDRUNNERS_WORKBENCH -> this.obtainedSpeedrunnersWorkbench.getCurrentValue();
                case TutorialStep.TRANSFER_ENCHANTMENTS -> this.transferedEnchantments.getCurrentValue();
                case TutorialStep.INTERACT_WITH_RETIRED_SPEEDRUNNER -> this.interactedWithRetiredSpeedrunner.getCurrentValue();
                case TutorialStep.OBTAIN_ENDER_THRUSTER -> this.obtainedEnderThruster.getCurrentValue();
                case TutorialStep.USE_ENTER_THRUSTER -> this.usedEnderThruster.getCurrentValue();
                case TutorialStep.OBTAIN_DRAGONS_SWORD -> this.obtainedDragonsSword.getCurrentValue();
                case TutorialStep.OBTAIN_WITHER_BONE -> this.obtainedWitherBone.getCurrentValue();
                case TutorialStep.OBTAIN_WITHER_SWORD -> this.obtainedWitherSword.getCurrentValue();
                case TutorialStep.OBTAIN_ENDER_MATTER -> this.obtainedEnderMatter.getCurrentValue();
                case TutorialStep.OBTAIN_INFINI_PEARL -> this.obtainedInfiniPearl.getCurrentValue();
            };
        }

        @Override
        public void setStep(TutorialStep step, boolean value) {
            switch (step) {
                case ENTER_WORLD: {
                    this.enterWorld.set(value);
                    break;
                }
                case CRAFT_SPEEDRUNNER_PICKAXE: {
                    this.obtainedSpeedrunnerPickaxe.set(value);
                    break;
                }
                case CRAFT_SPEEDRUNNER_PADDLE: {
                    this.obtainedSpeedrunnerPaddle.set(value);
                    break;
                }
                case CRAFT_SPEEDRUNNER_BOAT: {
                    this.obtainedSpeedrunnerBoat.set(value);
                    break;
                }
                case CRAFT_SPEEDRUNNER_ARMOR: {
                    this.obtainedSpeedrunnerArmorSet.set(value);
                    break;
                }
                case CRAFT_SPEEDRUNNER_SHIELD: {
                    this.obtainedSpeedrunnerShield.set(value);
                    break;
                }
                case CRAFT_INFERNO_EYE: {
                    this.obtainedInfernoEye.set(value);
                    break;
                }
                case USE_INFERNO_EYE: {
                    this.usedInfernoEye.set(value);
                    break;
                }
                case CRAFT_PIGLIN_AWAKENER: {
                    this.obtainedPiglinAwakener.set(value);
                    break;
                }
                case USE_PIGLIN_AWAKENER: {
                    this.usedPiglinAwakener.set(value);
                    break;
                }
                case CRAFT_BLAZE_SPOTTER: {
                    this.obtainedBlazeSpotter.set(value);
                    break;
                }
                case USE_BLAZE_SPOTTER: {
                    this.usedBlazeSpotter.set(value);
                    break;
                }
                case CRAFT_SPEEDRUNNERS_EYE: {
                    this.obtainedSpeedrunnersEye.set(value);
                    break;
                }
                case CHANGE_SPEEDRUNNERS_EYE_LOCATOR: {
                    this.changedSpeedrunnersEyeLocator.set(value);
                    break;
                }
                case USE_SPEEDRUNNERS_EYE: {
                    this.usedSpeedrunnersEye.set(value);
                    break;
                }
                case CRAFT_ENDER_EYE: {
                    this.obtainedEnderEye.set(value);
                    break;
                }
                case USE_ENDER_EYE: {
                    this.usedEnderEye.set(value);
                    break;
                }
                case CRAFT_DRAGONS_PEARL: {
                    this.obtainedDragonsPearl.set(value);
                    break;
                }
                case CRAFT_ANNUL_EYE: {
                    this.obtainedAnnulEye.set(value);
                    break;
                }
                case USE_ANNUL_EYE: {
                    this.usedAnnulEye.set(value);
                    break;
                }
                case ENTER_END: {
                    this.enteredEnd.set(value);
                    break;
                }
                case OBTAIN_TOTEM_OF_UNDYING: {
                    this.obtainedTotem.set(value);
                    break;
                }
                case FREE_FALL_INTO_VOID: {
                    this.freeFalledIntoVoid.set(value);
                    break;
                }
                case OBTAIN_SPEEDRUNNERS_TOTEM: {
                    this.obtainedSpeedrunnersTotem.set(value);
                    break;
                }
                case BREAK_DOOM_BLOCK: {
                    this.brokenDoomBlock.set(value);
                    break;
                }
                case KILL_GOLIATH: {
                    this.killedGoliath.set(value);
                    break;
                }
                case KILL_WITHER: {
                    this.killedWither.set(value);
                    break;
                }
                case USE_DRAGONS_PEARL: {
                    this.usedDragonsPearl.set(value);
                    break;
                }
                case KILL_DRAGON: {
                    this.killedDragon.set(value);
                    break;
                }
                case EXIT_END: {
                    this.exitEnd.set(value);
                    break;
                }
                case MINE_EXPERIENCE_ORE: {
                    this.brokenExperienceOre.set(value);
                    break;
                }
                case CRAFT_SPEEDRUNNERS_WORKBENCH: {
                    this.obtainedSpeedrunnersWorkbench.set(value);
                    break;
                }
                case TRANSFER_ENCHANTMENTS: {
                    this.transferedEnchantments.set(value);
                    break;
                }
                case INTERACT_WITH_RETIRED_SPEEDRUNNER: {
                    this.interactedWithRetiredSpeedrunner.set(value);
                    break;
                }
                case OBTAIN_ENDER_THRUSTER: {
                    this.obtainedEnderThruster.set(value);
                    break;
                }
                case USE_ENTER_THRUSTER: {
                    this.usedEnderThruster.set(value);
                    break;
                }
                case OBTAIN_DRAGONS_SWORD: {
                    this.obtainedDragonsSword.set(value);
                    break;
                }
                case OBTAIN_WITHER_BONE: {
                    this.obtainedWitherBone.set(value);
                    break;
                }
                case OBTAIN_WITHER_SWORD: {
                    this.obtainedWitherSword.set(value);
                    break;
                }
                case OBTAIN_ENDER_MATTER: {
                    this.obtainedEnderMatter.set(value);
                    break;
                }
                case OBTAIN_INFINI_PEARL: {
                    this.obtainedInfiniPearl.set(value);
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ItemMessages implements class_7291
    {
        CHAT(0, "speedrunnermod.options.item_messages.chat"),
        ACTIONBAR(1, "speedrunnermod.options.item_messages.actionbar");

        private static final ItemMessages[] VALUES;
        private final int id;
        private final String translateKey;

        private ItemMessages(int id, String translationKey) {
            this.id = id;
            this.translateKey = Objects.requireNonNull(translationKey, "translateKey");
        }

        public int method_7362() {
            return this.id;
        }

        public String method_7359() {
            return this.translateKey;
        }

        public static ItemMessages byId(int id) {
            return VALUES[class_3532.method_15387((int)id, (int)VALUES.length)];
        }

        static {
            VALUES = (ItemMessages[])Arrays.stream(ItemMessages.values()).sorted(Comparator.comparingInt(ItemMessages::method_7362)).toArray(ItemMessages[]::new);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Handler
    extends BaseOptions<ClientModOptions> {
        protected Handler() {
            super("speedrunnermod-client_config_1.11.1.json");
        }

        @Override
        protected ClientModOptions createDefault() {
            return new ClientModOptions();
        }

        @Override
        protected Class<ClientModOptions> getConfigClass() {
            return ClientModOptions.class;
        }

        @Override
        protected void safeCheck() {
            if (SpeedrunnerModClient.clientOptions().client.itemMessages.getCurrentValue() == null) {
                this.setBroken(SpeedrunnerModClient.clientOptions().client.itemMessages, "itemMessages");
            }
            if (SpeedrunnerModClient.clientOptions().client.gameMode.getCurrentValue() == null) {
                this.setBroken(SpeedrunnerModClient.clientOptions().client.gameMode, "gameMode");
            }
            if (SpeedrunnerModClient.clientOptions().client.difficulty.getCurrentValue() == null) {
                this.setBroken(SpeedrunnerModClient.clientOptions().client.difficulty, "difficulty");
            }
            if (!ModOptions.isIntegerOptionValid(SpeedrunnerModClient.clientOptions().client.iCarusFireworksInventorySlot)) {
                this.setBroken(SpeedrunnerModClient.clientOptions().client.iCarusFireworksInventorySlot, "iCarusFireworksInventorySlot");
            }
            if (!ModOptions.isIntegerOptionValid(SpeedrunnerModClient.clientOptions().client.infiniPearlInventorySlot)) {
                this.setBroken(SpeedrunnerModClient.clientOptions().client.infiniPearlInventorySlot, "infiniPearlInventorySlot");
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Difficulty implements class_7291
    {
        PEACEFUL(0, "speedrunnermod.options.difficulty.peaceful"),
        EASY(1, "speedrunnermod.options.difficulty.easy"),
        NORMAL(2, "speedrunnermod.options.difficulty.normal"),
        HARD(3, "speedrunnermod.options.difficulty.hard");

        private static final Difficulty[] VALUES;
        private final int id;
        private final String translateKey;

        private Difficulty(int id, String translationKey) {
            this.id = id;
            this.translateKey = Objects.requireNonNull(translationKey, "translateKey");
        }

        public int method_7362() {
            return this.id;
        }

        public String method_7359() {
            return this.translateKey;
        }

        public static Difficulty byId(int id) {
            return VALUES[class_3532.method_15387((int)id, (int)VALUES.length)];
        }

        static {
            VALUES = (Difficulty[])Arrays.stream(Difficulty.values()).sorted(Comparator.comparingInt(Difficulty::method_7362)).toArray(Difficulty[]::new);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum GameMode implements class_7291
    {
        SURVIVAL(0, "speedrunnermod.options.gamemode.survival"),
        CREATIVE(1, "speedrunnermod.options.gamemode.creative"),
        HARDCORE(2, "speedrunnermod.options.gamemode.hardcore"),
        SPECTATOR(3, "speedrunnermod.options.gamemode.spectator");

        private static final GameMode[] VALUES;
        private final int id;
        private final String translateKey;

        private GameMode(int id, String translationKey) {
            this.id = id;
            this.translateKey = Objects.requireNonNull(translationKey, "translateKey");
        }

        public int method_7362() {
            return this.id;
        }

        public String method_7359() {
            return this.translateKey;
        }

        public static GameMode byId(int id) {
            return VALUES[class_3532.method_15387((int)id, (int)VALUES.length)];
        }

        static {
            VALUES = (GameMode[])Arrays.stream(GameMode.values()).sorted(Comparator.comparingInt(GameMode::method_7362)).toArray(GameMode[]::new);
        }
    }
}

