/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.option;

import java.util.ArrayList;
import java.util.List;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.main.SpeedrunnerModClient;
import net.dillon.speedrunnermod.option.ClientModOptions;
import net.dillon.speedrunnermod.option.ModOptions;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

@Deprecated
@Environment(value=EnvType.CLIENT)
public class Leaderboards {
    public static List<class_2561> ineligibleOptions = new ArrayList<class_2561>();
    private static final ModOptions.Main options = SpeedrunnerMod.options().main;
    private static final ClientModOptions.Client cloptions = SpeedrunnerModClient.clientOptions().client;
    private static boolean currentLeaderboardsMode;
    private static ModOptions.StructureSpawnRate currentStructureSpawnRates;
    private static int currentBlockBreakingMultiplier;
    private static int currentDragonPerchTime;
    private static ClientModOptions.Difficulty currentDifficulty;
    private static int currentStrongholdCount;
    private static int currentStrongholdDistance;
    private static int currentStrongholdSpread;
    private static int currentStrongholdPortalRoomCount;
    private static int currentStrongholdLibrariesCount;
    private static int currentAnvilCostLimit;
    private static int currentNetherPortalCooldown;

    public static void initializeLeaderboards() {
    }

    public static boolean isEligibleForLeaderboardRuns() {
        return Leaderboards.areStructureSpawnRatesEligible() && Leaderboards.isDragonPerchTimeEligible() && Leaderboards.isBlockBreakingMultiplierEligible() && Leaderboards.isDifficultyEligible() && Leaderboards.isStrongholdCountEligible() && Leaderboards.isStrongholdDistanceEligible() && Leaderboards.isStrongholdSpreadEligible() && Leaderboards.isStrongholdPortalRoomsEligible() && Leaderboards.isStrongholdLibrariesEligible() && Leaderboards.isAnvilCostLimitEligible() && Leaderboards.isNetherPortalCooldownEligible() && Leaderboards.isFasterSpawnersEligible() && Leaderboards.isIcarusModeEligible() && Leaderboards.isInfiniPearlModeEligible() && Leaderboards.isFallDamageEligible() && Leaderboards.isKineticDamageEligible() && Leaderboards.isAllowCheatsEligible() && Leaderboards.isKillGhastOnFireballEligible();
    }

    public static void checkForIneligibleOptions() {
        ineligibleOptions.clear();
        if (!Leaderboards.areStructureSpawnRatesEligible()) {
            Leaderboards.warnIneligible("Structure Spawn Rates");
            Leaderboards.addIneligible("structure_spawn_rates", Leaderboards.withFormatting(Leaderboards.options.structureSpawnRates.toString(), ModOptions.isSsrEverywhere() ? class_124.field_1075 : (ModOptions.isSsrDefault() || ModOptions.isSsrDefault() ? class_124.field_1068 : (ModOptions.isSsrRare() ? class_124.field_1076 : (ModOptions.isSsrVeryRare() ? class_124.field_1064 : class_124.field_1061))), class_124.field_1067));
        }
        if (!Leaderboards.isDragonPerchTimeEligible()) {
            Leaderboards.warnIneligible("Dragon Perch Time");
            Leaderboards.addIneligible("dragon_perch_time", Leaderboards.withFormatting((Integer)Leaderboards.options.dragonPerchTime.getCurrentValue(), class_124.field_1061, class_124.field_1067));
        }
        if (!Leaderboards.isBlockBreakingMultiplierEligible()) {
            Leaderboards.warnIneligible("Block Breaking Multiplier");
            Leaderboards.addIneligible("block_breaking_multiplier", Leaderboards.withFormatting((Integer)Leaderboards.options.blockBreakingMultiplier.getCurrentValue(), class_124.field_1061, class_124.field_1067));
        }
        if (!Leaderboards.isDifficultyEligible()) {
            Leaderboards.warnIneligible("Difficulty");
            Leaderboards.addIneligible("difficulty", Leaderboards.withFormatting(Leaderboards.cloptions.difficulty.toString(), class_124.field_1067));
        }
        if (!Leaderboards.isStrongholdCountEligible()) {
            Leaderboards.warnIneligible("Stronghold Count");
            Leaderboards.addIneligible("stronghold_count", Leaderboards.withFormatting((Integer)Leaderboards.options.strongholdCount.getCurrentValue(), class_124.field_1061, class_124.field_1067));
        }
        if (!Leaderboards.isStrongholdDistanceEligible()) {
            Leaderboards.warnIneligible("Stronghold Distance");
            Leaderboards.addIneligible("stronghold_distance", Leaderboards.withFormatting((Integer)Leaderboards.options.strongholdDistance.getCurrentValue(), class_124.field_1061, class_124.field_1067));
        }
        if (!Leaderboards.isStrongholdSpreadEligible()) {
            Leaderboards.warnIneligible("Stronghold Spread");
            Leaderboards.addIneligible("stronghold_spread", Leaderboards.withFormatting((Integer)Leaderboards.options.strongholdSpread.getCurrentValue(), class_124.field_1061, class_124.field_1067));
        }
        if (!Leaderboards.isStrongholdPortalRoomsEligible()) {
            Leaderboards.warnIneligible("Stronghold Portal Room Count");
            Leaderboards.addIneligible("stronghold_portal_room_count", Leaderboards.withFormatting((Integer)Leaderboards.options.strongholdPortalRoomCount.getCurrentValue(), class_124.field_1061, class_124.field_1067));
        }
        if (!Leaderboards.isStrongholdLibrariesEligible()) {
            Leaderboards.warnIneligible("Stronghold Library Count");
            Leaderboards.addIneligible("stronghold_library_count", Leaderboards.withFormatting((Integer)Leaderboards.options.strongholdLibraryCount.getCurrentValue(), class_124.field_1061, class_124.field_1067));
        }
        if (!Leaderboards.isAnvilCostLimitEligible()) {
            Leaderboards.warnIneligible("Anvil Cost Limit");
            Leaderboards.addIneligible("anvil_cost_limit", Leaderboards.withFormatting((Integer)Leaderboards.options.anvilCostLimit.getCurrentValue(), class_124.field_1061, class_124.field_1067));
        }
        if (!Leaderboards.isNetherPortalCooldownEligible()) {
            Leaderboards.warnIneligible("Nether Portal Cooldown");
            Leaderboards.addIneligible("nether_portal_cooldown", Leaderboards.withFormatting((Integer)Leaderboards.options.netherPortalDelay.getCurrentValue(), class_124.field_1061, class_124.field_1067));
        }
        if (!Leaderboards.isIcarusModeEligible()) {
            Leaderboards.warnIneligible("iCarus Mode");
            Leaderboards.addIneligible("icarus_mode", new Object[0]);
        }
        if (!Leaderboards.isInfiniPearlModeEligible()) {
            Leaderboards.warnIneligible("Infini Pearl Mode");
            Leaderboards.addIneligible("infini_pearl_mode", new Object[0]);
        }
        if (!Leaderboards.isFallDamageEligible()) {
            Leaderboards.warnIneligible("Fall Damage");
            Leaderboards.addIneligible("fall_damage", new Object[0]);
        }
        if (!Leaderboards.isKineticDamageEligible()) {
            Leaderboards.warnIneligible("Kinetic Damage");
            Leaderboards.addIneligible("kinetic_damage", new Object[0]);
        }
        if (!Leaderboards.isAllowCheatsEligible()) {
            Leaderboards.warnIneligible("Allow Cheats");
            Leaderboards.addIneligible("allow_cheats", new Object[0]);
        }
        if (!Leaderboards.isKillGhastOnFireballEligible()) {
            Leaderboards.warnIneligible("Kill Ghast On Fireball");
            Leaderboards.addIneligible("kill_ghast_on_fireball", new Object[0]);
        }
        if (!Leaderboards.isFasterSpawnersEligible()) {
            Leaderboards.warnIneligible("Faster Spawners");
            Leaderboards.addIneligible("faster_spawners", new Object[0]);
        }
    }

    public static void getCurrentOptions() {
        currentStructureSpawnRates = Leaderboards.options.structureSpawnRates.getCurrentValue();
        currentBlockBreakingMultiplier = (Integer)Leaderboards.options.blockBreakingMultiplier.getCurrentValue();
        currentDragonPerchTime = (Integer)Leaderboards.options.dragonPerchTime.getCurrentValue();
        currentDifficulty = Leaderboards.cloptions.difficulty.getCurrentValue();
        currentStrongholdCount = (Integer)Leaderboards.options.strongholdCount.getCurrentValue();
        currentStrongholdDistance = (Integer)Leaderboards.options.strongholdDistance.getCurrentValue();
        currentStrongholdSpread = (Integer)Leaderboards.options.strongholdSpread.getCurrentValue();
        currentStrongholdPortalRoomCount = (Integer)Leaderboards.options.strongholdPortalRoomCount.getCurrentValue();
        currentStrongholdLibrariesCount = (Integer)Leaderboards.options.strongholdLibraryCount.getCurrentValue();
        currentAnvilCostLimit = (Integer)Leaderboards.options.anvilCostLimit.getCurrentValue();
        currentNetherPortalCooldown = (Integer)Leaderboards.options.netherPortalDelay.getCurrentValue();
    }

    public static void getCurrentLeaderboardsMode() {
        currentLeaderboardsMode = Leaderboards.options.leaderboardsMode.getCurrentValue();
    }

    public static boolean wasLeaderboardsModeChanged() {
        return currentLeaderboardsMode != Leaderboards.options.leaderboardsMode.getCurrentValue();
    }

    public static boolean noOptionsWereChanged() {
        return currentStructureSpawnRates == Leaderboards.options.structureSpawnRates.getCurrentValue() && currentDragonPerchTime == (Integer)Leaderboards.options.dragonPerchTime.getCurrentValue() && currentBlockBreakingMultiplier == (Integer)Leaderboards.options.blockBreakingMultiplier.getCurrentValue() && currentDifficulty == Leaderboards.cloptions.difficulty.getCurrentValue() && currentStrongholdCount == (Integer)Leaderboards.options.strongholdCount.getCurrentValue() && currentStrongholdDistance == (Integer)Leaderboards.options.strongholdDistance.getCurrentValue() && currentStrongholdSpread == (Integer)Leaderboards.options.strongholdSpread.getCurrentValue() && currentStrongholdPortalRoomCount == (Integer)Leaderboards.options.strongholdPortalRoomCount.getCurrentValue() && currentStrongholdLibrariesCount == (Integer)Leaderboards.options.strongholdLibraryCount.getCurrentValue() && currentAnvilCostLimit == (Integer)Leaderboards.options.anvilCostLimit.getCurrentValue() && currentNetherPortalCooldown == (Integer)Leaderboards.options.netherPortalDelay.getCurrentValue();
    }

    public static void fixOptions() {
        if (!Leaderboards.areStructureSpawnRatesEligible()) {
            Leaderboards.options.structureSpawnRates.reset();
        }
        if (!Leaderboards.isDragonPerchTimeEligible()) {
            Leaderboards.options.dragonPerchTime.reset();
        }
        if (!Leaderboards.isBlockBreakingMultiplierEligible()) {
            Leaderboards.options.blockBreakingMultiplier.reset();
        }
        if (!Leaderboards.isDifficultyEligible()) {
            Leaderboards.cloptions.difficulty.reset();
        }
        if (!Leaderboards.isStrongholdCountEligible()) {
            Leaderboards.options.strongholdCount.reset();
        }
        if (!Leaderboards.isStrongholdDistanceEligible()) {
            Leaderboards.options.strongholdDistance.reset();
        }
        if (!Leaderboards.isStrongholdSpreadEligible()) {
            Leaderboards.options.strongholdSpread.reset();
        }
        if (!Leaderboards.isStrongholdPortalRoomsEligible()) {
            Leaderboards.options.strongholdPortalRoomCount.reset();
        }
        if (!Leaderboards.isStrongholdLibrariesEligible()) {
            Leaderboards.options.strongholdLibraryCount.reset();
        }
        if (!Leaderboards.isAnvilCostLimitEligible()) {
            Leaderboards.options.anvilCostLimit.reset();
        }
        if (!Leaderboards.isNetherPortalCooldownEligible()) {
            Leaderboards.options.netherPortalDelay.reset();
        }
        if (!Leaderboards.isFasterSpawnersEligible()) {
            Leaderboards.options.fasterSpawners.reset();
        }
        Leaderboards.fixBooleanOptions();
    }

    public static void revertChanges() {
        if (Leaderboards.wasLeaderboardsModeChanged()) {
            Leaderboards.options.leaderboardsMode.set(true);
        }
        if (!Leaderboards.areStructureSpawnRatesEligible()) {
            Leaderboards.options.structureSpawnRates.set(currentStructureSpawnRates);
        }
        if (!Leaderboards.isBlockBreakingMultiplierEligible()) {
            Leaderboards.options.blockBreakingMultiplier.set(currentBlockBreakingMultiplier);
        }
        if (!Leaderboards.isDragonPerchTimeEligible()) {
            Leaderboards.options.dragonPerchTime.set(currentDragonPerchTime);
        }
        if (!Leaderboards.isDifficultyEligible()) {
            Leaderboards.cloptions.difficulty.set(currentDifficulty);
        }
        if (!Leaderboards.isStrongholdCountEligible()) {
            Leaderboards.options.strongholdCount.set(currentStrongholdCount);
        }
        if (!Leaderboards.isStrongholdDistanceEligible()) {
            Leaderboards.options.strongholdDistance.set(currentStrongholdDistance);
        }
        if (!Leaderboards.isStrongholdSpreadEligible()) {
            Leaderboards.options.strongholdSpread.set(currentStrongholdSpread);
        }
        if (!Leaderboards.isStrongholdPortalRoomsEligible()) {
            Leaderboards.options.strongholdPortalRoomCount.set(currentStrongholdPortalRoomCount);
        }
        if (!Leaderboards.isStrongholdLibrariesEligible()) {
            Leaderboards.options.strongholdLibraryCount.set(currentStrongholdLibrariesCount);
        }
        if (!Leaderboards.isAnvilCostLimitEligible()) {
            Leaderboards.options.anvilCostLimit.set(currentAnvilCostLimit);
        }
        if (!Leaderboards.isNetherPortalCooldownEligible()) {
            Leaderboards.options.netherPortalDelay.set(currentAnvilCostLimit);
        }
        Leaderboards.fixBooleanOptions();
    }

    private static void fixBooleanOptions() {
        if (!Leaderboards.isIcarusModeEligible()) {
            Leaderboards.options.iCarusMode.reset();
        }
        if (!Leaderboards.isInfiniPearlModeEligible()) {
            Leaderboards.options.infiniPearlMode.reset();
        }
        if (!Leaderboards.isFallDamageEligible()) {
            Leaderboards.options.fallDamage.reset();
        }
        if (!Leaderboards.isKineticDamageEligible()) {
            Leaderboards.options.kineticDamage.reset();
        }
        if (!Leaderboards.isAllowCheatsEligible()) {
            Leaderboards.cloptions.allowCheats.reset();
        }
        if (!Leaderboards.isKillGhastOnFireballEligible()) {
            Leaderboards.options.killGhastOnFireball.reset();
        }
    }

    private static void addIneligible(String translation, Object ... args) {
        class_5250 baseText = class_2561.method_43469((String)("speedrunnermod.leaderboards.ineligible_options." + translation), (Object[])args);
        if (!ineligibleOptions.contains(baseText)) {
            ineligibleOptions.add((class_2561)baseText);
        }
    }

    private static class_2561 withFormatting(String optionString, class_124 ... formatting) {
        return class_2561.method_43471((String)optionString).method_27695(formatting);
    }

    private static class_2561 withFormatting(int intOption, class_124 ... formatting) {
        return class_2561.method_43471((String)String.valueOf(intOption)).method_27695(formatting);
    }

    public static void disableLeaderboardsMode() {
        SpeedrunnerMod.info("Disabling leaderboards mode and closing game. Re-launch to apply changes.");
        SpeedrunnerMod.options().main.leaderboardsMode.set(false);
        SpeedrunnerMod.saveDedicatedServerChanges();
        if (!SpeedrunnerMod.isEnvironmentTypeServer()) {
            SpeedrunnerModClient.saveClientChanges();
        }
    }

    public static void sendIgnoreWarning() {
        SpeedrunnerMod.warn("Proceeding. Because you chose to ignore, you will not be able to submit any speedruns to the leaderboards, unless you re-enable the leaderboards mode and restart your game.");
    }

    private static void warnIneligible(String optionName) {
        SpeedrunnerMod.warn("Current Option \"" + optionName + "\" is ineligible for a leaderboard submission.");
    }

    private static boolean areStructureSpawnRatesEligible() {
        return ModOptions.isSsrVeryCommon() || ModOptions.isSsrCommon() || ModOptions.isSsrNormal();
    }

    private static boolean isBlockBreakingMultiplierEligible() {
        return (Integer)Leaderboards.options.blockBreakingMultiplier.getCurrentValue() == 1;
    }

    private static boolean isDragonPerchTimeEligible() {
        return ModOptions.isInBounds((Integer)Leaderboards.options.dragonPerchTime.getCurrentValue(), 8, 90);
    }

    private static boolean isDifficultyEligible() {
        return SpeedrunnerModClient.clientOptions().client.difficulty.getCurrentValue() != ClientModOptions.Difficulty.PEACEFUL;
    }

    private static boolean isStrongholdCountEligible() {
        return ModOptions.isInBounds((Integer)Leaderboards.options.strongholdCount.getCurrentValue(), 128, 156);
    }

    private static boolean isStrongholdDistanceEligible() {
        return ModOptions.isInBounds((Integer)Leaderboards.options.strongholdDistance.getCurrentValue(), 3, 18);
    }

    private static boolean isStrongholdSpreadEligible() {
        return ModOptions.isInBounds((Integer)Leaderboards.options.strongholdSpread.getCurrentValue(), 2, 12);
    }

    private static boolean isStrongholdPortalRoomsEligible() {
        return ModOptions.isInBounds((Integer)Leaderboards.options.strongholdPortalRoomCount.getCurrentValue(), 1, 3);
    }

    private static boolean isStrongholdLibrariesEligible() {
        return ModOptions.isInBounds((Integer)Leaderboards.options.strongholdLibraryCount.getCurrentValue(), 1, 4);
    }

    private static boolean isAnvilCostLimitEligible() {
        return ModOptions.isInBounds((Integer)Leaderboards.options.anvilCostLimit.getCurrentValue(), 10);
    }

    private static boolean isNetherPortalCooldownEligible() {
        return ModOptions.isInBounds((Integer)Leaderboards.options.netherPortalDelay.getCurrentValue(), 1, 20);
    }

    private static boolean isFasterSpawnersEligible() {
        return Leaderboards.options.fasterSpawners.getCurrentValue();
    }

    private static boolean isIcarusModeEligible() {
        return Leaderboards.options.iCarusMode.getCurrentValue() == false;
    }

    private static boolean isInfiniPearlModeEligible() {
        return Leaderboards.options.infiniPearlMode.getCurrentValue() == false;
    }

    private static boolean isFallDamageEligible() {
        return Leaderboards.options.fallDamage.getCurrentValue();
    }

    private static boolean isKineticDamageEligible() {
        return Leaderboards.options.kineticDamage.getCurrentValue();
    }

    private static boolean isAllowCheatsEligible() {
        return Leaderboards.cloptions.allowCheats.getCurrentValue() == false;
    }

    private static boolean isKillGhastOnFireballEligible() {
        return Leaderboards.options.killGhastOnFireball.getCurrentValue() == false;
    }
}

