/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.option;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.option.BaseOptions;
import net.dillon.speedrunnermod.option.IntegerOptionValue;
import net.dillon.speedrunnermod.option.OptionValue;
import net.dillon.speedrunnermod.util.ModUtil;
import net.minecraft.class_3532;
import net.minecraft.class_7291;

public class ModOptions {
    public final Main main = new Main();
    public final Advanced advanced = new Advanced();
    public final CustomStructureSpawnRates customStructureSpawnRates = new CustomStructureSpawnRates();
    public final Mixins mixins = new Mixins();
    public static final Handler OPTIONS = new Handler();

    public static boolean isIntegerOptionValid(IntegerOptionValue option) {
        return ModOptions.isInBounds((Integer)option.getCurrentValue(), option.getMinValue(), option.getMaxValue());
    }

    public boolean isDragonPerchTimeOn() {
        return ModOptions.isInBounds((Integer)this.main.dragonPerchTime.getCurrentValue(), 10);
    }

    public boolean isInstantDragonPerchTime() {
        return (Integer)SpeedrunnerMod.options().main.dragonPerchTime.getCurrentValue() == 9;
    }

    public int getDragonPerchTime() {
        return ModUtil.millisecondsAsSeconds((Integer)SpeedrunnerMod.options().main.dragonPerchTime.getCurrentValue());
    }

    public int getEnderEyeBreakingCooldown() {
        return ModUtil.secondsAsTicks((Integer)SpeedrunnerMod.options().advanced.enderEyeBreakingCooldown.getCurrentValue());
    }

    public static boolean isInBounds(int option, int min) {
        return option >= min;
    }

    public static boolean isInBounds(int option, int min, int max) {
        return option >= min && option <= max;
    }

    public static boolean isEasyMode() {
        return SpeedrunnerMod.options().main.mode.getCurrentValue().equals((Object)Mode.EASY);
    }

    public static boolean isBalancedMode() {
        return SpeedrunnerMod.options().main.mode.getCurrentValue().equals((Object)Mode.BALANCED);
    }

    public static boolean isDoomMode() {
        return SpeedrunnerMod.options().main.mode.getCurrentValue().equals((Object)Mode.DOOM);
    }

    public static boolean isSsrEverywhere() {
        return SpeedrunnerMod.options().main.structureSpawnRates.getCurrentValue().equals((Object)StructureSpawnRate.EVERYWHERE);
    }

    public static boolean isSsrVeryCommon() {
        return SpeedrunnerMod.options().main.structureSpawnRates.getCurrentValue().equals((Object)StructureSpawnRate.VERY_COMMON);
    }

    public static boolean isSsrVeryCommonCommon() {
        return SpeedrunnerMod.options().main.structureSpawnRates.getCurrentValue().equals((Object)StructureSpawnRate.VERY_COMMON) || SpeedrunnerMod.options().main.structureSpawnRates.getCurrentValue().equals((Object)StructureSpawnRate.COMMON);
    }

    public static boolean isSsrCommon() {
        return SpeedrunnerMod.options().main.structureSpawnRates.getCurrentValue().equals((Object)StructureSpawnRate.COMMON);
    }

    public static boolean isSsrNormal() {
        return SpeedrunnerMod.options().main.structureSpawnRates.getCurrentValue().equals((Object)StructureSpawnRate.NORMAL);
    }

    public static boolean isSsrDefault() {
        return SpeedrunnerMod.options().main.structureSpawnRates.getCurrentValue().equals((Object)StructureSpawnRate.DEFAULT);
    }

    public static boolean isSsrRare() {
        return SpeedrunnerMod.options().main.structureSpawnRates.getCurrentValue().equals((Object)StructureSpawnRate.RARE);
    }

    public static boolean isSsrVeryRare() {
        return SpeedrunnerMod.options().main.structureSpawnRates.getCurrentValue().equals((Object)StructureSpawnRate.VERY_RARE);
    }

    public static boolean isSsrCustom() {
        return SpeedrunnerMod.options().main.structureSpawnRates.getCurrentValue().equals((Object)StructureSpawnRate.CUSTOM);
    }

    public static void isSafe(boolean safe) {
        SpeedrunnerMod.safeBoot = !safe;
    }

    public static class Main {
        public OptionValue<Mode> mode = new OptionValue<Mode>(Mode.EASY, true);
        public OptionValue<StructureSpawnRate> structureSpawnRates = new OptionValue<StructureSpawnRate>(StructureSpawnRate.COMMON, false);
        public OptionValue<Boolean> fasterBlockBreaking = new OptionValue<Boolean>(true, false);
        public IntegerOptionValue blockBreakingMultiplier = new IntegerOptionValue(1, false, 1, 3);
        public OptionValue<Boolean> iCarusMode = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> infiniPearlMode = new OptionValue<Boolean>(false, false);
        public IntegerOptionValue dragonPerchTime = new IntegerOptionValue(8, false, 8, 90);
        public OptionValue<Boolean> killGhastOnFireball = new OptionValue<Boolean>(false, false);
        public OptionValue<Boolean> betterVillagerTrades = new OptionValue<Boolean>(true, true);
        public OptionValue<Boolean> fireproofItems = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> betterBiomes = new OptionValue<Boolean>(true, true);
        public OptionValue<Boolean> customBiomesAndCustomBiomeFeatures = new OptionValue<Boolean>(true, true);
        public OptionValue<Boolean> commonOres = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> lavaBoats = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> netherWater = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> betterFoods = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> fallDamage = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> kineticDamage = new OptionValue<Boolean>(true, false);
        public IntegerOptionValue strongholdDistance = new IntegerOptionValue(4, true, 3, 64);
        public IntegerOptionValue strongholdSpread = new IntegerOptionValue(3, true, 2, 32);
        public IntegerOptionValue strongholdCount = new IntegerOptionValue(128, true, 4, 156);
        public IntegerOptionValue strongholdPortalRoomCount = new IntegerOptionValue(3, true, 1, 3);
        public IntegerOptionValue strongholdLibraryCount = new IntegerOptionValue(2, true, 1, 8);
        public OptionValue<MobSpawningRate> mobSpawningRate = new OptionValue<MobSpawningRate>(MobSpawningRate.HIGH, false);
        public IntegerOptionValue netherPortalDelay = new IntegerOptionValue(2, false, -1, 20);
        public OptionValue<Boolean> throwableFireballs = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> arrowsDestroyBeds = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> globalNetherPortals = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> betterAnvil = new OptionValue<Boolean>(true, false);
        public IntegerOptionValue anvilCostLimit = new IntegerOptionValue(10, false, 1, 50);
        public OptionValue<Boolean> higherEnchantmentLevels = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> rightClickToRemoveSilkTouch = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> fasterSpawners = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> showDeathCords = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> customDataGeneration = new OptionValue<Boolean>(true, false);
        @Deprecated
        public OptionValue<Boolean> leaderboardsMode = new OptionValue<Boolean>(false, true);
    }

    public static class Advanced {
        public OptionValue<Boolean> modifiedStrongholdGeneration = new OptionValue<Boolean>(true, true);
        public OptionValue<Boolean> modifiedStrongholdYGeneration = new OptionValue<Boolean>(true, true);
        public OptionValue<Boolean> modifiedNetherFortressGeneration = new OptionValue<Boolean>(true, true);
        public OptionValue<Boolean> higherBreathTime = new OptionValue<Boolean>(true, true);
        public OptionValue<Boolean> generateSpeedrunnerWood = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> longerDragonPerchStayTime = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> decreasedZombifiedPiglinScareDistance = new OptionValue<Boolean>(true, false);
        public IntegerOptionValue enderEyeBreakingCooldown = new IntegerOptionValue(3, false, 1, 10);
        public IntegerOptionValue piglinAwakenerPiglinCount = new IntegerOptionValue(10, false, 3, 25);
        public IntegerOptionValue fireballExplosionPower = new IntegerOptionValue(2, false, 1, 10);
        public OptionValue<Boolean> shiftToThrowFireball = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> dragonKillsNearbyHostileEntities = new OptionValue<Boolean>(true, false);
        public OptionValue<Boolean> dragonImmunityFromGoliathAndWither = new OptionValue<Boolean>(true, false);
        public OptionValue<List<Integer>> annulEyeSearchRadius = new OptionValue<List<Integer>>(ModUtil.createListOption(128, 128, 128), false);
        public OptionValue<List<Integer>> piglinAwakenerSearchRadius = new OptionValue<List<Integer>>(ModUtil.createListOption(100, 100, 100), false);
        public OptionValue<List<Integer>> blazeSpotterSearchRadius = new OptionValue<List<Integer>>(ModUtil.createListOption(156, 72, 156), false);
        public OptionValue<List<Integer>> raidEradicatorSearchRadius = new OptionValue<List<Integer>>(ModUtil.createListOption(300, 300, 300), false);
        public OptionValue<List<Integer>> dragonsPearlSearchRadius = new OptionValue<List<Integer>>(ModUtil.createListOption(150, 150, 150), false);
        public OptionValue<List<Integer>> dragonMassKillRadius = new OptionValue<List<Integer>>(ModUtil.createListOption(200, 200, 200), false);
        public OptionValue<List<Integer>> dragonImmunityDetectionRadiusForGoliath = new OptionValue<List<Integer>>(ModUtil.createListOption(200, 200, 200), false);
        public OptionValue<List<Integer>> dragonImmunityDetectionRadiusForWither = new OptionValue<List<Integer>>(ModUtil.createListOption(300, 300, 300), false);
        public OptionValue<Set<String>> modIds = new OptionValue(new TreeSet(), false);
    }

    public static class CustomStructureSpawnRates {
        public OptionValue<List<Integer>> ancientCities = new OptionValue<List<Integer>>(ModUtil.createStructureSpawnRateOption(16, 8), false);
        public OptionValue<List<Integer>> villages = new OptionValue<List<Integer>>(ModUtil.createStructureSpawnRateOption(16, 8), false);
        public OptionValue<List<Integer>> desertPyramids = new OptionValue<List<Integer>>(ModUtil.createStructureSpawnRateOption(10, 5), false);
        public OptionValue<List<Integer>> junglePyramids = new OptionValue<List<Integer>>(ModUtil.createStructureSpawnRateOption(10, 5), false);
        public OptionValue<List<Integer>> pillagerOutposts = new OptionValue<List<Integer>>(ModUtil.createStructureSpawnRateOption(10, 5), false);
        public OptionValue<List<Integer>> endCities = new OptionValue<List<Integer>>(ModUtil.createStructureSpawnRateOption(7, 3), false);
        public OptionValue<List<Integer>> woodlandMansions = new OptionValue<List<Integer>>(ModUtil.createStructureSpawnRateOption(25, 12), false);
        public OptionValue<List<Integer>> ruinedPortals = new OptionValue<List<Integer>>(ModUtil.createStructureSpawnRateOption(9, 4), false);
        public OptionValue<List<Integer>> shipwrecks = new OptionValue<List<Integer>>(ModUtil.createStructureSpawnRateOption(10, 5), false);
        public OptionValue<List<Integer>> trialChambers = new OptionValue<List<Integer>>(ModUtil.createStructureSpawnRateOption(12, 6), false);
        public OptionValue<List<Integer>> netherComplexes = new OptionValue<List<Integer>>(ModUtil.createStructureSpawnRateOption(8, 4), false);
    }

    public static class Mixins {
        public OptionValue<Boolean> terraBlenderSurfaceRuleDataMixin = new OptionValue<Boolean>(true, true);
    }

    public static enum Mode implements class_7291
    {
        EASY(0, "speedrunnermod.options.mode.easy"),
        BALANCED(1, "speedrunnermod.options.mode.balanced"),
        DOOM(2, "speedrunnermod.options.mode.doom");

        private static final Mode[] VALUES;
        private final int id;
        private final String translateKey;

        private Mode(int id, String translationKey) {
            this.id = id;
            this.translateKey = Objects.requireNonNull(translationKey, "translateKey");
        }

        public int method_7362() {
            return this.id;
        }

        public String method_7359() {
            return this.translateKey;
        }

        public static Mode byId(int id) {
            return VALUES[class_3532.method_15387((int)id, (int)VALUES.length)];
        }

        static {
            VALUES = (Mode[])Arrays.stream(Mode.values()).sorted(Comparator.comparingInt(Mode::method_7362)).toArray(Mode[]::new);
        }
    }

    public static enum StructureSpawnRate implements class_7291
    {
        EVERYWHERE(0, "speedrunnermod.options.structure_spawn_rates.everywhere"),
        VERY_COMMON(1, "speedrunnermod.options.structure_spawn_rates.very_common"),
        COMMON(2, "speedrunnermod.options.structure_spawn_rates.common"),
        NORMAL(3, "speedrunnermod.options.structure_spawn_rates.normal"),
        DEFAULT(4, "speedrunnermod.options.structure_spawn_rates.default"),
        RARE(5, "speedrunnermod.options.structure_spawn_rates.rare"),
        VERY_RARE(6, "speedrunnermod.options.structure_spawn_rates.very_rare"),
        CUSTOM(7, "speedrunnermod.options.structure_spawn_rates.custom");

        private static final StructureSpawnRate[] VALUES;
        private final int id;
        private final String translateKey;

        private StructureSpawnRate(int id, String translationKey) {
            this.id = id;
            this.translateKey = Objects.requireNonNull(translationKey, "translateKey");
        }

        public int method_7362() {
            return this.id;
        }

        public String method_7359() {
            return this.translateKey;
        }

        public static StructureSpawnRate byId(int id) {
            return VALUES[class_3532.method_15387((int)id, (int)VALUES.length)];
        }

        static {
            VALUES = (StructureSpawnRate[])Arrays.stream(StructureSpawnRate.values()).sorted(Comparator.comparingInt(StructureSpawnRate::method_7362)).toArray(StructureSpawnRate[]::new);
        }
    }

    public static class Handler
    extends BaseOptions<ModOptions> {
        protected Handler() {
            super("speedrunnermod-config_1.11.1.json");
        }

        @Override
        protected ModOptions createDefault() {
            return new ModOptions();
        }

        @Override
        protected Class<ModOptions> getConfigClass() {
            return ModOptions.class;
        }

        @Override
        protected void safeCheck() {
            if (SpeedrunnerMod.options().main.mode.getCurrentValue() == null) {
                if (SpeedrunnerMod.isEnvironmentTypeServer()) {
                    this.throwNullPointerException("Mode", (Object[])Mode.values());
                } else {
                    this.setBroken(SpeedrunnerMod.options().main.mode, "mode");
                }
            }
            if (SpeedrunnerMod.options().main.structureSpawnRates.getCurrentValue() == null) {
                if (SpeedrunnerMod.isEnvironmentTypeServer()) {
                    this.throwNullPointerException("Structure Spawn Rates", (Object[])StructureSpawnRate.values());
                } else {
                    this.setBroken(SpeedrunnerMod.options().main.structureSpawnRates, "structureSpawnRates");
                }
            }
            if (SpeedrunnerMod.options().main.mobSpawningRate.getCurrentValue() == null) {
                if (SpeedrunnerMod.isEnvironmentTypeServer()) {
                    this.throwNullPointerException("Mob Spawning Rate", (Object[])MobSpawningRate.values());
                } else {
                    this.setBroken(SpeedrunnerMod.options().main.mobSpawningRate, "mobSpawningRate");
                }
            }
            if (SpeedrunnerMod.options().main.leaderboardsMode.getCurrentValue().booleanValue()) {
                String message = "Leaderboards mode is ON, please disable, as the leaderboards have been deleted.";
                if (SpeedrunnerMod.isEnvironmentTypeServer()) {
                    throw new IllegalStateException(message);
                }
                this.setBroken(SpeedrunnerMod.options().main.leaderboardsMode, message);
            }
            if ((Integer)SpeedrunnerMod.options().main.netherPortalDelay.getCurrentValue() < SpeedrunnerMod.options().main.netherPortalDelay.getMinValue()) {
                if (SpeedrunnerMod.isEnvironmentTypeServer()) {
                    this.throwNumberLessThanOneException("Nether Portal Cooldown");
                } else {
                    this.setBroken(SpeedrunnerMod.options().main.netherPortalDelay, "netherPortalDelay");
                }
            } else if (!ModOptions.isIntegerOptionValid(SpeedrunnerMod.options().main.netherPortalDelay)) {
                SpeedrunnerMod.warn("Found an unusual value in the speedrunner mod settings. Pertaining to: speedrunnermod.options.netherPortalCooldown");
            }
            if ((Integer)SpeedrunnerMod.options().main.strongholdDistance.getCurrentValue() < 1) {
                if (SpeedrunnerMod.isEnvironmentTypeServer()) {
                    this.throwNumberLessThanOneException("Stronghold Distance");
                } else {
                    this.setBroken(SpeedrunnerMod.options().main.strongholdDistance, "strongholdDistance");
                }
            } else if (!ModOptions.isIntegerOptionValid(SpeedrunnerMod.options().main.strongholdDistance)) {
                SpeedrunnerMod.warn("Found an unusual value in the speedrunner mod settings. Pertaining to: speedrunnermod.options.strongholdDistance");
            }
            if ((Integer)SpeedrunnerMod.options().main.strongholdSpread.getCurrentValue() < 1) {
                if (SpeedrunnerMod.isEnvironmentTypeServer()) {
                    this.throwNumberLessThanOneException("Stronghold Spread");
                } else {
                    this.setBroken(SpeedrunnerMod.options().main.strongholdSpread, "strongholdSpread");
                }
            } else if (!ModOptions.isIntegerOptionValid(SpeedrunnerMod.options().main.strongholdSpread)) {
                SpeedrunnerMod.warn("Found an unusual value in the speedrunner mod settings. Pertaining to: speedrunnermod.options.strongholdSpread");
            }
            if ((Integer)SpeedrunnerMod.options().main.strongholdCount.getCurrentValue() < 1) {
                if (SpeedrunnerMod.isEnvironmentTypeServer()) {
                    this.throwNumberLessThanOneException("Stronghold Count");
                } else {
                    this.setBroken(SpeedrunnerMod.options().main.strongholdCount, "strongholdCount");
                }
            } else if (!ModOptions.isIntegerOptionValid(SpeedrunnerMod.options().main.strongholdCount)) {
                SpeedrunnerMod.warn("Found an unusual value in the speedrunner mod settings. Pertaining to: speedrunnermod.options.strongholdCount");
            }
            if ((Integer)SpeedrunnerMod.options().main.strongholdPortalRoomCount.getCurrentValue() < 1) {
                if (SpeedrunnerMod.isEnvironmentTypeServer()) {
                    this.throwNumberLessThanOneException("Stronghold Portal Room Count");
                } else {
                    this.setBroken(SpeedrunnerMod.options().main.strongholdPortalRoomCount, "strongholdPortalRoomCount");
                }
            } else if (!ModOptions.isIntegerOptionValid(SpeedrunnerMod.options().main.strongholdPortalRoomCount)) {
                SpeedrunnerMod.warn("Found an unusual value in the speedrunner mod settings. Pertaining to: speedrunnermod.options.strongholdPortalRoomCount");
            }
            if ((Integer)SpeedrunnerMod.options().main.strongholdLibraryCount.getCurrentValue() < 1) {
                if (SpeedrunnerMod.isEnvironmentTypeServer()) {
                    this.throwNumberLessThanOneException("Stronghold Library Count");
                } else {
                    this.setBroken(SpeedrunnerMod.options().main.strongholdLibraryCount, "strongholdLibraryCount");
                }
            } else if (!ModOptions.isIntegerOptionValid(SpeedrunnerMod.options().main.strongholdLibraryCount)) {
                SpeedrunnerMod.warn("Found an unusual value in the speedrunner mod settings. Pertaining to: speedrunnermod.options.strongholdLibraryCount");
            }
            if ((Integer)SpeedrunnerMod.options().main.blockBreakingMultiplier.getCurrentValue() < 1) {
                if (SpeedrunnerMod.isEnvironmentTypeServer()) {
                    throw new ArithmeticException("blockBreakingMultiplier cannot be set to a value less than 1.");
                }
                this.setBroken(SpeedrunnerMod.options().main.blockBreakingMultiplier, "blockBreakingMultiplier");
                SpeedrunnerMod.warn("Cannot divide by zero! o_0");
            } else if (!ModOptions.isIntegerOptionValid(SpeedrunnerMod.options().main.blockBreakingMultiplier)) {
                SpeedrunnerMod.warn("Found an unusual value in the speedrunner mod settings. Pertaining to: speedrunnermod.options.blockBreakingMultiplier");
            }
            if (!ModOptions.isIntegerOptionValid(SpeedrunnerMod.options().main.dragonPerchTime)) {
                SpeedrunnerMod.warn("Found an unusual value in the speedrunner mod settings. Pertaining to: speedrunnermod.options.dragonPerchTime");
            }
            if (!ModOptions.isIntegerOptionValid(SpeedrunnerMod.options().main.anvilCostLimit)) {
                SpeedrunnerMod.warn("Found an unusual value in the speedrunner mod settings. Pertaining to: speedrunnermod.options.anvilCostLimit");
            }
            if (!ModOptions.isIntegerOptionValid(SpeedrunnerMod.options().advanced.enderEyeBreakingCooldown)) {
                SpeedrunnerMod.warn("Found an unusual value in the speedrunner mod settings. Pertaining to: speedrunnermod.options.eyeOfEnderBreakingCooldown");
            }
        }
    }

    public static enum MobSpawningRate implements class_7291
    {
        LOW(0, "speedrunnermod.options.mob_spawning_rate.low"),
        NORMAL(1, "speedrunnermod.options.mob_spawning_rate.normal"),
        HIGH(2, "speedrunnermod.options.mob_spawning_rate.high");

        private static final MobSpawningRate[] VALUES;
        private final int id;
        private final String translateKey;

        private MobSpawningRate(int id, String translationKey) {
            this.id = id;
            this.translateKey = Objects.requireNonNull(translationKey, "translateKey");
        }

        public int method_7362() {
            return this.id;
        }

        public String method_7359() {
            return this.translateKey;
        }

        public static MobSpawningRate byId(int id) {
            return VALUES[class_3532.method_15387((int)id, (int)VALUES.length)];
        }

        static {
            VALUES = (MobSpawningRate[])Arrays.stream(MobSpawningRate.values()).sorted(Comparator.comparingInt(MobSpawningRate::method_7362)).toArray(MobSpawningRate[]::new);
        }
    }
}

