/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.option;

import java.util.ArrayList;
import java.util.List;
import net.dillon.speedrunnermod.util.AI;

@AI
public class OptionValue<T> {
    private final boolean requiresRestart;
    private final T defaultValue;
    private T currentValue;
    private boolean broken = false;
    private static final List<OptionValue<?>> brokenOptions = new ArrayList();

    public OptionValue(T defaultValue, boolean requiresRestart) {
        this.requiresRestart = requiresRestart;
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
    }

    public T getCurrentValue() {
        return this.currentValue;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean requiresRestart() {
        return this.requiresRestart;
    }

    public void set(T value) {
        this.currentValue = value;
    }

    public void setBroken() {
        this.broken = true;
        brokenOptions.add(this);
    }

    public void setFixed() {
        this.broken = false;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public static List<OptionValue<?>> getBrokenOptions() {
        return brokenOptions;
    }

    public void reset() {
        this.currentValue = this.defaultValue;
    }
}

