/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.packet;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.dillon.speedrunnermod.client.ClientSyncedServerOptions;
import net.dillon.speedrunnermod.client.screen.base.synced.ModeDoesntMatchScreen;
import net.dillon.speedrunnermod.client.screen.base.synced.TimedScreen;
import net.dillon.speedrunnermod.client.screen.feature.FeaturesScreen;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.main.SpeedrunnerModClient;
import net.dillon.speedrunnermod.option.ClientModOptions;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.packet.client.CheckModeS2CPacket;
import net.dillon.speedrunnermod.packet.client.CompleteTutorialStepS2CPacket;
import net.dillon.speedrunnermod.packet.client.MatchClientOptionsWithServerS2CPacket;
import net.dillon.speedrunnermod.packet.client.OpenFeaturesScreenS2CPacket;
import net.dillon.speedrunnermod.packet.client.RequestClientSideOptionsS2CPacket;
import net.dillon.speedrunnermod.packet.client.UpdateLastCompletedTutorialStepTranslationsS2CPacket;
import net.dillon.speedrunnermod.packet.server.ClientPreferencesC2SPacket;
import net.dillon.speedrunnermod.packet.server.MatchServerOptionsWithClientC2SPacket;
import net.dillon.speedrunnermod.packet.server.RequestServerSideOptionsC2SPacket;
import net.dillon.speedrunnermod.packet.server.TutorialStepCompleteC2SPacket;
import net.dillon.speedrunnermod.util.ModTexts;
import net.dillon.speedrunnermod.util.ModUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_1132;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class ClientModPackets {
    private static void registerS2CCheckModePacket() {
        PayloadTypeRegistry.playS2C().register(CheckModeS2CPacket.PACKET, CheckModeS2CPacket.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(CheckModeS2CPacket.PACKET, (packet, context) -> {
            if (SpeedrunnerMod.options().main.mode.getCurrentValue() != packet.serverSideMode()) {
                context.client().method_1562().method_48296().method_10747(ModTexts.MODE_DOESNT_MATCH_SERVER_SETTING);
                context.client().method_18096((class_437)new ModeDoesntMatchScreen(packet.serverSideMode()), false);
            }
        });
    }

    private static void registerS2CCompleteTutorialStep() {
        PayloadTypeRegistry.playS2C().register(CompleteTutorialStepS2CPacket.PACKET, CompleteTutorialStepS2CPacket.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(CompleteTutorialStepS2CPacket.PACKET, (packet, context) -> SpeedrunnerModClient.clientOptions().tutorialMode.completeStep(packet.step(), context.player(), packet.messageKeys().toArray(new String[0])));
    }

    private static void registerS2CMatchClientOptionsWithServer() {
        PayloadTypeRegistry.playS2C().register(MatchClientOptionsWithServerS2CPacket.PACKET, MatchClientOptionsWithServerS2CPacket.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(MatchClientOptionsWithServerS2CPacket.PACKET, (packet, context) -> {
            ModOptions serverOptions = packet.toOptions();
            SpeedrunnerMod.configHandler().match(serverOptions);
            context.client().method_1562().method_48296().method_10747(ModTexts.MATCHED_SETTINGS_WITH_SERVER);
            context.client().method_18096((class_437)new TimedScreen(null, 5), false);
        });
    }

    private static void registerS2COpenFeaturesScreen() {
        PayloadTypeRegistry.playS2C().register(OpenFeaturesScreenS2CPacket.PACKET, OpenFeaturesScreenS2CPacket.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(OpenFeaturesScreenS2CPacket.PACKET, (payload, context) -> context.client().method_1507((class_437)new FeaturesScreen(null)));
    }

    private static void registerS2CRequestClientSideOptions() {
        PayloadTypeRegistry.playS2C().register(RequestClientSideOptionsS2CPacket.PACKET, RequestClientSideOptionsS2CPacket.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(RequestClientSideOptionsS2CPacket.PACKET, (payload, context) -> {
            ClientPlayNetworking.send((class_8710)MatchServerOptionsWithClientC2SPacket.from(SpeedrunnerMod.options(), context.player().method_5477().getString()));
            context.player().method_7353((class_2561)class_2561.method_43471((String)"speedrunnermod.client_options_sent"), false);
        });
    }

    private static void registerS2CUpdateLastCompletedTutorialStepTranslations() {
        PayloadTypeRegistry.playS2C().register(UpdateLastCompletedTutorialStepTranslationsS2CPacket.PACKET, UpdateLastCompletedTutorialStepTranslationsS2CPacket.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(UpdateLastCompletedTutorialStepTranslationsS2CPacket.PACKET, (packet, context) -> ClientSyncedServerOptions.setLastSentTutorialModeMessageTranslations(context.player().method_5667(), packet.lastCompletedTutorialStepTranslations()));
    }

    private static void registerC2SOnServer() {
        if (SpeedrunnerMod.isEnvironmentTypeServer()) {
            PayloadTypeRegistry.playC2S().register(ClientPreferencesC2SPacket.PACKET, ClientPreferencesC2SPacket.CODEC);
            PayloadTypeRegistry.playC2S().register(MatchServerOptionsWithClientC2SPacket.PACKET, MatchServerOptionsWithClientC2SPacket.CODEC);
            PayloadTypeRegistry.playC2S().register(RequestServerSideOptionsC2SPacket.PACKET, RequestServerSideOptionsC2SPacket.CODEC);
            PayloadTypeRegistry.playC2S().register(TutorialStepCompleteC2SPacket.PACKET, TutorialStepCompleteC2SPacket.CODEC);
        }
    }

    private static void registerClientJoinAndDisconnectEvents() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            ModUtil.errorMessagesSent = 0;
            ClientModPackets.sendNewC2SOptions();
            class_746 player = client.field_1724;
            if (player != null) {
                final int delayInTicks = 150;
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ClientModPackets.syncFwc(client, delayInTicks);
                    }
                }, delayInTicks);
                List<String> translations = ClientSyncedServerOptions.getLastSentTutorialModeMessageTranslations(player.method_5667());
                ClientSyncedServerOptions.setLastSentTutorialModeMessageTranslations(player.method_5667(), translations);
                if (ClientSyncedServerOptions.tutorialModeMessageTranslationsContainsPlayerUuid(player.method_5667()) && SpeedrunnerModClient.clientOptions().client.tutorialMode.getCurrentValue().booleanValue()) {
                    for (String s : translations) {
                        ModUtil.sendWithPrefix(s, (class_1657)player);
                    }
                }
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (client.field_1724 != null) {
                ClientSyncedServerOptions.writeAndClearTutorialModeMessageTranslations(client.field_1724.method_5667());
            }
        });
    }

    public static void registerClientPackets() {
        ClientModPackets.registerS2CCheckModePacket();
        ClientModPackets.registerS2CCompleteTutorialStep();
        ClientModPackets.registerS2CMatchClientOptionsWithServer();
        ClientModPackets.registerS2COpenFeaturesScreen();
        ClientModPackets.registerS2CRequestClientSideOptions();
        ClientModPackets.registerS2CUpdateLastCompletedTutorialStepTranslations();
        ClientModPackets.registerC2SOnServer();
        ClientModPackets.registerClientJoinAndDisconnectEvents();
        SpeedrunnerMod.debug("Registered server-to-client packets.");
    }

    public static void syncFwc(class_310 client, int delayTicks) {
        class_1132 integratedServer = client.method_1576();
        if (integratedServer != null) {
            integratedServer.method_3760().method_14607(SpeedrunnerModClient.clientOptions().client.allowCheats.getCurrentValue().booleanValue());
            int i = integratedServer.method_3835(client.field_1724.method_7334());
            client.field_1724.method_3147(i);
            for (class_3222 serverPlayerEntity : integratedServer.method_3760().method_14571()) {
                integratedServer.method_3734().method_9241(serverPlayerEntity);
            }
            SpeedrunnerMod.debug("Synced fast world creation settings with world in " + delayTicks + " ticks.");
        }
    }

    public static void sendNewC2SOptions() {
        ClientModOptions.Client options = SpeedrunnerModClient.clientOptions().client;
        ClientPlayNetworking.send((class_8710)new ClientPreferencesC2SPacket(options.tutorialMode.getCurrentValue(), ClientModOptions.isActionbar(), (Integer)options.iCarusFireworksInventorySlot.getCurrentValue(), (Integer)options.infiniPearlInventorySlot.getCurrentValue()));
    }
}

