/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.packet;

import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.dillon.speedrunnermod.item.ModItems;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.packet.client.CheckModeS2CPacket;
import net.dillon.speedrunnermod.packet.client.CompleteTutorialStepS2CPacket;
import net.dillon.speedrunnermod.packet.client.MatchClientOptionsWithServerS2CPacket;
import net.dillon.speedrunnermod.packet.client.OpenFeaturesScreenS2CPacket;
import net.dillon.speedrunnermod.packet.client.RequestClientSideOptionsS2CPacket;
import net.dillon.speedrunnermod.packet.client.UpdateLastCompletedTutorialStepTranslationsS2CPacket;
import net.dillon.speedrunnermod.packet.server.ClientPreferencesC2SPacket;
import net.dillon.speedrunnermod.packet.server.MatchServerOptionsWithClientC2SPacket;
import net.dillon.speedrunnermod.packet.server.RequestServerSideOptionsC2SPacket;
import net.dillon.speedrunnermod.packet.server.TutorialStepCompleteC2SPacket;
import net.dillon.speedrunnermod.server.ServerStorage;
import net.dillon.speedrunnermod.util.ModUtil;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_8710;

public class ModPackets {
    private static void registerC2SClientPreferences() {
        PayloadTypeRegistry.playC2S().register(ClientPreferencesC2SPacket.PACKET, ClientPreferencesC2SPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ClientPreferencesC2SPacket.PACKET, (packet, context) -> {
            UUID playerUuid = context.player().method_5667();
            ServerStorage.setTutorialModeForPlayer(playerUuid, packet.tutorialMode());
            ServerStorage.setActionbarPref(playerUuid, packet.actionbar());
            ServerStorage.setIcarusFireworkSlot(playerUuid, packet.iCarusFireworksInventorySlot());
            ServerStorage.setInfiniPearlSlot(playerUuid, packet.infiniPearlInventorySlot());
        });
    }

    private static void registerC2SRequestServerSideOptions() {
        PayloadTypeRegistry.playC2S().register(RequestServerSideOptionsC2SPacket.PACKET, RequestServerSideOptionsC2SPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(RequestServerSideOptionsC2SPacket.PACKET, (packet, context) -> {
            ModOptions serverOptions = SpeedrunnerMod.options();
            ServerPlayNetworking.send((class_3222)context.player(), (class_8710)MatchClientOptionsWithServerS2CPacket.from(serverOptions));
            SpeedrunnerMod.info(context.player().method_5476().getString() + " requested this server's speedrunner mod settings.");
        });
    }

    private static void registerC2SMatchServerOptionsWithClient() {
        PayloadTypeRegistry.playC2S().register(MatchServerOptionsWithClientC2SPacket.PACKET, MatchServerOptionsWithClientC2SPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(MatchServerOptionsWithClientC2SPacket.PACKET, (packet, context) -> {
            ModOptions clientOptions = packet.toOptions();
            String player = packet.playerName();
            ServerStorage.storePendingSyncRequest(player, clientOptions);
            context.server().method_43496((class_2561)class_2561.method_43469((String)"speedrunnermod.client_options_request_received", (Object[])new Object[]{player, player}));
        });
    }

    private static void registerC2STutorialStepComplete() {
        PayloadTypeRegistry.playC2S().register(TutorialStepCompleteC2SPacket.PACKET, TutorialStepCompleteC2SPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(TutorialStepCompleteC2SPacket.PACKET, (packet, context) -> {
            ServerStorage.completeTutorialStepC2S(context.player(), packet.step());
            ServerPlayNetworking.send((class_3222)context.player(), (class_8710)new UpdateLastCompletedTutorialStepTranslationsS2CPacket(packet.messageKeys()));
        });
    }

    private static void registerS2COnServer() {
        if (SpeedrunnerMod.isEnvironmentTypeServer()) {
            PayloadTypeRegistry.playS2C().register(CheckModeS2CPacket.PACKET, CheckModeS2CPacket.CODEC);
            PayloadTypeRegistry.playS2C().register(CompleteTutorialStepS2CPacket.PACKET, CompleteTutorialStepS2CPacket.CODEC);
            PayloadTypeRegistry.playS2C().register(MatchClientOptionsWithServerS2CPacket.PACKET, MatchClientOptionsWithServerS2CPacket.CODEC);
            PayloadTypeRegistry.playS2C().register(OpenFeaturesScreenS2CPacket.PACKET, OpenFeaturesScreenS2CPacket.CODEC);
            PayloadTypeRegistry.playS2C().register(RequestClientSideOptionsS2CPacket.PACKET, RequestClientSideOptionsS2CPacket.CODEC);
            PayloadTypeRegistry.playS2C().register(UpdateLastCompletedTutorialStepTranslationsS2CPacket.PACKET, UpdateLastCompletedTutorialStepTranslationsS2CPacket.CODEC);
        }
    }

    private static void registerDedicatedServerJoinAndDisconnectEvents() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            final class_3222 player = handler.method_32311();
            if (player != null && handler.method_32311().method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15417)) == 0) {
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        UUID playerUuid = handler.method_32311().method_5667();
                        int iCarusFireworksInventorySlot = ServerStorage.getIcarusFireworkSlot(playerUuid);
                        int infiniPearlInventorySlot = ServerStorage.getInfiniPearlSlot(playerUuid);
                        if (SpeedrunnerMod.options().main.iCarusMode.getCurrentValue().booleanValue()) {
                            class_1799 item = ModUtil.ofUnbreakable(class_1802.field_8833);
                            class_1799 fireworks = ModUtil.fireworkWithFlightDuration(64);
                            player.field_56535.method_66660(class_1304.field_6174, item);
                            player.method_31548().method_67533().set(iCarusFireworksInventorySlot - 1, (Object)fireworks);
                        }
                        if (SpeedrunnerMod.options().main.infiniPearlMode.getCurrentValue().booleanValue()) {
                            class_1799 infiniPearl = ModUtil.ofUnbreakable(ModItems.INFINI_PEARL);
                            int slot = infiniPearlInventorySlot - 1;
                            if (SpeedrunnerMod.options().main.iCarusMode.getCurrentValue().booleanValue() && iCarusFireworksInventorySlot == infiniPearlInventorySlot) {
                                ++slot;
                            }
                            if (SpeedrunnerMod.options().main.iCarusMode.getCurrentValue().booleanValue() && iCarusFireworksInventorySlot == infiniPearlInventorySlot && infiniPearlInventorySlot >= 36) {
                                slot -= 2;
                            }
                            player.method_31548().method_67533().set(slot, (Object)infiniPearl);
                        }
                    }
                }, 150L);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> ServerStorage.clearPrefs(handler.method_32311().method_5667()));
        if (SpeedrunnerMod.isEnvironmentTypeServer()) {
            ServerTickEvents.END_SERVER_TICK.register(server -> {
                for (class_3222 player : server.method_3760().method_14571()) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new CheckModeS2CPacket(SpeedrunnerMod.options().main.mode.getCurrentValue()));
                }
            });
        }
    }

    public static void registerPackets() {
        ModPackets.registerC2SClientPreferences();
        ModPackets.registerC2SMatchServerOptionsWithClient();
        ModPackets.registerC2SRequestServerSideOptions();
        ModPackets.registerC2STutorialStepComplete();
        ModPackets.registerS2COnServer();
        ModPackets.registerDedicatedServerJoinAndDisconnectEvents();
        SpeedrunnerMod.debug("Registered client-to-server packets.");
    }
}

