/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.tutorial.TutorialStep;
import net.dillon.speedrunnermod.util.AI;
import net.minecraft.class_3222;

@AI
public class ServerStorage {
    private static final Map<UUID, Boolean> ACTIONBAR_PREFS = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Integer> ICARUS_FIREWORK_SLOT = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> INFINI_PEARL_SLOT = new HashMap<UUID, Integer>();
    private static final Map<UUID, Set<TutorialStep>> COMPLETED_STEPS = new HashMap<UUID, Set<TutorialStep>>();
    private static final Map<UUID, Boolean> TUTORIAL_MODE_ENABLED = new HashMap<UUID, Boolean>();
    private static final Map<String, ModOptions> pendingRequests = new HashMap<String, ModOptions>();

    public static void setActionbarPref(UUID playerUuid, boolean showInActionbar) {
        ACTIONBAR_PREFS.put(playerUuid, showInActionbar);
    }

    public static boolean shouldShowInActionbar(UUID playerUuid) {
        return ACTIONBAR_PREFS.getOrDefault(playerUuid, true);
    }

    public static void clearPrefs(UUID playerUuid) {
        ACTIONBAR_PREFS.remove(playerUuid);
        ICARUS_FIREWORK_SLOT.remove(playerUuid);
        INFINI_PEARL_SLOT.remove(playerUuid);
    }

    public static void setIcarusFireworkSlot(UUID playerUuid, int icarusFireworkSlot) {
        ICARUS_FIREWORK_SLOT.put(playerUuid, icarusFireworkSlot);
    }

    public static int getIcarusFireworkSlot(UUID playerUuid) {
        return ICARUS_FIREWORK_SLOT.getOrDefault(playerUuid, 1);
    }

    public static void setInfiniPearlSlot(UUID playerUuid, int infiniPearlSlot) {
        INFINI_PEARL_SLOT.put(playerUuid, infiniPearlSlot);
    }

    public static int getInfiniPearlSlot(UUID playerUuid) {
        return INFINI_PEARL_SLOT.getOrDefault(playerUuid, 1);
    }

    public static void completeTutorialStepC2S(class_3222 player, TutorialStep step) {
        COMPLETED_STEPS.computeIfAbsent(player.method_5667(), k -> new HashSet()).add(step);
    }

    public static void setTutorialModeForPlayer(UUID uuid, boolean tutorialMode) {
        TUTORIAL_MODE_ENABLED.put(uuid, tutorialMode);
    }

    public static boolean isTutorialModeEnabledForPlayer(UUID uuid) {
        return TUTORIAL_MODE_ENABLED.getOrDefault(uuid, false);
    }

    public static boolean isTutorialModeEnabledForPlayer(class_3222 player) {
        return TUTORIAL_MODE_ENABLED.getOrDefault(player.method_5667(), false);
    }

    public static boolean hasCompletedStep(class_3222 player, TutorialStep step) {
        if (!ServerStorage.isTutorialModeEnabledForPlayer(player.method_5667())) {
            return false;
        }
        return COMPLETED_STEPS.getOrDefault(player.method_5667(), Set.of()).contains((Object)step);
    }

    public static void storePendingSyncRequest(String player, ModOptions options) {
        pendingRequests.put(player, options);
    }

    public static ModOptions getPendingSyncRequest(String player) {
        return pendingRequests.get(player);
    }

    public static boolean hasPendingSyncRequest(String player) {
        return pendingRequests.containsKey(player);
    }

    public static void removePendingSyncRequest(String player) {
        pendingRequests.remove(player);
    }
}

