/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.tutorial;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dillon.speedrunnermod.main.SpeedrunnerModClient;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.packet.server.TutorialStepCompleteC2SPacket;
import net.dillon.speedrunnermod.tutorial.TutorialStep;
import net.dillon.speedrunnermod.util.AI;
import net.dillon.speedrunnermod.util.ModUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public interface TutorialMode {
    public static final List<TutorialStep> EXCLUDED_EASY_MODE_STEPS = List.of(TutorialStep.CRAFT_SPEEDRUNNER_ARMOR, TutorialStep.CRAFT_SPEEDRUNNER_SHIELD, TutorialStep.CRAFT_ENDER_EYE, TutorialStep.USE_ENDER_EYE, TutorialStep.OBTAIN_TOTEM_OF_UNDYING, TutorialStep.FREE_FALL_INTO_VOID, TutorialStep.OBTAIN_SPEEDRUNNERS_TOTEM, TutorialStep.BREAK_DOOM_BLOCK, TutorialStep.KILL_GOLIATH, TutorialStep.KILL_WITHER, TutorialStep.EXIT_END);
    public static final List<TutorialStep> EXCLUDED_BALANCED_MODE_STEPS = List.of(TutorialStep.CRAFT_SPEEDRUNNER_ARMOR, TutorialStep.CRAFT_SPEEDRUNNER_SHIELD, TutorialStep.CRAFT_PIGLIN_AWAKENER, TutorialStep.USE_PIGLIN_AWAKENER, TutorialStep.CRAFT_BLAZE_SPOTTER, TutorialStep.USE_BLAZE_SPOTTER, TutorialStep.CRAFT_DRAGONS_PEARL, TutorialStep.CRAFT_ANNUL_EYE, TutorialStep.USE_ANNUL_EYE, TutorialStep.OBTAIN_TOTEM_OF_UNDYING, TutorialStep.FREE_FALL_INTO_VOID, TutorialStep.OBTAIN_SPEEDRUNNERS_TOTEM, TutorialStep.BREAK_DOOM_BLOCK, TutorialStep.KILL_GOLIATH, TutorialStep.KILL_WITHER, TutorialStep.USE_DRAGONS_PEARL, TutorialStep.EXIT_END, TutorialStep.OBTAIN_ENDER_THRUSTER, TutorialStep.USE_ENTER_THRUSTER, TutorialStep.OBTAIN_DRAGONS_SWORD);
    public static final List<TutorialStep> DOOM_MODE_STEPS = List.of(TutorialStep.ENTER_WORLD, TutorialStep.CRAFT_SPEEDRUNNER_PICKAXE, TutorialStep.CRAFT_SPEEDRUNNER_PADDLE, TutorialStep.CRAFT_SPEEDRUNNER_BOAT, TutorialStep.CRAFT_SPEEDRUNNER_ARMOR, TutorialStep.CRAFT_SPEEDRUNNER_SHIELD, TutorialStep.CRAFT_SPEEDRUNNERS_EYE, TutorialStep.CHANGE_SPEEDRUNNERS_EYE_LOCATOR, TutorialStep.USE_SPEEDRUNNERS_EYE, TutorialStep.CRAFT_DRAGONS_PEARL, TutorialStep.CRAFT_ANNUL_EYE, TutorialStep.MINE_EXPERIENCE_ORE, TutorialStep.CRAFT_SPEEDRUNNERS_WORKBENCH, TutorialStep.TRANSFER_ENCHANTMENTS, TutorialStep.INTERACT_WITH_RETIRED_SPEEDRUNNER, TutorialStep.USE_ANNUL_EYE, TutorialStep.ENTER_END, TutorialStep.OBTAIN_TOTEM_OF_UNDYING, TutorialStep.FREE_FALL_INTO_VOID, TutorialStep.OBTAIN_SPEEDRUNNERS_TOTEM, TutorialStep.BREAK_DOOM_BLOCK, TutorialStep.KILL_GOLIATH, TutorialStep.KILL_WITHER, TutorialStep.USE_DRAGONS_PEARL, TutorialStep.KILL_DRAGON, TutorialStep.EXIT_END);

    @AI
    public boolean getStep(TutorialStep var1);

    @AI
    public void setStep(TutorialStep var1, boolean var2);

    default public boolean completed() {
        return !ModOptions.isDoomMode() && this.getStep(TutorialStep.OBTAIN_INFINI_PEARL) || ModOptions.isDoomMode() && this.getStep(TutorialStep.EXIT_END);
    }

    @AI
    default public boolean canComplete(TutorialStep step) {
        TutorialStep[] steps;
        if (!SpeedrunnerModClient.clientOptions().client.tutorialMode.getCurrentValue().booleanValue()) {
            return false;
        }
        List<TutorialStep> stepsList = new ArrayList<TutorialStep>(Arrays.stream(TutorialStep.values()).toList());
        if (ModOptions.isBalancedMode()) {
            for (TutorialStep excludedStep : EXCLUDED_BALANCED_MODE_STEPS) {
                stepsList.remove((Object)excludedStep);
            }
        } else if (ModOptions.isDoomMode()) {
            stepsList = DOOM_MODE_STEPS;
        } else {
            for (TutorialStep excludedStep : EXCLUDED_EASY_MODE_STEPS) {
                stepsList.remove((Object)excludedStep);
            }
        }
        for (TutorialStep s : steps = stepsList.toArray(new TutorialStep[0])) {
            if (s == step) break;
            if (this.getStep(s)) continue;
            return false;
        }
        return true;
    }

    @AI
    default public void completeStep(TutorialStep step, class_746 player, String ... messageKey) {
        if (this.canComplete(step) && !this.getStep(step)) {
            this.setStep(step, true);
            ArrayList<String> translations = new ArrayList();
            for (String s : messageKey) {
                ModUtil.sendWithPrefix(s, (class_1657)player);
                translations.add(s);
            }
            if (this.completed()) {
                translations = List.of();
            }
            ClientPlayNetworking.send((class_8710)new TutorialStepCompleteC2SPacket(step, translations));
            player.method_17356(class_3417.field_15224, class_3419.field_15254, 1.0f, 1.0f);
            SpeedrunnerModClient.saveClientChanges();
        }
    }
}

