/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.packet.client.CompleteTutorialStepS2CPacket;
import net.dillon.speedrunnermod.server.ServerStorage;
import net.dillon.speedrunnermod.tutorial.TutorialStep;
import net.dillon.speedrunnermod.util.Author;
import net.dillon.speedrunnermod.util.Authors;
import net.dillon.speedrunnermod.util.ModTexts;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1672;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class ModUtil {
    public static int errorMessagesSent = 0;
    public static final String CONFIG_FILE_NAME = "speedrunnermod-config_1.11.1.json";
    public static final String CLIENT_CONFIG_FILE_NAME = "speedrunnermod-client_config_1.11.1.json";
    public static final int SPEEDRUNNER_WATER_COLOR = 8765929;
    public static final int SPEEDRUNNER_WATER_FOG_COLOR = 8765929;
    public static final int DOLPHIN_RANGE = 200;
    public static final int TREES_PLAINS_COUNT = 1;
    public static final int DIAMOND_ORE_SPAWN_CHANCE = 8;
    public static final int BURIED_DIAMOND_ORE_SPAWN_CHANCE = 9;
    public static final int LARGE_DIAMOND_ORE_SPAWN_CHANCE = 5;
    public static final int LAPIS_LAZULI_ORE_SPAWN_CHANCE = 3;
    public static final int BURIED_LAPIS_LAZULI_ORE_SPAWN_CHANCE = 4;
    public static final float LAVA_BOAT_VELOCITY_MULTIPLIER = 0.95f;
    public static final float FAST_BOAT_VELOCITY_MULTIPLIER = 1.035f;
    public static final double DOLPHIN_PREDICATE_RANGE = 20.0;

    @Author(value=Authors.KWPUGH)
    public static void findStructureAndShoot(class_1937 world, class_1657 player, class_1799 itemstack, class_6862<class_3195> type) {
        class_2338 playerpos = player.method_24515();
        class_3218 serverWorld = (class_3218)world;
        class_2338 locpos = serverWorld.method_8487(type, playerpos, 100, false);
        class_1672 finderentity = new class_1672(world, player.method_23317(), player.method_23323(0.5), player.method_23321());
        finderentity.method_16933(itemstack);
        class_243 vec3d = new class_243((double)locpos.method_10263(), (double)locpos.method_10264(), (double)locpos.method_10260());
        finderentity.method_7478(vec3d);
        world.method_8649((class_1297)finderentity);
        if (player instanceof class_3222) {
            class_174.field_1186.method_9157((class_3222)player, locpos);
        }
        world.method_8444(null, 1003, player.method_24515(), 0);
    }

    public static class_2561 deathCords(double x, double y, double z) {
        return class_2561.method_43469((String)"speedrunnermod.player_death_cords", (Object[])new Object[]{ModUtil.roundToNearestTenthsPlace(x), ModUtil.roundToNearestTenthsPlace(y), ModUtil.roundToNearestTenthsPlace(z)}).method_10862(class_2583.field_24360.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"speedrunnermod.teleport_to_player_death_cords"))).method_10958((class_2558)new class_2558.class_10610("/teleport @s " + x + " " + y + " " + z)));
    }

    public static void sendWithPrefix(String string, class_1657 player) {
        player.method_7353((class_2561)ModTexts.BLANK.method_27661().method_10852((class_2561)class_2561.method_43471((String)"speedrunnermod.tutorial_mode.prefix")).method_27693("").method_10852((class_2561)class_2561.method_43471((String)string)), false);
    }

    public static class_124 toFormatting(UUID uuid, class_124 actionbar, class_124 chat) {
        return ServerStorage.shouldShowInActionbar(uuid) ? actionbar : chat;
    }

    public static void sendMessageWithActionbarPref(class_1657 player, class_2561 text) {
        player.method_7353(text, ServerStorage.shouldShowInActionbar(player.method_5667()));
    }

    public static void sendMessageWithActionbarPref(class_1657 player, class_2561 text, class_124 actionbar, class_124 chat) {
        player.method_7353((class_2561)text.method_27661().method_27692(ModUtil.toFormatting(player.method_5667(), actionbar, chat)), ServerStorage.shouldShowInActionbar(player.method_5667()));
    }

    public static void completeStepS2C(TutorialStep step, class_1657 player, String ... messageKeys) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ArrayList<String> messageKeysList = new ArrayList<String>(Arrays.asList(messageKeys));
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new CompleteTutorialStepS2CPacket(step, messageKeysList));
        }
    }

    @Deprecated
    public static class_6880<class_1887> enchantment(@NotNull Object entityOrWorld, @NotNull class_5321<class_1887> enchantment) {
        try {
            Optional optional;
            if (entityOrWorld instanceof class_1297) {
                class_1297 entity = (class_1297)entityOrWorld;
                optional = entity.method_37908().method_30349().method_30530(class_7924.field_41265).method_10223(enchantment.method_29177());
            } else if (entityOrWorld instanceof class_1937) {
                class_1937 world = (class_1937)entityOrWorld;
                optional = world.method_30349().method_30530(class_7924.field_41265).method_10223(enchantment.method_29177());
            } else {
                optional = Optional.empty();
            }
            Optional optional2 = optional;
            return (class_6880)optional2.orElseThrow();
        }
        catch (Exception o) {
            if (errorMessagesSent <= 100) {
                SpeedrunnerMod.error("(" + errorMessagesSent + ") Error with Speedrunner Mod! Likely caused due to the server you joined doesn't have the speedrunner mod installed.");
            }
            if (errorMessagesSent == 101) {
                SpeedrunnerMod.error("(" + errorMessagesSent + ") Returning LOOTING enchantment.");
                o.printStackTrace();
                SpeedrunnerMod.error("(" + errorMessagesSent + ") This Speedrunner Mod error is continuous, but handled. Messages will stop now due to prevent overflow errors.");
            }
            ++errorMessagesSent;
            class_1937 world = null;
            if (entityOrWorld instanceof class_1297) {
                class_1297 entity = (class_1297)entityOrWorld;
                world = entity.method_37908();
            } else if (entityOrWorld instanceof class_1937) {
                class_1937 w;
                world = w = (class_1937)entityOrWorld;
            }
            if (world != null) {
                return (class_6880)world.method_30349().method_30530(class_7924.field_41265).method_10223(class_1893.field_9110.method_29177()).orElseThrow();
            }
            throw o;
        }
    }

    public static class_1799 ofUnbreakable(class_1792 item) {
        class_1799 stack = new class_1799((class_1935)item);
        stack.method_57379(class_9334.field_49630, (Object)class_3902.field_17274);
        return stack;
    }

    public static void spawnFloatingItemEntity(class_1937 world, class_1799 stack, class_1657 player) {
        ModUtil.spawnFloatingItemEntity(world, player.method_24515(), stack, player, false);
    }

    public static void spawnFloatingItemEntity(class_1937 world, class_2338 pos, class_1799 stack, class_1657 player, boolean playSound) {
        class_1542 item = new class_1542(world, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 3.0f), (double)((float)pos.method_10260() + 0.5f), stack);
        item.method_5684(true);
        item.method_5834(true);
        item.method_5875(true);
        item.method_35190();
        class_243 itemPos = item.method_19538();
        class_243 playerPos = player.method_19538();
        class_243 motion = playerPos.method_1020(itemPos).method_1029().method_1021(0.1);
        item.method_18800(motion.field_1352, motion.field_1351, motion.field_1350);
        if (playSound) {
            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15224, class_3419.field_15254, 3.0f, 1.0f);
        }
        world.method_8649((class_1297)item);
    }

    public static class_1799 fireworkWithFlightDuration(int count) {
        class_1799 fireworks = new class_1799((class_1935)class_1802.field_8639, count);
        fireworks.method_57379(class_9334.field_49616, (Object)new class_9284(3, List.of()));
        return fireworks;
    }

    public static void modifyMaxHealth(class_1309 entity, double health) {
        if (entity.method_5996(class_5134.field_23716) != null) {
            entity.method_5996(class_5134.field_23716).method_6192(health);
        }
        entity.method_6033((float)entity.method_5996(class_5134.field_23716).method_6201());
    }

    public static void modifyMovementSpeed(class_1309 entity, double speed) {
        if (entity.method_5996(class_5134.field_23719) != null) {
            entity.method_5996(class_5134.field_23719).method_6192(speed);
        }
        entity.method_6125((float)entity.method_5996(class_5134.field_23719).method_6201());
    }

    public static void modifyFollowRange(class_1309 entity, double range) {
        if (entity.method_5996(class_5134.field_23717) != null) {
            entity.method_5996(class_5134.field_23717).method_6192(range);
        }
    }

    public static void modifyAttackDamage(class_1309 entity, double attackDamage) {
        if (entity.method_5996(class_5134.field_23721) != null) {
            entity.method_5996(class_5134.field_23721).method_6192(attackDamage);
        }
    }

    public static void modifyAttackKnockback(class_1309 entity, double attackKnockback) {
        if (entity.method_5996(class_5134.field_23722) != null) {
            entity.method_5996(class_5134.field_23722).method_6192(attackKnockback);
        }
    }

    public static void modifyKnockbackResistance(class_1309 entity, double resistance) {
        if (entity.method_5996(class_5134.field_23718) != null) {
            entity.method_5996(class_5134.field_23718).method_6192(resistance);
        }
    }

    public static void modifyArmor(class_1309 entity, double value) {
        if (entity.method_5996(class_5134.field_23724) != null) {
            entity.method_5996(class_5134.field_23724).method_6192(value);
        }
    }

    public static int modifyExperiencePoints(class_1308 reference, class_1309 attacker, int base, int multiplier) {
        return base + class_1890.method_8203(ModUtil.enchantment(reference, (class_5321<class_1887>)class_1893.field_9110), (class_1309)attacker) * multiplier;
    }

    @Author(value=Authors.KWPUGH)
    public static float getDistance(int x1, int z1, int x2, int z2) {
        int i = x2 - x1;
        int j = z2 - z1;
        return class_3532.method_15355((float)(i * i + j * j));
    }

    public static double roundToNearestTenthsPlace(double number) {
        return (double)Math.round(number * 10.0) / 10.0;
    }

    public static float randomFloat(float min, float max) {
        Random random = new Random();
        return min + random.nextFloat() * (max - min);
    }

    public static boolean percentChance(class_5819 random, int percentChance) {
        return random.method_43048(100) < percentChance;
    }

    public static int millisecondsAsSeconds(int seconds) {
        return seconds * 1000;
    }

    public static int secondsAsTicks(int seconds) {
        try {
            for (int testSeconds = 0; testSeconds < 525600; testSeconds += 60) {
                if (seconds != testSeconds) continue;
                throw new NumberFormatException();
            }
            return seconds * 20;
        }
        catch (NumberFormatException o) {
            SpeedrunnerMod.error("Use method minutesInTicks(int) if you're inputting an exact minute.");
            o.printStackTrace();
            return ModUtil.minutesAsTicks(seconds / 60);
        }
    }

    public static int minutesAsTicks(int minutes) {
        return minutes * 60 * 20;
    }

    public static List<Integer> createListOption(int posX, int posY, int posZ) {
        return List.of(Integer.valueOf(posX), Integer.valueOf(posY), Integer.valueOf(posZ));
    }

    public static List<Integer> createListOption(int negX, int negY, int negZ, int posX, int posY, int posZ) {
        return List.of(Integer.valueOf(negX), Integer.valueOf(negY), Integer.valueOf(negZ), Integer.valueOf(posX), Integer.valueOf(posY), Integer.valueOf(posZ));
    }

    public static List<Integer> createStructureSpawnRateOption(int spacing, int separation) {
        return List.of(Integer.valueOf(spacing), Integer.valueOf(separation));
    }

    public static float getBedBlockExplosionPower(class_1937 world) {
        if (ModOptions.isDoomMode()) {
            return world.method_27983() == class_1937.field_25181 ? 15.0f : 5.0f;
        }
        return 5.0f;
    }

    public static int getFireDamageFromLavaDuration() {
        return ModOptions.isDoomMode() ? 15 : 7;
    }

    public static int getFireballFireDamageTime() {
        return ModOptions.isDoomMode() ? 6 : 3;
    }

    public static int getBlazeFireballCooldown() {
        return ModOptions.isDoomMode() ? 60 : 180;
    }

    public static int getGhastFireballCooldown() {
        return ModOptions.isDoomMode() ? -5 : -40;
    }

    public static int getSlimeJumpTime() {
        return ModOptions.isDoomMode() ? 20 : 100;
    }

    public static int getPlayerBreathTime() {
        return SpeedrunnerMod.options().advanced.higherBreathTime.getCurrentValue() != false ? 8 : 4;
    }

    public static int getSilverfishCallForHelpDelay() {
        return ModOptions.isDoomMode() ? 20 : 100;
    }

    public static int getWitherSkeletonWitherEffectDuration() {
        return ModOptions.isDoomMode() ? 200 : 60;
    }

    public static int getStrongholdMinY() {
        return ModOptions.isDoomMode() ? -48 : 27;
    }

    public static int getStrongholdMaxY() {
        int seaLevel = 63;
        return ModOptions.isDoomMode() ? 0 : seaLevel;
    }

    public static float getPrefilledEnderEyeChance() {
        return ModOptions.isDoomMode() ? 0.99f : (ModOptions.isEasyMode() ? 0.6f : 0.9f);
    }

    public static float getLavaDamageValue() {
        return ModOptions.isDoomMode() ? 4.0f : 2.0f;
    }

    public static float getFireballDamageValue() {
        return ModOptions.isDoomMode() ? 5.0f : 1.0f;
    }

    public static float getSlimeDamageMultiplier() {
        return ModOptions.isDoomMode() ? 2.2f : 1.5f;
    }

    public static float getVexDecayDamageValue() {
        return ModOptions.isDoomMode() ? 100.0f : 1.0f;
    }

    public static float getEnderDragonDamageValue() {
        return ModOptions.isDoomMode() ? 12.0f : 3.0f;
    }

    public static double getEnderDragonMaxHealth() {
        return ModOptions.isDoomMode() ? 500.0 : 100.0;
    }

    public static int getEnderDragonFireballInstantDamageAmplifier() {
        return ModOptions.isDoomMode() ? 1 : 0;
    }

    public static float getEnderDragonEndCrystalHealingValue() {
        return ModOptions.isDoomMode() ? 1.7f : 0.1f;
    }

    public static float getEnderDragonDestroyedEndCrystalDamageValue() {
        return ModOptions.isDoomMode() ? 3.0f : 20.0f;
    }

    public static float getEnderDragonSittingTime() {
        if (SpeedrunnerMod.options().advanced.longerDragonPerchStayTime.getCurrentValue().booleanValue()) {
            return ModOptions.isDoomMode() ? 0.18f : 0.6f;
        }
        return 0.25f;
    }

    public static float getEnderPearlDamageValue() {
        return ModOptions.isDoomMode() ? 5.0f : 2.0f;
    }

    public static double getWitherMaxHealth() {
        return ModOptions.isDoomMode() ? 250.0 : 100.0;
    }

    public static double getZombifiedPiglinRunawayDistance() {
        return SpeedrunnerMod.options().advanced.decreasedZombifiedPiglinScareDistance.getCurrentValue() != false ? 2.0 : 6.0;
    }
}

