/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.world;

import java.util.function.Predicate;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.world.biome.ModBiomeKeys;
import net.dillon.speedrunnermod.world.feature.ModPlacedFeatures;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1299;
import net.minecraft.class_1972;
import net.minecraft.class_2893;
import net.minecraft.class_3390;
import net.minecraft.class_3421;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_6012;
import net.minecraft.class_6862;
import net.minecraft.class_6908;

public class ModWorldGen {
    public static final class_6012<class_5483.class_1964> NETHER_FORTRESS_MOB_SPAWNS;
    public static final class_3390.class_3404[] MODIFIED_NETHER_FORTRESS_BRIDGE_PIECES;
    public static final class_3390.class_3404[] MODIFIED_NETHER_FORTRESS_CORRIDOR_PIECES;
    public static final class_3421.class_3427[] MODIFIED_STRONGHOLD_PIECES;

    public static void initializeWorldGenFeatures() {
        ModBiomeKeys.initializeBiomeKeys();
        ModWorldGen.addOres();
        ModWorldGen.addVegetalDecoration();
        if (ModOptions.isDoomMode() && (Integer)SpeedrunnerMod.options().main.strongholdLibraryCount.getCurrentValue() > 5) {
            SpeedrunnerMod.options().main.strongholdLibraryCount.set(5);
            SpeedrunnerMod.warn("Doom mode is on, and detected too high stronghold library count. Setting to 5. May require a restart to take full effect.");
        }
        SpeedrunnerMod.debug("Initialized world gen features.");
    }

    private static void addOres() {
        BiomeModifications.addFeature((Predicate)BiomeSelectors.excludeByKey((class_5321[])new class_5321[]{ModBiomeKeys.SPEEDRUNNERS_WASTELAND_KEY}), (class_2893.class_2895)class_2893.class_2895.field_13176, ModPlacedFeatures.ORE_SPEEDRUNNER_UPPER);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.excludeByKey((class_5321[])new class_5321[]{ModBiomeKeys.SPEEDRUNNERS_WASTELAND_KEY}), (class_2893.class_2895)class_2893.class_2895.field_13176, ModPlacedFeatures.ORE_SPEEDRUNNER_MIDDLE);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.excludeByKey((class_5321[])new class_5321[]{ModBiomeKeys.SPEEDRUNNERS_WASTELAND_KEY}), (class_2893.class_2895)class_2893.class_2895.field_13176, ModPlacedFeatures.ORE_SPEEDRUNNER_SMALL);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.excludeByKey((class_5321[])new class_5321[]{ModBiomeKeys.SPEEDRUNNERS_WASTELAND_KEY}), (class_2893.class_2895)class_2893.class_2895.field_13176, ModPlacedFeatures.ORE_EXPERIENCE);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_23859}), (class_2893.class_2895)class_2893.class_2895.field_13176, ModPlacedFeatures.ORE_SPEEDRUNNER_DELTAS);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_23859}), (class_2893.class_2895)class_2893.class_2895.field_13176, ModPlacedFeatures.ORE_IGNEOUS_DELTAS);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_23859}), (class_2893.class_2895)class_2893.class_2895.field_13176, ModPlacedFeatures.ORE_EXPERIENCE_DELTAS);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInTheNether(), (class_2893.class_2895)class_2893.class_2895.field_13176, ModPlacedFeatures.ORE_SPEEDRUNNER_NETHER);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInTheNether(), (class_2893.class_2895)class_2893.class_2895.field_13176, ModPlacedFeatures.ORE_IGNEOUS_NETHER);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInTheNether(), (class_2893.class_2895)class_2893.class_2895.field_13176, ModPlacedFeatures.ORE_EXPERIENCE_NETHER);
    }

    private static void addVegetalDecoration() {
        if (SpeedrunnerMod.options().advanced.generateSpeedrunnerWood.getCurrentValue().booleanValue()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9424, class_1972.field_9415}), (class_2893.class_2895)class_2893.class_2895.field_13178, ModPlacedFeatures.DEAD_SPEEDRUNNER_PLACED);
            BiomeModifications.addFeature((Predicate)BiomeSelectors.tag((class_6862)class_6908.field_36495), (class_2893.class_2895)class_2893.class_2895.field_13178, ModPlacedFeatures.PATCH_DEAD_SPEEDRUNNER_BUSH_SWAMP);
            BiomeModifications.addFeature((Predicate)BiomeSelectors.tag((class_6862)class_6908.field_36520), (class_2893.class_2895)class_2893.class_2895.field_13178, ModPlacedFeatures.PATCH_DEAD_SPEEDRUNNER_BUSH_DESERT);
            BiomeModifications.addFeature((Predicate)BiomeSelectors.tag((class_6862)class_6908.field_36513), (class_2893.class_2895)class_2893.class_2895.field_13178, ModPlacedFeatures.PATCH_DEAD_SPEEDRUNNER_BUSH_BADLANDS);
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_22076}), (class_2893.class_2895)class_2893.class_2895.field_13178, ModPlacedFeatures.DEAD_SPEEDRUNNER_PLACED_NETHER);
        }
        if (ModOptions.isDoomMode()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9411}), (class_2893.class_2895)class_2893.class_2895.field_13178, ModPlacedFeatures.DOOM_TREE_PLACED);
        }
    }

    static {
        class_3421.class_3427[] class_3427Array;
        if (ModOptions.isDoomMode()) {
            class_3421.class_3427[] class_3427Array2 = new class_3421.class_3427[11];
            class_3427Array2[0] = new class_3421.class_3427(class_3421.class_3435.class, 25, 5);
            class_3427Array2[1] = new class_3421.class_3427(class_3421.class_3429.class, 50, 5);
            class_3427Array2[2] = new class_3421.class_3427(class_3421.class_3425.class, 25, 5);
            class_3427Array2[3] = new class_3421.class_3427(class_3421.class_3430.class, 25, 5);
            class_3427Array2[4] = new class_3421.class_3427(class_3421.class_3431.class, 75, 5);
            class_3427Array2[5] = new class_3421.class_3427(class_3421.class_3436.class, 50, 5);
            class_3427Array2[6] = new class_3421.class_3427(class_3421.class_3433.class, 50, 5);
            class_3427Array2[7] = new class_3421.class_3427(class_3421.class_3424.class, 50, 5);
            class_3427Array2[8] = new class_3421.class_3427(class_3421.class_3422.class, 25, 5);
            class_3427Array2[9] = new class_3421.class_3427(class_3421.class_3426.class, 100, (Integer)SpeedrunnerMod.options().main.strongholdLibraryCount.getCurrentValue() * 2){

                public boolean method_14862(int chainLength) {
                    return super.method_14862(chainLength) && chainLength > 3;
                }
            };
            class_3427Array = class_3427Array2;
            class_3427Array2[10] = new class_3421.class_3427(class_3421.class_3428.class, 50, 1){

                public boolean method_14862(int chainLength) {
                    return super.method_14862(chainLength) && chainLength > 5;
                }
            };
        } else {
            class_3421.class_3427[] class_3427Array3 = new class_3421.class_3427[11];
            class_3427Array3[0] = new class_3421.class_3427(class_3421.class_3435.class, 20, 2);
            class_3427Array3[1] = new class_3421.class_3427(class_3421.class_3429.class, 5, 1);
            class_3427Array3[2] = new class_3421.class_3427(class_3421.class_3425.class, 10, 2);
            class_3427Array3[3] = new class_3421.class_3427(class_3421.class_3430.class, 10, 2);
            class_3427Array3[4] = new class_3421.class_3427(class_3421.class_3431.class, 20, 1);
            class_3427Array3[5] = new class_3421.class_3427(class_3421.class_3436.class, 10, 1);
            class_3427Array3[6] = new class_3421.class_3427(class_3421.class_3433.class, 10, 1);
            class_3427Array3[7] = new class_3421.class_3427(class_3421.class_3424.class, 10, 2);
            class_3427Array3[8] = new class_3421.class_3427(class_3421.class_3422.class, 25, 2);
            class_3427Array3[9] = new class_3421.class_3427(class_3421.class_3428.class, 200, (Integer)SpeedrunnerMod.options().main.strongholdPortalRoomCount.getCurrentValue()){

                public boolean method_14862(int chainLength) {
                    return super.method_14862(chainLength);
                }
            };
            class_3427Array = class_3427Array3;
            class_3427Array3[10] = new class_3421.class_3427(class_3421.class_3426.class, 200, (Integer)SpeedrunnerMod.options().main.strongholdLibraryCount.getCurrentValue()){

                public boolean method_14862(int chainLength) {
                    return super.method_14862(chainLength);
                }
            };
        }
        MODIFIED_STRONGHOLD_PIECES = class_3427Array;
        MODIFIED_NETHER_FORTRESS_BRIDGE_PIECES = new class_3390.class_3404[]{new class_3390.class_3404(class_3390.class_3393.class, 10, 1), new class_3390.class_3404(class_3390.class_3391.class, 10, 2), new class_3390.class_3404(class_3390.class_3405.class, 10, 2), new class_3390.class_3404(class_3390.class_3406.class, 10, 1), new class_3390.class_3404(class_3390.class_3402.class, 50, 3), new class_3390.class_3404(class_3390.class_3396.class, 10, 1)};
        MODIFIED_NETHER_FORTRESS_CORRIDOR_PIECES = new class_3390.class_3404[]{new class_3390.class_3404(class_3390.class_3399.class, 10, 2), new class_3390.class_3404(class_3390.class_3397.class, 10, 2), new class_3390.class_3404(class_3390.class_3400.class, 25, 3), new class_3390.class_3404(class_3390.class_3398.class, 25, 3), new class_3390.class_3404(class_3390.class_3394.class, 10, 2, true), new class_3390.class_3404(class_3390.class_3395.class, 7, 2), new class_3390.class_3404(class_3390.class_3401.class, 20, 2)};
        NETHER_FORTRESS_MOB_SPAWNS = ModOptions.isDoomMode() ? class_6012.method_66215().method_34975((Object)new class_5483.class_1964(class_1299.field_6099, 1, 4), 50).method_34975((Object)new class_5483.class_1964(class_1299.field_25751, 2, 4), 25).method_34975((Object)new class_5483.class_1964(class_1299.field_6050, 1, 1), 25).method_34975((Object)new class_5483.class_1964(class_1299.field_6076, 4, 12), 75).method_34975((Object)new class_5483.class_1964(class_1299.field_6137, 5, 5), 50).method_34975((Object)new class_5483.class_1964(class_1299.field_6102, 1, 4), 20).method_34974() : class_6012.method_66215().method_34975((Object)new class_5483.class_1964(class_1299.field_6099, 1, 4), 15).method_34975((Object)new class_5483.class_1964(class_1299.field_22281, 2, 4), 15).method_34975((Object)new class_5483.class_1964(class_1299.field_6050, 1, 2), 3).method_34975((Object)new class_5483.class_1964(class_1299.field_6076, 1, 2), 8).method_34975((Object)new class_5483.class_1964(class_1299.field_6137, 1, 2), 1).method_34975((Object)new class_5483.class_1964(class_1299.field_6102, 1, 1), 1).method_34974();
    }
}

