/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.world.structure;

import com.google.gson.JsonElement;
import java.util.List;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.option.OptionValue;
import org.jetbrains.annotations.NotNull;

abstract class Ssr {
    Ssr() {
    }

    public final void configurate(JsonElement element) {
        element.getAsJsonObject().getAsJsonObject("placement").addProperty("spacing", (Number)this.getSpacing());
        element.getAsJsonObject().getAsJsonObject("placement").addProperty("separation", (Number)this.getSeparation());
    }

    private int getSpacing() {
        if (ModOptions.isSsrEverywhere()) {
            return this.everywhere()[0];
        }
        if (ModOptions.isSsrVeryCommon()) {
            return this.veryCommon()[0];
        }
        if (ModOptions.isSsrCommon()) {
            return this.common()[0];
        }
        if (ModOptions.isSsrNormal()) {
            return this.normal()[0];
        }
        if (ModOptions.isSsrRare()) {
            return this.rare()[0];
        }
        if (ModOptions.isSsrVeryRare()) {
            return this.veryRare()[0];
        }
        return this.custom().getCurrentValue().getFirst();
    }

    private int getSeparation() {
        if (ModOptions.isSsrEverywhere()) {
            return this.everywhere()[1];
        }
        if (ModOptions.isSsrVeryCommon()) {
            return this.veryCommon()[1];
        }
        if (ModOptions.isSsrNormal()) {
            return this.normal()[1];
        }
        if (ModOptions.isSsrRare()) {
            return this.rare()[1];
        }
        if (ModOptions.isSsrVeryRare()) {
            return this.veryRare()[1];
        }
        return this.custom().getCurrentValue().get(1);
    }

    public abstract int[] everywhere();

    public abstract int[] veryCommon();

    public abstract int[] common();

    public abstract int[] normal();

    public abstract int[] rare();

    public abstract int[] veryRare();

    @NotNull
    public abstract OptionValue<List<Integer>> custom();
}

