package me.cybersteve.equiplib.armorset.base;

import me.cybersteve.equiplib.util.EffectList;
import net.minecraft.class_1282;
import net.minecraft.class_1309;

/**
 * The interface Effect armor set extension.
 */
public interface IEffectArmorSetExtension {

    /**
     * Gets effects when wearing.
     *
     * @param entity the LivingEntity that is currently wearing the ArmorSet
     * @return the effects when wearing
     */
    default EffectList getEffectsWhenWearing(class_1309 entity) {
        return EffectList.getEmptyList();
    }

    /**
     * Gets effects for self when hit.
     *
     * @param source the DamageSource
     * @param wearer the set wearer LivingEntity
     * @param amount the amount of damage wearer is about to receive
     * @return the effects for self when hit
     */
    default EffectList getEffectsForSelfWhenHit(class_1282 source, class_1309 wearer, float amount) {
        return EffectList.getEmptyList();
    }

    /**
     * Gets effects for attacker when hit.
     *
     * @param source the DamageSource
     * @param wearer the set wearer LivingEntity
     * @param amount the amount of damage wearer is about to receive
     * @return the effects for attacker when hit
     */
    default EffectList getEffectsForAttackerWhenHit(class_1282 source, class_1309 wearer, float amount) {
        return EffectList.getEmptyList();
    }
}
