package me.cybersteve.equiplib.armorset.impl;

import me.cybersteve.equiplib.armorset.base.EffectArmorSet;
import me.cybersteve.equiplib.util.ArmorSetHelper;
import me.cybersteve.equiplib.util.EffectList;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import org.apache.commons.lang3.function.TriFunction;

import java.util.function.Function;

/**
 * The type Full effect armor set.
 */
public class FullEffectArmorSet extends EffectArmorSet {
    /**
     * The function that gets effects when wearing full set.
     */
    protected Function<class_1309, EffectList> whenWearing;
    /**
     * The function that gets effects on hit for attacker.
     */
    protected TriFunction<class_1282, class_1309, Float, EffectList> onHitForAttacker;
    /**
     * The function that gets effects on hit for self.
     */
    protected TriFunction<class_1282, class_1309, Float, EffectList> onHitForSelf;

    /**
     * Instantiates a new Full effect armor set.
     *
     * @param id               the id
     * @param whenWearing      the when wearing
     * @param onHitForSelf     the on hit for self
     * @param onHitForAttacker the on hit for attacker
     */
    public FullEffectArmorSet(class_2960 id,
                              Function<class_1309, EffectList> whenWearing,
                              TriFunction<class_1282, class_1309, Float, EffectList> onHitForSelf,
                              TriFunction<class_1282, class_1309, Float, EffectList> onHitForAttacker) {
        super(id);
        this.whenWearing = whenWearing;
        this.onHitForSelf = onHitForSelf;
        this.onHitForAttacker = onHitForAttacker;
    }

    @Override
    public EffectList getEffectsWhenWearing(class_1309 entity) {
        if (ArmorSetHelper.hasFullEffectSetArmorOn(entity, this)) {
            return whenWearing.apply(entity);
        }
        return super.getEffectsWhenWearing(entity);
    }

    @Override
    public EffectList getEffectsForSelfWhenHit(class_1282 source, class_1309 target, float amount) {
        if (ArmorSetHelper.hasFullEffectSetArmorOn(target, this)) {
            return onHitForSelf.apply(source, target, amount);
        }
        return super.getEffectsForSelfWhenHit(source, target, amount);
    }

    @Override
    public EffectList getEffectsForAttackerWhenHit(class_1282 source, class_1309 target, float amount) {
        if (ArmorSetHelper.hasFullEffectSetArmorOn(target, this)) {
            return onHitForAttacker.apply(source, target, amount);
        }
        return super.getEffectsForAttackerWhenHit(source, target, amount);
    }
}
