package me.cybersteve.equiplib.item.handheld.base;

import me.cybersteve.equiplib.util.EffectList;
import net.minecraft.class_1282;
import net.minecraft.class_1309;

/**
 * The interface Effect handheld item.
 */
public interface IEffectHandHeldItem {
    /**
     * Gets effects when in hand.
     *
     * @param entity the LivingEntity item holder
     * @return the effects when in hand
     */
    default EffectList getEffectsWhenInHand(class_1309 entity) {
        return EffectList.getEmptyList();
    }

    /**
     * Gets effects for self on attack.
     *
     * @param source the source
     * @param owner  the owner of item
     * @param amount the amount of damage is about to deal
     * @return the effects for self on attack
     */
    default EffectList getEffectsForSelfOnAttack(class_1282 source, class_1309 owner, float amount) {
        return EffectList.getEmptyList();
    }

    /**
     * Gets effects for target on attack.
     *
     * @param source the source
     * @param owner  the owner of item
     * @param amount the amount of damage is about to deal
     * @return the effects for target on attack
     */
    default EffectList getEffectsForTargetOnAttack(class_1282 source, class_1309 owner, float amount) {
        return EffectList.getEmptyList();
    }
}
