package me.cybersteve.equiplib.mixin;

import me.cybersteve.equiplib.item.armor.base.IEffectArmorItem;
import me.cybersteve.equiplib.item.handheld.base.IEffectHandHeldItem;
import me.cybersteve.equiplib.util.EffectList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import me.cybersteve.equiplib.util.EffectListHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import java.util.HashMap;
import java.util.List;


@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
    @Shadow
    public abstract class_1799 getItemBySlot(class_1304 slot);

    @Unique
    private EffectList equipLib$currentHandHeldEffects = EffectList.getEmptyList();

    @Unique
    private final HashMap<class_1304, EffectList> equipLib$currentEffectsBySlot = new HashMap<>(5);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "tick", at = @At(value = "HEAD"))
    private void checkItemInHand(CallbackInfo ci) {
        class_1309 self = (class_1309) (Object) this;
        if (this.getItemBySlot(class_1304.field_6173).method_7909() instanceof IEffectHandHeldItem item) {
            EffectList newEffects = item.getEffectsWhenInHand(self);
            if (!equipLib$currentHandHeldEffects.isEmpty() && !newEffects.equals(equipLib$currentHandHeldEffects)) {
                EffectListHelper.removeEffects(self, equipLib$currentHandHeldEffects);
            }
            if (EffectListHelper.checkIfNeedToApply(self, newEffects)) {
                EffectListHelper.addEffects(self, newEffects);
            }
            equipLib$currentHandHeldEffects = newEffects;
        } else if (!equipLib$currentHandHeldEffects.isEmpty()) {
            EffectListHelper.removeEffects(self,
                    equipLib$currentHandHeldEffects);
            equipLib$currentHandHeldEffects = EffectList.getEmptyList();
        }
    }

    @Inject(method = "tick", at = @At(value = "HEAD"))
    private void applySetArmorEffectsForSelfWhenWearing(CallbackInfo ci) {
        class_1309 self = (class_1309) (Object) this;
        for (class_1304 slot: List.of(class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166,
                class_1304.field_48824)) {
            class_1799 stack = this.getItemBySlot(slot);
            EffectList currentSlotEffects = equipLib$currentEffectsBySlot.getOrDefault(slot, EffectList.getEmptyList());
            if (!stack.method_7960() && stack.method_7909() instanceof IEffectArmorItem item) {
                EffectList newEffectsBySlot = item.getEffectArmorSet().getEffectsWhenWearing(self);
                if (!currentSlotEffects.isEmpty() && !currentSlotEffects.equals(newEffectsBySlot)) {
                    EffectListHelper.removeEffects(self, currentSlotEffects);
                }
                if (EffectListHelper.checkIfNeedToApply(self, newEffectsBySlot)) {
                    EffectListHelper.addEffects(self, newEffectsBySlot);
                }
                equipLib$currentEffectsBySlot.put(slot, newEffectsBySlot);
            } else if (!currentSlotEffects.isEmpty()) {
                EffectListHelper.removeEffects(self, currentSlotEffects);
                equipLib$currentEffectsBySlot.put(slot, EffectList.getEmptyList());
            }
        }
    }

    @Inject(method = "hurt", at = @At(value = "RETURN"))
    private void applySetArmorEffectsOnHitForAttacker(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        boolean was_damaged = cir.getReturnValue();
        class_1309 self = (class_1309) (Object) this;
        if (was_damaged) {
            class_1297 attacker = source.method_5529();
            if (attacker instanceof class_1309 entity) {
                for (class_1304 slot: List.of(class_1304.field_6169, class_1304.field_6174,
                        class_1304.field_6172, class_1304.field_6166, class_1304.field_48824)) {
                    class_1799 stack = this.getItemBySlot(slot);
                    if (!stack.method_7960() && stack.method_7909() instanceof IEffectArmorItem item) {
                        EffectListHelper.addEffects(entity,
                                item.getEffectArmorSet().getEffectsForAttackerWhenHit(source, self, amount), self);
                    }
                }
            }
        }
    }

    @Inject(method = "hurt", at = @At(value = "RETURN"))
    private void applySetArmorEffectsOnHitForSelf(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        boolean was_damaged = cir.getReturnValue();
        class_1309 self = (class_1309) (Object) this;
        if (was_damaged) {
            for (class_1304 slot: List.of(class_1304.field_6169, class_1304.field_6174,
                    class_1304.field_6172, class_1304.field_6166, class_1304.field_48824)) {
                class_1799 stack = this.getItemBySlot(slot);
                if (!stack.method_7960() && stack.method_7909() instanceof IEffectArmorItem item) {
                    EffectListHelper.addEffects(self,
                            item.getEffectArmorSet().getEffectsForSelfWhenHit(source, self, amount), self);
                }
            }
        }
    }
}