package me.cybersteve.equiplib.mixin;


import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import me.cybersteve.equiplib.item.handheld.base.IEffectHandHeldItem;
import me.cybersteve.equiplib.util.EffectListHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.world.entity.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;



@Mixin(class_1308.class)
public abstract class MobEntityMixin extends class_1309 {

    protected MobEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }


    @WrapOperation(method = "doHurtTarget", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private boolean applyEffectsOnAttackForSelf(class_1297 target, class_1282 source, float amount, Operation<Boolean> original) {
        boolean wasAttacked = original.call(target, source, amount);
        if (wasAttacked && this.method_6118(class_1304.field_6173).method_7909() instanceof IEffectHandHeldItem item) {
            EffectListHelper.addEffects(this, item.getEffectsForSelfOnAttack(source, this, amount), this);
        }
        return wasAttacked;
    }

    @WrapOperation(method = "doHurtTarget", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private boolean applyEffectsOnAttackForTarget(class_1297 target, class_1282 source, float amount, Operation<Boolean> original) {
        boolean wasAttacked = original.call(target, source, amount);
        if (wasAttacked && target instanceof class_1309 entity &&
                this.method_6118(class_1304.field_6173).method_7909() instanceof IEffectHandHeldItem item) {
            EffectListHelper.addEffects(entity, item.getEffectsForTargetOnAttack(source, this, amount), this);
        }
        return wasAttacked;
    }
}