package me.cybersteve.equiplib.util;

import me.cybersteve.equiplib.armorset.base.EffectArmorSet;
import me.cybersteve.equiplib.item.armor.base.IEffectArmorItem;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import java.util.List;

/**
 * Armor set helper.
 */
public class ArmorSetHelper {
    /**
     * Has full effect set armor on boolean.
     *
     * @param entity the entity
     * @param set    the set
     * @return the boolean
     */
    public static boolean hasFullEffectSetArmorOn(class_1309 entity, EffectArmorSet set) {
        List<class_1304> armorSlots = List.of(class_1304.field_6169, class_1304.field_6174,
                class_1304.field_6172, class_1304.field_6166);
        return (entity.method_6118(class_1304.field_48824).method_7909() instanceof IEffectArmorItem effectArmorItem
                && effectArmorItem.getEffectArmorSet().equals(set)) ||
                armorSlots.stream().map(entity::method_6118).allMatch(
                itemStack -> (itemStack.method_7909() instanceof IEffectArmorItem armorItem &&
                        armorItem.getEffectArmorSet().equals(set)));
    }
}
