package me.cybersteve.equiplib.util;

import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

/**
 * The Effect list class that stores EffectMeta for each effect.
 */
public record EffectList(ConcurrentHashMap<class_6880<class_1291>, EffectMeta> data) {

    /**
     * The constant STREAM_CODEC for networking purposes.
     */
    public static final class_9139<?, EffectList> STREAM_CODEC = class_9139.method_56434(
            class_9135.method_56377(ConcurrentHashMap::new,
                    class_9135.method_56383(class_7924.field_41208),
                    EffectMeta.STREAM_CODEC),
            EffectList::data,
            EffectList::new
    );

    /**
     * Gets empty EffectList.
     *
     * @return the emptyEffectList
     */
    public static EffectList getEmptyList() {
        return new EffectList.Builder().build();
    }

    /**
     * Sets new meta for effect in list.
     *
     * @param effect the effect
     * @param meta   the meta
     */
    public void setNewMetaForEffect(class_6880<class_1291> effect, EffectMeta meta) {
        if (!data.containsKey(effect)) {
            throw new IllegalArgumentException("Effect " + effect.comp_349() + " isn't present in list");
        }
        data.put(effect, meta);
    }

    /**
     * Remove effect from list.
     *
     * @param effect the effect
     */
    public void removeEffect(class_6880<class_1291> effect) {
        data.remove(effect);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof EffectList(ConcurrentHashMap<Holder<MobEffect>, EffectMeta> data1) && data.equals(data1);
    }

    @Override
    public int hashCode() {
        return data.hashCode();
    }

    /**
     * Method to check if EffectList is empty.
     *
     * @return boolean representing emptiness of the list
     */
    public boolean isEmpty() {
        return data.isEmpty();
    }


    /**
     * The Builder for EffectList.
     */
    public static class Builder {
        private final ConcurrentHashMap<class_6880<class_1291>, EffectMeta> data;

        /**
         * Instantiates a new Builder.
         */
        public Builder() {this.data = new ConcurrentHashMap<>();}

        /**
         * Add effect with meta to builder.
         *
         * @param effect the effect
         * @param meta   the meta
         * @return the builder
         */
        public Builder addEffectWithMeta(class_6880<class_1291> effect, EffectMeta meta) {
            if (data.containsKey(effect)) {
                throw new IllegalArgumentException("Duplicate key: " + effect);
            }
            data.put(effect, meta);
            return this;
        }

        /**
         * Add effect to builder. Makes
         *
         * @param effect        the effect
         * @param duration      the duration
         * @param amplifier     the amplifier
         * @param ambient       the ambient
         * @param showParticles the show particles
         * @param showIcon      the show icon
         * @return the builder
         */
        public Builder addEffect(class_6880<class_1291> effect, int duration, int amplifier,
                                              boolean ambient, boolean showParticles, boolean showIcon) {
            return this.addEffectWithMeta(effect, new EffectMeta(duration, amplifier, ambient, showParticles, showIcon));
        }

        /**
         * Add effect with infinite duration to builder.
         *
         * @param effect        the effect
         * @param amplifier     the amplifier
         * @param ambient       the ambient
         * @param showParticles the show particles
         * @param showIcon      the show icon
         * @return the builder
         */
        public Builder addInfiniteEffect(class_6880<class_1291> effect, int amplifier,
                                         boolean ambient, boolean showParticles, boolean showIcon) {
            return this.addEffect(effect, class_1293.field_42106, amplifier, ambient,
                    showParticles, showIcon);
        }

        /**
         * Add effect from mob effect instance to builder.
         *
         * @param instance the MobEffectInstance
         * @return the builder
         */
        public Builder addFromMobEffectInstance(class_1293 instance) {
            class_6880<class_1291> effect = instance.method_5579();
            return this.addEffectWithMeta(effect, new EffectMeta(instance.method_5584(), instance.method_5578(),
                    instance.method_5591(), instance.method_5581(), instance.method_5592()));
        }

        /**
         * Build effect list.
         *
         * @return the effect list
         */
        public EffectList build() {
            return new EffectList(data);
        }
    }
}
