package me.cybersteve.equiplib.util;

import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_6880;

/**
 * Common helper for equipment.
 */
public class EffectListHelper {
    /**
     * Check if need to apply the effects from EffectList (to prevent flashing).
     *
     * @param entity  the entity
     * @param effects the effects
     * @return the boolean
     */
    public static boolean checkIfNeedToApply(class_1309 entity, EffectList effects) {
        for (var effectEntry : effects.data().entrySet()) {
            class_6880<class_1291> effect = effectEntry.getKey();
            EffectMeta meta = effectEntry.getValue();
            class_1293 instance = entity.method_6112(effect);
            if (instance != null) {
                return meta.duration() == class_1293.field_42106 ||
                        instance.method_5578() < meta.amplifier();
            } else {
                return true;
            }
        }
        return false;
    }

    /**
     * Add effects of attacker to target entity.
     *
     * @param entity   the entity
     * @param effects  the effects
     * @param attacker the attacker
     */
    public static void addEffects(class_1309 entity, EffectList effects, class_1309 attacker) {
        for (var effectEntry : effects.data().entrySet()) {
            class_6880<class_1291> effect = effectEntry.getKey();
            EffectMeta meta = effectEntry.getValue();
            if (!effect.comp_349().method_5561()) {
                if (entity.method_6059(effect)) {
                    class_1293 instance = entity.method_6112(effect);
                    if (!instance.method_48559() && instance.method_5578() < meta.amplifier()) {
                        entity.method_6016(effect);
                    }
                }
                entity.method_37222(new class_1293(effect, meta.duration(), meta.amplifier(),
                        meta.ambient(), meta.showParticles(), meta.showIcon()), attacker);
            }
        }
    }

    /**
     * Overloaded add effects if applying effects to self. Since there's no attacker here, null is passed.
     *
     * @param entity  the entity
     * @param effects the effects
     */
    public static void addEffects(class_1309 entity, EffectList effects) {
        addEffects(entity, effects, null);
    }

    /**
     * Remove effects from entity. Effects are passed via EffectList and each effect is only removed from entity if
     * their amplifier matches amplifier in passed EffectList
     *
     * @param entity  the entity
     * @param effects the effects
     */
    public static void removeEffects(class_1309 entity, EffectList effects) {
        for (var effectEntry : effects.data().entrySet()) {
            class_6880<class_1291> effect = effectEntry.getKey();
            EffectMeta meta = effectEntry.getValue();
            if (effect != null && entity.method_6059(effect) &&
                    entity.method_6112(effect).method_5578() == meta.amplifier()) {
                entity.method_6016(effect);
            }
        }
    }
}
