/*
 * Decompiled with CFR 0.152.
 */
package com.crystaelix.mixinconbooter;

import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLCallHook;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.launch.platform.MainAttributes;
import org.spongepowered.asm.launch.platform.MixinPlatformManager;
import org.spongepowered.asm.launch.platform.container.ContainerHandleURI;
import org.spongepowered.asm.launch.platform.container.IContainerHandle;

public class MixinConBooterCallHook
implements IFMLCallHook {
    public static final Logger LOGGER = LogManager.getLogger((String)"MixinConBooter");
    public static final String MIXIN_TWEAKER_CLASS = "org.spongepowered.asm.launch.MixinTweaker";
    public static final String CONTAINER_HANDLE_CLASS = "org.spongepowered.asm.launch.platform.container.IContainerHandle";
    public static final String LIBRARY_MANAGER_CLASS = "net.minecraftforge.fml.relauncher.libraries.LibraryManager";
    public static final String MOD_LIST_HELPER_CLASS = "net.minecraftforge.fml.relauncher.ModListHelper";
    static LaunchClassLoader classLoader;
    static File mcLocation;

    public void injectData(Map<String, Object> data) {
        classLoader = (LaunchClassLoader)data.get("classLoader");
        mcLocation = (File)data.get("mcLocation");
    }

    public Void call() {
        this.init();
        return null;
    }

    void init() {
        MixinPlatformManager platform = MixinBootstrap.getPlatform();
        Sets.SetView candidates = Sets.union(MixinConBooterCallHook.getClasspath(), MixinConBooterCallHook.getModCandidates());
        for (File candidate : candidates) {
            try {
                LOGGER.debug("Scanning file {} for manifest mixin configs", new Object[]{candidate});
                MainAttributes attr = MainAttributes.of((File)candidate);
                if (MIXIN_TWEAKER_CLASS.equals(attr.get("TweakClass"))) {
                    LOGGER.debug("Skipping as mixin tweaker specified in manifest");
                    continue;
                }
                if (attr.get("MixinConfigs") == null && attr.get("MixinTokenProviders") == null && attr.get("MixinConnector") == null) continue;
                LOGGER.debug("Mixin configs specified in manifest, adding as mixin container");
                platform.addContainer((IContainerHandle)new ContainerHandleURI(candidate.toURI()));
                if (classLoader.getSources().contains(candidate.toURI().toURL())) continue;
                classLoader.addURL(candidate.toURI().toURL());
                CoreModManager.getReparseableCoremods().add(candidate.getName());
            }
            catch (Exception e) {
                LOGGER.warn("Unable to scan file", (Throwable)e);
            }
        }
    }

    public static Set<File> getClasspath() {
        LinkedHashSet<File> classpath = new LinkedHashSet<File>();
        for (URL url : classLoader.getURLs()) {
            try {
                File file = new File(url.toURI().getPath());
                classpath.add(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return classpath;
    }

    public static Set<File> getModCandidates() {
        return MixinConBooterCallHook.getLegacyModCandidates();
    }

    public static Set<File> getLegacyModCandidates() {
        LinkedHashSet<File> candidates = new LinkedHashSet<File>();
        File modsDir = new File(mcLocation, "mods");
        File versionedModsDir = new File(modsDir, (String)FMLInjectionData.data()[4]);
        FilenameFilter filter = (dir, name) -> name.endsWith(".jar");
        Collections.addAll(candidates, modsDir.listFiles(filter));
        if (versionedModsDir.isDirectory()) {
            Collections.addAll(candidates, versionedModsDir.listFiles(filter));
        }
        return candidates;
    }
}

