/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.pathingtheway.config;

import com.mrbysco.pathingtheway.config.PathingConfig;
import com.mrbysco.pathingtheway.handler.ToolType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class ConfigCache {
    public static Map<ToolType, Map<ResourceLocation, ResourceLocation>> toolActionMap = new HashMap<ToolType, Map<ResourceLocation, ResourceLocation>>();

    public static void refreshCache() {
        ConfigCache.generateContainerModifier(ToolType.SHOVEL, (List)PathingConfig.COMMON.shovelPathing.get());
        ConfigCache.generateContainerModifier(ToolType.PICKAXE, (List)PathingConfig.COMMON.pickaxeChiseling.get());
        ConfigCache.generateContainerModifier(ToolType.AXE, (List)PathingConfig.COMMON.axeStripping.get());
        ConfigCache.generateContainerModifier(ToolType.HOE, (List)PathingConfig.COMMON.hoeTilling.get());
    }

    private static void generateContainerModifier(ToolType toolType, List<? extends String> configValues) {
        HashMap<ResourceLocation, ResourceLocation> actionList = new HashMap<ResourceLocation, ResourceLocation>();
        if (!configValues.isEmpty()) {
            for (String string : configValues) {
                String[] splitValue;
                if (!string.contains(",") || (splitValue = string.split(",")).length != 2) continue;
                actionList.put(ResourceLocation.tryParse((String)splitValue[0]), ResourceLocation.tryParse((String)splitValue[1]));
            }
        }
        toolActionMap.put(toolType, actionList);
    }
}

