/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.pathingtheway.config;

import com.mrbysco.pathingtheway.PathingTheWay;
import com.mrbysco.pathingtheway.config.ConfigCache;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class PathingConfig {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    public static boolean isValidOption(Object object) {
        boolean flag = object instanceof String;
        if (flag) {
            String[] splitValue;
            String value = (String)object;
            if (value.isEmpty()) {
                return true;
            }
            if (value.contains(",") && (splitValue = value.split(",")).length == 2) {
                return ResourceLocation.tryParse((String)splitValue[0]) != null && ResourceLocation.tryParse((String)splitValue[1]) != null;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        PathingTheWay.LOGGER.debug("Loaded Pathing The Way's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        PathingTheWay.LOGGER.debug("Pathing The Way's config just got changed on the file system!");
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getModId().equals("pathingtheway")) {
            ConfigCache.refreshCache();
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue shovelSneaking;
        public final ModConfigSpec.ConfigValue<List<? extends String>> shovelPathing;
        public final ModConfigSpec.BooleanValue pickaxeSneaking;
        public final ModConfigSpec.ConfigValue<List<? extends String>> pickaxeChiseling;
        public final ModConfigSpec.BooleanValue axeSneaking;
        public final ModConfigSpec.ConfigValue<List<? extends String>> axeStripping;
        public final ModConfigSpec.BooleanValue hoeSneaking;
        public final ModConfigSpec.ConfigValue<List<? extends String>> hoeTilling;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Common settings").push("common");
            this.shovelPathing = builder.comment("A list of additional pathing behaviors using shovels [Syntax: \"domain:block,domain:replacement\" ]\n[Example: \"minecraft:podzol,minecraft:dirt_path\"]").defineListAllowEmpty("shovelPathing", List::of, String::new, PathingConfig::isValidOption);
            this.shovelSneaking = builder.comment("Defines if sneaking is required to do custom pathing using shovels").define("shovelSneaking", false);
            this.pickaxeChiseling = builder.comment("A list of additional chiseling behaviors using pickaxe's [Syntax: \"domain:block,domain:replacement\" ]\n[Example: \"minecraft:stone,minecraft:stone_stairs\"]").defineListAllowEmpty("pickaxeChiseling", List::of, String::new, PathingConfig::isValidOption);
            this.pickaxeSneaking = builder.comment("Defines if sneaking is required to do custom chiseling using pickaxe's").define("pickaxeSneaking", false);
            this.axeStripping = builder.comment("A list of additional stripping behaviors using axe's [Syntax: \"domain:block,domain:replacement\" ]\n[Example: \"minecraft:stripped_oak_log,minecraft:oak_planks\"]").defineListAllowEmpty("axeStripping", List::of, String::new, PathingConfig::isValidOption);
            this.axeSneaking = builder.comment("Defines if sneaking is required to do custom stripping using axe's").define("axeSneaking", false);
            this.hoeTilling = builder.comment("A list of additional tilling behaviors using hoe's [Syntax: \"domain:block,domain:replacement\" ]\n[Example: \"minecraft:podzol,minecraft:farmland\"]").defineListAllowEmpty("hoeTilling", List::of, String::new, PathingConfig::isValidOption);
            this.hoeSneaking = builder.comment("Defines if sneaking is required to do custom tilling using hoe's").define("hoeSneaking", false);
            builder.pop();
        }
    }
}

