/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.pathingtheway.datagen;

import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class PathingDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(true, (DataProvider)new PathingLanguageProvider(packOutput));
    }

    public static class PathingLanguageProvider
    extends LanguageProvider {
        public PathingLanguageProvider(PackOutput packOutput) {
            super(packOutput, "pathingtheway", "en_us");
        }

        protected void addTranslations() {
            this.addConfig("common", "Common", "Common settings");
            this.addConfig("shovelPathing", "Shovel Pathing", "A list of additional pathing behaviors using shovels [Syntax: \"domain:block,domain:replacement\" ]\n[Example: \"minecraft:podzol,minecraft:dirt_path\"]");
            this.addConfig("shovelSneaking", "Shovel Sneaking", "Defines if sneaking is required to do custom pathing using shovels");
            this.addConfig("pickaxeChiseling", "Pickaxe Chiseling", "A list of additional chiseling behaviors using pickaxe's [Syntax: \"domain:block,domain:replacement\" ]\n[Example: \"minecraft:stone,minecraft:stone_stairs\"]");
            this.addConfig("pickaxeSneaking", "Pickaxe Sneaking", "Defines if sneaking is required to do custom chiseling using pickaxe's");
            this.addConfig("axeStripping", "Axe Stripping", "A list of additional stripping behaviors using axe's [Syntax: \"domain:block,domain:replacement\" ]\n[Example: \"minecraft:stripped_oak_log,minecraft:oak_planks\"]");
            this.addConfig("axeSneaking", "Axe Sneaking", "Defines if sneaking is required to do custom stripping using axe's");
            this.addConfig("hoeTilling", "Hoe Tilling", "A list of additional tilling behaviors using hoe's [Syntax: \"domain:block,domain:replacement\" ]\n[Example: \"minecraft:podzol,minecraft:farmland\"]");
            this.addConfig("hoeSneaking", "Hoe Sneaking", "Defines if sneaking is required to do custom tilling using hoe's");
        }

        private void addConfig(String path, String name, @Nullable String description) {
            this.add("pathingtheway.configuration." + path, name);
            if (description != null && !description.isEmpty()) {
                this.add("pathingtheway.configuration." + path + ".tooltip", description);
            }
        }
    }
}

