/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.pathingtheway.handler;

import com.mrbysco.pathingtheway.config.ConfigCache;
import com.mrbysco.pathingtheway.config.PathingConfig;
import com.mrbysco.pathingtheway.handler.ToolType;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class PathHandler {
    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        BlockHitResult blockHitResult = event.getHitVec();
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState oldState = level.getBlockState(pos);
        ResourceLocation blockLocation = BuiltInRegistries.BLOCK.getKey((Object)level.getBlockState(pos).getBlock());
        if (blockLocation != null && !stack.isEmpty() && stack.has(DataComponents.TOOL)) {
            ResourceLocation newLoc;
            Block block;
            Map<ResourceLocation, ResourceLocation> actionMap;
            Player player = event.getEntity();
            ToolType action = this.getToolType(stack);
            if (this.isSneaking(action, player) && (actionMap = ConfigCache.toolActionMap.get((Object)action)).containsKey(blockLocation) && (block = (Block)BuiltInRegistries.BLOCK.getValue(newLoc = actionMap.get(blockLocation))) != null) {
                BlockState newState = block.defaultBlockState();
                Direction direction = event.getFace();
                if (oldState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && newState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    newState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)oldState.getValue((Property)BlockStateProperties.WATERLOGGED)));
                }
                if (newState.hasProperty((Property)BlockStateProperties.SLAB_TYPE) && direction != Direction.DOWN && direction != Direction.UP && blockHitResult.getLocation().y - (double)pos.getY() < 0.5) {
                    newState = (BlockState)newState.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP);
                }
                if (newState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection());
                }
                if (newState.hasProperty((Property)BlockStateProperties.HALF)) {
                    newState = (BlockState)newState.setValue((Property)BlockStateProperties.HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && blockHitResult.getLocation().y - (double)pos.getY() < 0.5) ? Half.BOTTOM : Half.TOP));
                }
                level.setBlockAndUpdate(pos, newState);
                if (!player.getAbilities().instabuild) {
                    stack.hurtAndBreak(1, (LivingEntity)player, event.getHand().asEquipmentSlot());
                }
                level.playSound((Entity)player, pos, newState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }

    public boolean isSneaking(ToolType toolType, Player playerEntity) {
        if (toolType == null) {
            return false;
        }
        boolean flag = playerEntity.isShiftKeyDown();
        if (toolType == ToolType.AXE) {
            return flag == (Boolean)PathingConfig.COMMON.axeSneaking.get();
        }
        if (toolType == ToolType.PICKAXE) {
            return flag == (Boolean)PathingConfig.COMMON.pickaxeSneaking.get();
        }
        if (toolType == ToolType.HOE) {
            return flag == (Boolean)PathingConfig.COMMON.hoeSneaking.get();
        }
        if (toolType == ToolType.SHOVEL) {
            return flag == (Boolean)PathingConfig.COMMON.shovelSneaking.get();
        }
        return true;
    }

    public ToolType getToolType(ItemStack stack) {
        if (stack.is(ItemTags.AXES)) {
            return ToolType.AXE;
        }
        if (stack.is(ItemTags.PICKAXES)) {
            return ToolType.PICKAXE;
        }
        if (stack.is(ItemTags.HOES)) {
            return ToolType.HOE;
        }
        if (stack.is(ItemTags.SHOVELS)) {
            return ToolType.SHOVEL;
        }
        return null;
    }
}

