/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Arena;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Arena {
    private final String name;
    private Location spawn1;
    private Location spawn2;
    private boolean occupied;
    private final List<Player> spectators;
    private Location spectatorSpawn;

    public Arena(String name, Location spawn1, Location spawn2) {
        this.name = name;
        this.spawn1 = spawn1;
        this.spawn2 = spawn2;
        this.occupied = false;
        this.spectators = new ArrayList<Player>();
    }

    public String getName() {
        return this.name;
    }

    public Location getSpawn1() {
        return this.spawn1.clone();
    }

    public Location getSpawn2() {
        return this.spawn2.clone();
    }

    public boolean isOccupied() {
        return this.occupied;
    }

    public void setOccupied(boolean occupied) {
        this.occupied = occupied;
    }

    public void addSpectator(Player player) {
        if (!this.spectators.contains(player)) {
            this.spectators.add(player);
        }
    }

    public void setSpectatorSpawn(Location location) {
        this.spectatorSpawn = location;
    }

    public void setSpawn1(Location location) {
        this.spawn1 = location;
    }

    public void setSpawn2(Location location) {
        this.spawn2 = location;
    }

    public Location getSpectatorSpawn() {
        return this.spectatorSpawn != null ? this.spectatorSpawn.clone() : null;
    }

    public void removeSpectator(Player player) {
        this.spectators.remove(player);
    }

    public List<Player> getSpectators() {
        return Collections.unmodifiableList(this.spectators);
    }

    public boolean isSpectating(Player player) {
        return this.spectators.contains(player);
    }

    public String toString() {
        return "Arena{name='" + this.name + "', occupied=" + this.occupied + ", spectators=" + this.spectators.size() + "}";
    }
}

