/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Arena;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.garsooon.arenafighter.Arena.Arena;
import org.garsooon.arenafighter.Arena.ArenaFighter;

public class ArenaManager {
    private final ArenaFighter plugin;
    private final Map<String, Arena> arenas;
    private final List<Arena> availableArenas;
    private final Map<Player, Arena> spectators;
    private final Logger logger;
    private final File configFile;

    public ArenaManager(ArenaFighter plugin) {
        this.plugin = plugin;
        this.arenas = new HashMap<String, Arena>();
        this.availableArenas = new ArrayList<Arena>();
        this.spectators = new HashMap<Player, Arena>();
        this.logger = Logger.getLogger("ArenaFighter");
        this.configFile = new File(plugin.getDataFolder(), "arenas.properties");
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdirs();
        }
    }

    public void loadArenas() {
        if (!this.configFile.exists()) {
            this.logger.warning("No arenas configured! Please set up arenas using commands.");
            return;
        }
        Properties props = new Properties();
        try {
            FileInputStream fis = new FileInputStream(this.configFile);
            Iterator iterator = null;
            try {
                props.load(fis);
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (fis != null) {
                    if (iterator != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        fis.close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.warning("Failed to load arenas config: " + e.getMessage());
            return;
        }
        HashMap<String, Boolean> arenaNames = new HashMap<String, Boolean>();
        for (Object e : props.keySet()) {
            String keyStr = (String)e;
            if (!keyStr.contains(".")) continue;
            String arenaName = keyStr.substring(0, keyStr.indexOf(46));
            arenaNames.put(arenaName, true);
        }
        for (String string : arenaNames.keySet()) {
            try {
                String worldName = props.getProperty(string + ".world");
                World world = this.plugin.getServer().getWorld(worldName);
                if (world == null) {
                    this.logger.warning("World '" + worldName + "' not found for arena '" + string + "'");
                    continue;
                }
                Location spawn1 = new Location(world, Double.parseDouble(props.getProperty(string + ".spawn1.x", "0")), Double.parseDouble(props.getProperty(string + ".spawn1.y", "64")), Double.parseDouble(props.getProperty(string + ".spawn1.z", "0")), Float.parseFloat(props.getProperty(string + ".spawn1.yaw", "0")), Float.parseFloat(props.getProperty(string + ".spawn1.pitch", "0")));
                Location spawn2 = new Location(world, Double.parseDouble(props.getProperty(string + ".spawn2.x", "0")), Double.parseDouble(props.getProperty(string + ".spawn2.y", "64")), Double.parseDouble(props.getProperty(string + ".spawn2.z", "0")), Float.parseFloat(props.getProperty(string + ".spawn2.yaw", "0")), Float.parseFloat(props.getProperty(string + ".spawn2.pitch", "0")));
                Location spectatorSpawn = new Location(world, Double.parseDouble(props.getProperty(string + ".spectator.x", "0")), Double.parseDouble(props.getProperty(string + ".spectator.y", "64")), Double.parseDouble(props.getProperty(string + ".spectator.z", "0")), Float.parseFloat(props.getProperty(string + ".spectator.yaw", "0")), Float.parseFloat(props.getProperty(string + ".spectator.pitch", "0")));
                Arena arenaObj = new Arena(string, spawn1, spawn2);
                arenaObj.setSpectatorSpawn(spectatorSpawn);
                this.arenas.put(string, arenaObj);
                this.availableArenas.add(arenaObj);
                this.logger.info("Loaded arena: " + string);
            }
            catch (Exception e) {
                this.logger.warning("Failed to load arena '" + string + "': " + e.getMessage());
            }
        }
    }

    public Arena getArena(String name) {
        return this.arenas.get(name);
    }

    public Arena getAvailableArena() {
        if (this.availableArenas.isEmpty()) {
            return null;
        }
        return this.availableArenas.get(0);
    }

    public void occupyArena(Arena arena) {
        this.availableArenas.remove(arena);
        arena.setOccupied(true);
    }

    public void releaseArena(Arena arena) {
        arena.setOccupied(false);
        if (!this.availableArenas.contains(arena)) {
            this.availableArenas.add(arena);
        }
    }

    public void createArena(String name, Location spawn1, Location spawn2, Location spectatorSpawn) {
        Arena arena = new Arena(name, spawn1, spawn2);
        arena.setSpectatorSpawn(spectatorSpawn);
        this.arenas.put(name, arena);
        this.availableArenas.add(arena);
        this.saveArenaToConfig(name, spawn1, spawn2, spectatorSpawn);
    }

    public void removeArena(String name) {
        Arena arena = this.arenas.remove(name);
        if (arena != null) {
            this.availableArenas.remove(arena);
            this.removeArenaFromConfig(name);
        }
    }

    public void saveArenaToConfig(String name, Location spawn1, Location spawn2, Location spectatorSpawn) {
        Throwable throwable;
        Properties props = new Properties();
        if (this.configFile.exists()) {
            try {
                throwable = null;
                try (FileInputStream fis = new FileInputStream(this.configFile);){
                    props.load(fis);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                this.logger.warning("Failed to load existing config: " + e.getMessage());
            }
        }
        props.setProperty(name + ".world", spawn1.getWorld().getName());
        props.setProperty(name + ".spawn1.x", String.valueOf(spawn1.getX()));
        props.setProperty(name + ".spawn1.y", String.valueOf(spawn1.getY()));
        props.setProperty(name + ".spawn1.z", String.valueOf(spawn1.getZ()));
        props.setProperty(name + ".spawn1.yaw", String.valueOf(spawn1.getYaw()));
        props.setProperty(name + ".spawn1.pitch", String.valueOf(spawn1.getPitch()));
        props.setProperty(name + ".spawn2.x", String.valueOf(spawn2.getX()));
        props.setProperty(name + ".spawn2.y", String.valueOf(spawn2.getY()));
        props.setProperty(name + ".spawn2.z", String.valueOf(spawn2.getZ()));
        props.setProperty(name + ".spawn2.yaw", String.valueOf(spawn2.getYaw()));
        props.setProperty(name + ".spawn2.pitch", String.valueOf(spawn2.getPitch()));
        props.setProperty(name + ".spectator.x", String.valueOf(spectatorSpawn.getX()));
        props.setProperty(name + ".spectator.y", String.valueOf(spectatorSpawn.getY()));
        props.setProperty(name + ".spectator.z", String.valueOf(spectatorSpawn.getZ()));
        props.setProperty(name + ".spectator.yaw", String.valueOf(spectatorSpawn.getYaw()));
        props.setProperty(name + ".spectator.pitch", String.valueOf(spectatorSpawn.getPitch()));
        try {
            throwable = null;
            try (FileOutputStream fos = new FileOutputStream(this.configFile);){
                props.store(fos, "Arena Fighter Arenas Configuration");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            this.logger.warning("Failed to save arena config: " + e.getMessage());
        }
    }

    private void removeArenaFromConfig(String name) {
        Properties props = new Properties();
        if (this.configFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.configFile);
                Object object = null;
                try {
                    props.load(fis);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (fis != null) {
                        if (object != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            fis.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.logger.warning("Failed to load existing config: " + e.getMessage());
                return;
            }
        }
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Object object : props.keySet()) {
            String keyStr = (String)object;
            if (!keyStr.startsWith(name + ".")) continue;
            keysToRemove.add(keyStr);
        }
        for (String string : keysToRemove) {
            props.remove(string);
        }
        try {
            Throwable throwable = null;
            try (FileOutputStream fos = new FileOutputStream(this.configFile);){
                props.store(fos, "Arena Fighter Arenas Configuration");
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            this.logger.warning("Failed to save arena config: " + e.getMessage());
        }
    }

    public List<String> getArenaNames() {
        return new ArrayList<String>(this.arenas.keySet());
    }

    public void addSpectator(Player player, Arena arena) {
        this.spectators.put(player, arena);
        arena.addSpectator(player);
    }

    public void removeSpectator(Player player) {
        Arena arena = this.spectators.remove(player);
        if (arena != null) {
            arena.removeSpectator(player);
        }
    }

    public Arena getSpectatingArena(Player player) {
        return this.spectators.get(player);
    }

    public boolean isSpectating(Player player) {
        return this.spectators.containsKey(player);
    }
}

