/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Commands;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.garsooon.arenafighter.Data.Bet;
import org.garsooon.arenafighter.Data.Challenge;
import org.garsooon.arenafighter.Economy.Method;
import org.garsooon.arenafighter.Economy.Methods;
import org.garsooon.arenafighter.Fight.FightManager;

public class FightCommand
implements CommandExecutor {
    private final Plugin plugin;
    private final FightManager fightManager;
    private final Map<String, Challenge> pendingChallenges = new HashMap<String, Challenge>();
    private final Map<String, Integer> timeoutTasks = new HashMap<String, Integer>();
    private final long TIMEOUT_TICKS = 600L;

    public FightCommand(Plugin plugin, FightManager fightManager) {
        this.plugin = plugin;
        this.fightManager = fightManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelp(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "challenge": {
                if (!player.hasPermission("arenafighter.fight")) {
                    player.sendMessage(ChatColor.RED + "You do not have permission to challenge.");
                    return true;
                }
                return this.handleChallenge(player, args);
            }
            case "accept": {
                if (!player.hasPermission("arenafighter.fight")) {
                    player.sendMessage(ChatColor.RED + "You do not have permission to accept fights.");
                    return true;
                }
                return this.handleAccept(player, args);
            }
            case "cancel": {
                if (!player.hasPermission("arenafighter.admin")) {
                    player.sendMessage(ChatColor.RED + "You do not have permission to cancel fights.");
                    return true;
                }
                return this.handleCancel(player);
            }
            case "leaderboard": {
                if (!player.hasPermission("arenafighter.fight")) {
                    player.sendMessage(ChatColor.RED + "You do not have permission to see the leaderboard.");
                    return true;
                }
                return this.handleLeaderboard(player);
            }
            case "stats": {
                if (!player.hasPermission("arenafighter.fight")) {
                    player.sendMessage(ChatColor.RED + "You do not have permission to see stats.");
                    return true;
                }
                return this.handleStats(player, args);
            }
        }
        this.sendHelp(player);
        return true;
    }

    private boolean handleChallenge(Player challenger, String[] args) {
        if (args.length < 2) {
            challenger.sendMessage(ChatColor.RED + "Usage: /fight challenge <player> [wagerAmount]");
            return true;
        }
        if (this.fightManager.isInFight(challenger)) {
            challenger.sendMessage(ChatColor.RED + "You're already in a fight!");
            return true;
        }
        Player target = challenger.getServer().getPlayer(args[1]);
        if (target == null || !target.isOnline()) {
            challenger.sendMessage(ChatColor.RED + "Player not found: " + args[1]);
            return true;
        }
        if (target.equals(challenger)) {
            challenger.sendMessage(ChatColor.RED + "You can't challenge yourself.");
            return true;
        }
        if (this.fightManager.isPunished(target)) {
            challenger.sendMessage(ChatColor.RED + "This player has left a match recently and is not");
            challenger.sendMessage(ChatColor.RED + "allowed to duel until their punishment is over.");
            return true;
        }
        long remainingMillis = this.fightManager.getRemainingPunishment(challenger);
        if (remainingMillis > 0L) {
            long minutes = remainingMillis / 1000L / 60L;
            long seconds = remainingMillis / 1000L % 60L;
            challenger.sendMessage(ChatColor.RED + "You are temporarily blocked from fighting due to leaving a");
            challenger.sendMessage(ChatColor.RED + "match for " + ChatColor.YELLOW + minutes + "m " + seconds + "s" + ChatColor.RED + ".");
            return true;
        }
        if (this.fightManager.isInFight(target)) {
            challenger.sendMessage(ChatColor.RED + target.getName() + " is already in a fight.");
            return true;
        }
        if (this.hasPendingChallenge(challenger.getName()) || this.hasPendingChallenge(target.getName())) {
            challenger.sendMessage(ChatColor.RED + "Either you or " + target.getName() + " already has a pending challenge.");
            return true;
        }
        double wagerAmount = 0.0;
        if (args.length >= 3) {
            try {
                wagerAmount = Double.parseDouble(args[2]);
                wagerAmount = Bet.roundDownTwoDecimals(wagerAmount);
                if (wagerAmount < 0.0) {
                    challenger.sendMessage(ChatColor.RED + "Wager amount cannot be negative.");
                    return true;
                }
            }
            catch (NumberFormatException e) {
                challenger.sendMessage(ChatColor.RED + "Invalid wager amount.");
                return true;
            }
            Method economy = Methods.getMethod();
            if (economy == null) {
                challenger.sendMessage(ChatColor.RED + "Economy plugin not found. Wagers are disabled.");
                return true;
            }
            if (!economy.hasEnough(challenger.getName(), wagerAmount, challenger.getWorld())) {
                challenger.sendMessage(ChatColor.RED + "You do not have enough funds to make this wager.");
                return true;
            }
            if (!economy.hasEnough(target.getName(), wagerAmount, target.getWorld())) {
                challenger.sendMessage(ChatColor.RED + target.getName() + " does not have enough funds to accept this wager.");
                return true;
            }
        }
        Challenge challenge = new Challenge(challenger.getName(), System.currentTimeMillis(), wagerAmount);
        this.pendingChallenges.put(target.getName(), challenge);
        challenger.sendMessage(ChatColor.YELLOW + "Challenge sent to " + ChatColor.WHITE + target.getName());
        if (wagerAmount > 0.0) {
            target.sendMessage(ChatColor.YELLOW + "You've been challenged by " + ChatColor.WHITE + challenger.getName() + ChatColor.YELLOW + " with a wager of " + ChatColor.GREEN + wagerAmount + ChatColor.YELLOW + "!");
        } else {
            target.sendMessage(ChatColor.YELLOW + "You've been challenged by " + ChatColor.WHITE + challenger.getName() + ChatColor.YELLOW + "!");
        }
        target.sendMessage(ChatColor.GREEN + "Use " + ChatColor.WHITE + "/fight accept " + challenger.getName() + ChatColor.GREEN + " to accept.");
        int taskId = this.plugin.getServer().getScheduler().scheduleSyncDelayedTask(this.plugin, () -> {
            Challenge active = this.pendingChallenges.get(target.getName());
            if (active != null && active.getChallengerName().equals(challenger.getName())) {
                this.pendingChallenges.remove(target.getName());
                this.timeoutTasks.remove(target.getName());
                challenger.sendMessage(ChatColor.RED + target.getName() + " didn't respond to your duel request.");
                target.sendMessage(ChatColor.RED + "You didn't respond to " + challenger.getName() + "'s duel request.");
            }
        }, 600L);
        this.timeoutTasks.put(target.getName(), taskId);
        return true;
    }

    private boolean hasPendingChallenge(String playerName) {
        if (this.pendingChallenges.containsKey(playerName)) {
            return true;
        }
        for (Challenge challenge : this.pendingChallenges.values()) {
            if (!challenge.getChallengerName().equalsIgnoreCase(playerName)) continue;
            return true;
        }
        return false;
    }

    private boolean handleAccept(Player accepter, String[] args) {
        if (args.length < 2) {
            accepter.sendMessage(ChatColor.RED + "Usage: /fight accept <player>");
            return true;
        }
        String challengerName = args[1];
        Player challenger = accepter.getServer().getPlayer(challengerName);
        Challenge challenge = this.pendingChallenges.get(accepter.getName());
        if (challenger == null || !challenger.isOnline()) {
            accepter.sendMessage(ChatColor.RED + "Player not found: " + challengerName);
            return true;
        }
        if (challenge == null || !challenge.getChallengerName().equalsIgnoreCase(challengerName)) {
            accepter.sendMessage(ChatColor.RED + "No pending challenge from " + challengerName);
            return true;
        }
        this.pendingChallenges.remove(accepter.getName());
        this.cancelTimeout(accepter.getName());
        if (this.fightManager.isInFight(challenger) || this.fightManager.isInFight(accepter)) {
            accepter.sendMessage(ChatColor.RED + "Either you or " + challengerName + " is already in a fight.");
            return true;
        }
        double wager = challenge.getWagerAmount();
        double truncatedWager = Bet.roundDownTwoDecimals(wager);
        if (wager > 0.0) {
            if (!this.fightManager.hasSufficientFunds(challenger, wager)) {
                accepter.sendMessage(ChatColor.RED + "The challenger doesn't have enough funds to cover the wager.");
                return true;
            }
            if (!this.fightManager.hasSufficientFunds(accepter, wager)) {
                accepter.sendMessage(ChatColor.RED + "You don't have enough funds to accept this wager.");
                return true;
            }
        }
        String line1 = ChatColor.GOLD + accepter.getName() + ChatColor.YELLOW + " has accepted " + ChatColor.GOLD + challenger.getName() + ChatColor.YELLOW + "'s duel request";
        String line2 = (truncatedWager > 0.0 ? ChatColor.YELLOW + " with a wager of " + ChatColor.GREEN + truncatedWager : "") + ChatColor.YELLOW + "!";
        String line3 = ChatColor.YELLOW + "The fight will begin in 30 seconds...";
        Bukkit.broadcastMessage((String)line1);
        Bukkit.broadcastMessage((String)line2);
        Bukkit.broadcastMessage((String)line3);
        int fifteenSecondsTicks = 300;
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask(this.plugin, () -> {
            challenger.sendMessage(ChatColor.YELLOW + "Fight starting in 15 seconds...");
            accepter.sendMessage(ChatColor.YELLOW + "Fight starting in 15 seconds...");
        }, (long)fifteenSecondsTicks);
        int thirtySecondsTicks = 600;
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask(this.plugin, () -> {
            boolean success = this.fightManager.startFight(challenger, accepter, wager);
            if (!success) {
                accepter.sendMessage(ChatColor.RED + "Could not start fight. No available arenas.");
                challenger.sendMessage(ChatColor.RED + "Could not start fight. No available arenas.");
            }
        }, (long)thirtySecondsTicks);
        return true;
    }

    private boolean handleLeaderboard(Player player) {
        Map<String, Integer> topPlayers = this.fightManager.getTopPlayersByWins();
        if (topPlayers.isEmpty()) {
            player.sendMessage(ChatColor.RED + "No leaderboard data found.");
            return true;
        }
        player.sendMessage(ChatColor.GOLD + "=== ArenaFighter Leaderboard ===");
        int rank = 1;
        for (Map.Entry<String, Integer> entry : topPlayers.entrySet()) {
            player.sendMessage(ChatColor.YELLOW + "#" + rank + " " + ChatColor.AQUA + entry.getKey() + ChatColor.WHITE + " - " + ChatColor.GREEN + entry.getValue() + " wins");
            ++rank;
        }
        return true;
    }

    private boolean handleStats(Player player, String[] args) {
        String targetName = args.length == 1 ? player.getName() : args[1];
        List<String> statsLines = this.fightManager.getPlayerStatsByName(targetName);
        for (String line : statsLines) {
            player.sendMessage(line);
        }
        return true;
    }

    private boolean handleCancel(Player player) {
        if (!this.fightManager.isInFight(player)) {
            player.sendMessage(ChatColor.RED + "You're not in a fight.");
            return true;
        }
        this.fightManager.cancelFight(player);
        player.sendMessage(ChatColor.YELLOW + "Fight cancelled.");
        return true;
    }

    private void sendHelp(Player player) {
        player.sendMessage(ChatColor.GOLD + "=== Arena Fighter Commands ===");
        player.sendMessage(ChatColor.YELLOW + "/fight challenge <player> <wager>" + ChatColor.WHITE + " - Challenge a player");
        player.sendMessage(ChatColor.YELLOW + "/fight accept <player>" + ChatColor.WHITE + " - Accept a challenge");
        player.sendMessage(ChatColor.YELLOW + "/fight cancel" + ChatColor.WHITE + " - Cancel current fight");
        player.sendMessage(ChatColor.YELLOW + "/fight leaderboard" + ChatColor.WHITE + " - Show top 10 fighters");
        player.sendMessage(ChatColor.YELLOW + "/fight stats <player>" + ChatColor.WHITE + " - Show player stats");
        player.sendMessage(ChatColor.YELLOW + "/fight help" + ChatColor.WHITE + " - Show help");
        player.sendMessage(ChatColor.YELLOW + "/spectate <arena>" + ChatColor.WHITE + " - Start spectating");
    }

    private void cancelTimeout(String name) {
        Integer taskId = this.timeoutTasks.remove(name);
        if (taskId != null) {
            this.plugin.getServer().getScheduler().cancelTask(taskId.intValue());
        }
    }

    public void cancelChallengesInvolving(String playerName) {
        Iterator<Map.Entry<String, Challenge>> iterator = this.pendingChallenges.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Challenge> entry = iterator.next();
            String receiver = entry.getKey();
            String challenger = entry.getValue().getChallengerName();
            if (receiver.equalsIgnoreCase(playerName)) {
                Player challengerPlayer = this.plugin.getServer().getPlayer(challenger);
                if (challengerPlayer != null && challengerPlayer.isOnline()) {
                    challengerPlayer.sendMessage(ChatColor.RED + "Your challenge to " + receiver + " was cancelled because they left the server.");
                }
                this.cancelTimeout(receiver);
                iterator.remove();
                continue;
            }
            if (!challenger.equalsIgnoreCase(playerName)) continue;
            Player receiverPlayer = this.plugin.getServer().getPlayer(receiver);
            if (receiverPlayer != null && receiverPlayer.isOnline()) {
                receiverPlayer.sendMessage(ChatColor.RED + "Challenge from " + challenger + " was cancelled because they left the server.");
            }
            this.cancelTimeout(receiver);
            iterator.remove();
        }
    }
}

