/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Commands;

import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.garsooon.arenafighter.Fight.FightManager;

public class SpectateCommand
implements CommandExecutor {
    private final FightManager fightManager;

    public SpectateCommand(FightManager fightManager) {
        this.fightManager = fightManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (this.fightManager.isSpectating(player)) {
            boolean stopped = this.fightManager.stopSpectating(player);
            if (stopped) {
                player.sendMessage(ChatColor.YELLOW + "You have stopped spectating and returned to your original location.");
            } else {
                player.sendMessage(ChatColor.RED + "An error occurred while stopping spectating.");
            }
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(ChatColor.RED + "Usage: /spectate <arena>");
            return true;
        }
        String arenaName = args[0];
        boolean started = this.fightManager.startSpectating(player, arenaName);
        if (!started) {
            player.sendMessage(ChatColor.RED + "Arena not found or spectator spawn not set.");
        }
        return true;
    }
}

