/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Fight;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.garsooon.arenafighter.Arena.Arena;
import org.garsooon.arenafighter.Data.Bet;
import org.garsooon.arenafighter.Economy.Methods;

public class Fight {
    private final Player player1;
    private final Player player2;
    private final Arena arena;
    private final long startTime;
    private final double wager;
    private final Map<String, Bet> bets = new HashMap<String, Bet>();
    private boolean started = false;

    public Fight(Player player1, Player player2, Arena arena) {
        this(player1, player2, arena, 0.0);
    }

    public Fight(Player player1, Player player2, Arena arena, double wager) {
        this.player1 = player1;
        this.player2 = player2;
        this.arena = arena;
        this.startTime = System.currentTimeMillis();
        this.wager = wager;
    }

    public Player getPlayer1() {
        return this.player1;
    }

    public Player getPlayer2() {
        return this.player2;
    }

    public Arena getArena() {
        return this.arena;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public double getWager() {
        return this.wager;
    }

    public Player getOtherPlayer(Player player) {
        if (player.equals(this.player1)) {
            return this.player2;
        }
        if (player.equals(this.player2)) {
            return this.player1;
        }
        return null;
    }

    public boolean containsPlayer(Player player) {
        return player.equals(this.player1) || player.equals(this.player2);
    }

    public boolean isFighter(String name) {
        return this.player1.getName().equalsIgnoreCase(name) || this.player2.getName().equalsIgnoreCase(name);
    }

    public boolean placeBet(String spectator, String fighter, double amount) {
        if (this.bets.containsKey(spectator)) {
            return false;
        }
        this.bets.put(spectator, new Bet(spectator, fighter, amount));
        return true;
    }

    public boolean hasStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public void resolveBets(String winner) {
        double winnerPool = 0.0;
        double loserPool = 0.0;
        for (Bet bet : this.bets.values()) {
            if (bet.getFighter().equalsIgnoreCase(winner)) {
                winnerPool += bet.getAmount();
                continue;
            }
            loserPool += bet.getAmount();
        }
        if (winnerPool == 0.0) {
            for (Bet bet : this.bets.values()) {
                Player p = Bukkit.getPlayer((String)bet.getSpectator());
                if (p == null) continue;
                p.sendMessage(ChatColor.RED + "No one won the bets. Better luck next time!");
            }
            return;
        }
        for (Bet bet : this.bets.values()) {
            Player p = Bukkit.getPlayer((String)bet.getSpectator());
            if (p == null) continue;
            if (bet.getFighter().equalsIgnoreCase(winner)) {
                double base = bet.getAmount();
                double share = bet.getAmount() / winnerPool * loserPool;
                double payout = base + share;
                Methods.getMethod().depositPlayer(bet.getSpectator(), payout, p.getWorld());
                p.sendMessage(ChatColor.GOLD + "You won your bet on " + winner + "! You receive " + payout);
                continue;
            }
            p.sendMessage(ChatColor.RED + "You lost your bet on " + bet.getFighter() + ".");
        }
    }

    public void clearBets() {
        this.bets.clear();
    }

    public String toString() {
        return "Fight{" + this.player1.getName() + " vs " + this.player2.getName() + " in " + this.arena.getName() + " with wager " + this.wager + "}";
    }
}

