/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Fight;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet101CloseWindow;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.garsooon.arenafighter.Arena.Arena;
import org.garsooon.arenafighter.Arena.ArenaFighter;
import org.garsooon.arenafighter.Arena.ArenaManager;
import org.garsooon.arenafighter.Data.Bet;
import org.garsooon.arenafighter.Data.PlayerDataManager;
import org.garsooon.arenafighter.Economy.Method;
import org.garsooon.arenafighter.Fight.Fight;
import org.yaml.snakeyaml.Yaml;

public class FightManager {
    private final ArenaFighter plugin;
    private final ArenaManager arenaManager;
    private final Map<UUID, Fight> activeFights;
    private final Map<UUID, Location> originalLocations;
    private final Map<UUID, org.bukkit.inventory.ItemStack[]> originalInventories = new HashMap<UUID, org.bukkit.inventory.ItemStack[]>();
    private final Map<UUID, org.bukkit.inventory.ItemStack[]> originalArmor = new HashMap<UUID, org.bukkit.inventory.ItemStack[]>();
    private final HashMap<UUID, Integer> postFightCooldowns = new HashMap();
    private final Map<UUID, FightChallenge> pendingChallenges;
    private final Map<UUID, Location> spectatorOriginalLocations;
    private final Map<UUID, Long> punishments = new HashMap<UUID, Long>();
    private final long punishmentDurationMillis;
    private final Method economy;
    private final File statsFile;
    private Map<String, Object> stats;
    private final PlayerDataManager playerDataManager = new PlayerDataManager();

    public FightManager(ArenaFighter plugin, ArenaManager arenaManager, Method economy) {
        this.plugin = plugin;
        this.arenaManager = arenaManager;
        this.economy = economy;
        this.activeFights = new HashMap<UUID, Fight>();
        this.originalLocations = new HashMap<UUID, Location>();
        this.pendingChallenges = new HashMap<UUID, FightChallenge>();
        this.spectatorOriginalLocations = new HashMap<UUID, Location>();
        this.punishmentDurationMillis = this.loadPunishmentDuration(plugin.getDataFolder());
        this.statsFile = new File(plugin.getDataFolder(), "stats.yml");
        this.loadStats();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long loadPunishmentDuration(File dataFolder) {
        File configFile = new File(dataFolder, "config.yml");
        long defaultMinutes = 5L;
        if (!configFile.exists()) {
            return defaultMinutes * 60L * 1000L;
        }
        try (FileInputStream input = new FileInputStream(configFile);){
            Yaml yaml = new Yaml();
            Object data = yaml.load((InputStream)input);
            if (!(data instanceof Map)) return defaultMinutes * 60L * 1000L;
            Map root = (Map)data;
            Object punishmentObj = root.get("punishment");
            if (!(punishmentObj instanceof Map)) return defaultMinutes * 60L * 1000L;
            Map punishmentMap = (Map)punishmentObj;
            Object minutesObj = punishmentMap.get("duration-minutes");
            if (!(minutesObj instanceof Number)) return defaultMinutes * 60L * 1000L;
            long l = ((Number)minutesObj).longValue() * 60L * 1000L;
            return l;
        }
        catch (Exception e) {
            this.plugin.getServer().getLogger().warning("Failed to load punishment duration: " + e.getMessage());
        }
        return defaultMinutes * 60L * 1000L;
    }

    public void punishQuitter(Player quitter) {
        long expireAt = System.currentTimeMillis() + this.punishmentDurationMillis;
        this.punishments.put(quitter.getUniqueId(), expireAt);
    }

    public long getRemainingPunishment(Player player) {
        Long expireTime = this.punishments.get(player.getUniqueId());
        if (expireTime == null) {
            return 0L;
        }
        return Math.max(0L, expireTime - System.currentTimeMillis());
    }

    public boolean isPunished(Player player) {
        UUID uuid = player.getUniqueId();
        Long expire = this.punishments.get(uuid);
        if (expire == null) {
            return false;
        }
        if (System.currentTimeMillis() > expire) {
            this.punishments.remove(uuid);
            return false;
        }
        return true;
    }

    public long getPunishmentDurationMillis() {
        return this.punishmentDurationMillis;
    }

    public int getPunishmentDurationMinutes() {
        return (int)(this.punishmentDurationMillis / 1000L / 60L);
    }

    public ArenaFighter getPlugin() {
        return this.plugin;
    }

    private boolean tryWithdraw(Player player, double amount) {
        if (amount <= 0.0) {
            return true;
        }
        boolean success = this.economy.withdrawPlayer(player.getName(), amount, player.getWorld());
        if (!success) {
            player.sendMessage(ChatColor.RED + "You do not have enough money to wager " + amount);
        }
        return success;
    }

    public void deposit(Player player, double amount) {
        if (amount <= 0.0) {
            return;
        }
        this.economy.depositPlayer(player.getName(), amount, player.getWorld());
    }

    public boolean hasSufficientFunds(Player player, double amount) {
        return this.economy != null && this.economy.hasEnough(player.getName(), amount, player.getWorld());
    }

    public Fight getFightByArena(String arenaName) {
        for (Fight fight : this.activeFights.values()) {
            if (!fight.getArena().getName().equalsIgnoreCase(arenaName)) continue;
            return fight;
        }
        return null;
    }

    public Collection<Fight> getActiveFights() {
        return this.activeFights.values();
    }

    private void ejectPlayer(Player player) {
        if (player.isInsideVehicle()) {
            player.leaveVehicle();
        }
        CraftPlayer cp = (CraftPlayer)player;
        EntityPlayer eh = cp.getHandle();
        if (eh.sleeping) {
            eh.a(true, true, true);
        }
    }

    public boolean startFight(Player player1, Player player2, double wager) {
        Arena arena;
        double truncatedWager = Bet.roundDownTwoDecimals(wager);
        if (this.isInFight(player1) || this.isInFight(player2)) {
            return false;
        }
        if (wager > 0.0) {
            if (!this.hasSufficientFunds(player1, wager)) {
                player1.sendMessage(ChatColor.RED + "You no longer have enough money to enter this fight.");
                player2.sendMessage(ChatColor.RED + player1.getName() + " no longer has enough money. Fight canceled.");
                return false;
            }
            if (!this.hasSufficientFunds(player2, wager)) {
                player2.sendMessage(ChatColor.RED + "You no longer have enough money to enter this fight.");
                player1.sendMessage(ChatColor.RED + player2.getName() + " no longer has enough money. Fight canceled.");
                return false;
            }
        }
        if (wager > 0.0) {
            if (!this.tryWithdraw(player1, wager)) {
                return false;
            }
            if (!this.tryWithdraw(player2, wager)) {
                this.deposit(player1, wager);
                return false;
            }
        }
        if ((arena = this.arenaManager.getAvailableArena()) == null) {
            if (wager > 0.0) {
                this.deposit(player1, wager);
                this.deposit(player2, wager);
            }
            return false;
        }
        this.originalLocations.put(player1.getUniqueId(), player1.getLocation().clone());
        this.originalLocations.put(player2.getUniqueId(), player2.getLocation().clone());
        Fight fight = new Fight(player1, player2, arena, wager);
        this.activeFights.put(player1.getUniqueId(), fight);
        this.activeFights.put(player2.getUniqueId(), fight);
        this.arenaManager.occupyArena(arena);
        this.forceCloseInventory(player1);
        this.forceCloseInventory(player2);
        if (!player1.isOnline() || !player2.isOnline()) {
            if (wager > 0.0) {
                this.deposit(player1, wager);
                this.deposit(player2, wager);
            }
            this.activeFights.remove(player1.getUniqueId());
            this.activeFights.remove(player2.getUniqueId());
            this.arenaManager.releaseArena(arena);
            this.plugin.getServer().broadcastMessage(ChatColor.YELLOW + "Fight between " + ChatColor.GOLD + player1.getName() + ChatColor.YELLOW + " and " + ChatColor.GOLD + player2.getName() + ChatColor.YELLOW + " was canceled because a player left.");
            return false;
        }
        this.ejectPlayer(player1);
        this.ejectPlayer(player2);
        player1.teleport(arena.getSpawn1());
        player2.teleport(arena.getSpawn2());
        this.healAndFeedPlayer(player1);
        this.healAndFeedPlayer(player2);
        String message = ChatColor.YELLOW + "Fight started! " + ChatColor.WHITE + player1.getName() + ChatColor.YELLOW + " vs " + ChatColor.WHITE + player2.getName() + ChatColor.YELLOW + " in arena " + ChatColor.GREEN + arena.getName();
        if (wager > 0.0) {
            message = message + ChatColor.YELLOW + " with a wager of " + ChatColor.GOLD + truncatedWager;
        }
        fight.clearBets();
        this.plugin.getServer().broadcastMessage(message);
        return true;
    }

    public void endFight(Player winner, Player loser) {
        Fight fight = this.activeFights.get(winner.getUniqueId());
        if (fight == null) {
            return;
        }
        this.activeFights.remove(winner.getUniqueId());
        this.activeFights.remove(loser.getUniqueId());
        this.arenaManager.releaseArena(fight.getArena());
        this.startPostFightCooldown(winner);
        this.startPostFightCooldown(loser);
        UUID loserId = loser.getUniqueId();
        org.bukkit.inventory.ItemStack[] inventory = (org.bukkit.inventory.ItemStack[])loser.getInventory().getContents().clone();
        org.bukkit.inventory.ItemStack[] armor = (org.bukkit.inventory.ItemStack[])loser.getInventory().getArmorContents().clone();
        org.bukkit.inventory.ItemStack cursor = this.getItemOnCursor(loser);
        if (cursor != null && cursor.getTypeId() != 0) {
            for (int i = 0; i < inventory.length; ++i) {
                if (inventory[i] != null && inventory[i].getTypeId() != 0) continue;
                inventory[i] = cursor;
                break;
            }
            this.setItemOnCursor(loser, new org.bukkit.inventory.ItemStack(0));
        }
        this.originalInventories.put(loserId, inventory);
        this.originalArmor.put(loserId, armor);
        Location winnerOriginal = this.originalLocations.remove(winner.getUniqueId());
        Location loserOriginal = this.originalLocations.remove(loser.getUniqueId());
        if (winnerOriginal != null) {
            winner.teleport(winnerOriginal);
            this.healAndFeedPlayer(winner);
        }
        if (loserOriginal != null) {
            loser.teleport(loserOriginal);
            this.restoreOriginalInventoryAndArmor(loser);
            this.healAndFeedPlayer(loser);
        }
        this.stopAllSpectators();
        double wager = fight.getWager();
        if (wager > 0.0) {
            double truncatedWager = Bet.roundDownTwoDecimals(wager);
            this.deposit(winner, wager * 2.0);
            winner.sendMessage(ChatColor.GREEN + "You have won " + wager * 2.0 + " from the wager!");
        }
        fight.resolveBets(winner.getName());
        this.incrementStat(winner.getUniqueId(), "wins", winner.getName());
        this.incrementStat(loser.getUniqueId(), "losses", loser.getName());
        String message = ChatColor.GOLD + winner.getName() + ChatColor.YELLOW + " has defeated " + ChatColor.RED + loser.getName() + ChatColor.YELLOW + " in arena " + ChatColor.GREEN + fight.getArena().getName();
        if (wager > 0.0) {
            double truncatedWager = Bet.roundDownTwoDecimals(wager * 2.0);
            message = message + ChatColor.YELLOW + " and won a wager of " + ChatColor.GOLD + truncatedWager;
        }
        message = message + ChatColor.YELLOW + "!";
        this.plugin.getServer().broadcastMessage(message);
    }

    private void restoreOriginalInventoryAndArmor(final Player player) {
        final UUID uuid = player.getUniqueId();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                final org.bukkit.inventory.ItemStack[] savedInventory = (org.bukkit.inventory.ItemStack[])FightManager.this.originalInventories.remove(uuid);
                final org.bukkit.inventory.ItemStack[] savedArmor = (org.bukkit.inventory.ItemStack[])FightManager.this.originalArmor.remove(uuid);
                if (savedInventory != null) {
                    player.getInventory().clear();
                    for (int i = savedInventory.length - 1; i >= 0; --i) {
                        org.bukkit.inventory.ItemStack item = savedInventory[i];
                        player.getInventory().setItem(i, item != null ? item.clone() : null);
                    }
                }
                if (savedArmor != null) {
                    player.getInventory().setArmorContents(savedArmor);
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)FightManager.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        player.updateInventory();
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)FightManager.this.plugin, new Runnable(){

                            @Override
                            public void run() {
                                boolean armorMismatch;
                                boolean inventoryMismatch = !FightManager.this.deepInventoryMatch(player.getInventory().getContents(), savedInventory);
                                boolean bl = armorMismatch = !FightManager.this.deepInventoryMatch(player.getInventory().getArmorContents(), savedArmor);
                                if (inventoryMismatch || armorMismatch) {
                                    player.sendMessage(ChatColor.RED + "Your inventory failed to restore properly. Retrying...");
                                    if (savedInventory != null) {
                                        org.bukkit.inventory.ItemStack[] current = player.getInventory().getContents();
                                        for (int i = 0; i < savedInventory.length; ++i) {
                                            if (FightManager.this.deepItemEquals(savedInventory[i], current[i])) continue;
                                            FightManager.this.plugin.getServer().getLogger().warning("[ArenaFighter] Inventory slot mismatch at " + i + " for player " + player.getName());
                                            FightManager.this.plugin.getServer().getLogger().warning("Expected: " + FightManager.this.itemToString(savedInventory[i]));
                                            FightManager.this.plugin.getServer().getLogger().warning("Found: " + FightManager.this.itemToString(current[i]));
                                        }
                                    }
                                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)FightManager.this.plugin, new Runnable(){

                                        @Override
                                        public void run() {
                                            player.getInventory().clear();
                                            for (int i = savedInventory.length - 1; i >= 0; --i) {
                                                org.bukkit.inventory.ItemStack item = savedInventory[i];
                                                player.getInventory().setItem(i, item != null ? item.clone() : null);
                                            }
                                            if (savedArmor != null) {
                                                player.getInventory().setArmorContents(savedArmor);
                                            }
                                            player.updateInventory();
                                            Map expected = FightManager.this.countItemQuantities(savedInventory);
                                            Map actual = FightManager.this.countItemQuantities(player.getInventory().getContents());
                                            for (Map.Entry entry : expected.entrySet()) {
                                                String key = (String)entry.getKey();
                                                int expectedAmount = (Integer)entry.getValue();
                                                int actualAmount = actual.getOrDefault(key, 0);
                                                if (actualAmount >= expectedAmount) continue;
                                                int missing = expectedAmount - actualAmount;
                                                String[] split = key.split(":");
                                                int typeId = Integer.parseInt(split[0]);
                                                short damage = Short.parseShort(split[1]);
                                                org.bukkit.inventory.ItemStack stack = new org.bukkit.inventory.ItemStack(typeId, missing, damage);
                                                player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{stack});
                                                FightManager.this.plugin.getServer().getLogger().warning("[ArenaFighter] Mismatch recovery for " + player.getName() + ": added back " + missing + " of ItemStack{typeId=" + typeId + ", damage=" + damage + "} (expected=" + expectedAmount + ", actual=" + actualAmount + ")");
                                            }
                                            player.updateInventory();
                                        }
                                    }, 2L);
                                }
                            }
                        }, 2L);
                    }
                }, 2L);
            }
        }, 3L);
    }

    public org.bukkit.inventory.ItemStack getItemOnCursor(Player player) {
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        ItemStack nms = ep.inventory.j();
        return nms != null ? new CraftItemStack(nms) : null;
    }

    public void setItemOnCursor(Player player, org.bukkit.inventory.ItemStack item) {
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        if (item == null || item.getTypeId() == 0) {
            ep.inventory.b((ItemStack)null);
        } else {
            ItemStack nmsStack = new ItemStack(item.getTypeId(), item.getAmount(), (int)item.getDurability());
            ep.inventory.b(nmsStack);
        }
        ep.z();
    }

    private Map<String, Integer> countItemQuantities(org.bukkit.inventory.ItemStack[] contents) {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        if (contents == null) {
            return countMap;
        }
        for (org.bukkit.inventory.ItemStack item : contents) {
            if (item == null || item.getTypeId() == 0) continue;
            String key = item.getTypeId() + ":" + item.getDurability();
            countMap.put(key, countMap.getOrDefault(key, 0) + item.getAmount());
        }
        return countMap;
    }

    private String itemToString(org.bukkit.inventory.ItemStack item) {
        if (item == null) {
            return "null";
        }
        return "ItemStack{" + item.getType() + " x " + item.getAmount() + "}";
    }

    private boolean deepInventoryMatch(org.bukkit.inventory.ItemStack[] current, org.bukkit.inventory.ItemStack[] original) {
        if (current == null || original == null || current.length != original.length) {
            return false;
        }
        for (int i = 0; i < current.length; ++i) {
            org.bukkit.inventory.ItemStack a = current[i];
            org.bukkit.inventory.ItemStack b = original[i];
            if (this.deepItemEquals(a, b)) continue;
            return false;
        }
        return true;
    }

    private boolean deepItemEquals(org.bukkit.inventory.ItemStack a, org.bukkit.inventory.ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getTypeId() != b.getTypeId()) {
            return false;
        }
        if (a.getAmount() != b.getAmount()) {
            return false;
        }
        return a.getDurability() == b.getDurability();
    }

    private boolean isInventoryMatch(org.bukkit.inventory.ItemStack[] a, org.bukkit.inventory.ItemStack[] b) {
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            org.bukkit.inventory.ItemStack itemA = a[i];
            org.bukkit.inventory.ItemStack itemB = b[i];
            if (Objects.equals(itemA, itemB)) continue;
            return false;
        }
        return true;
    }

    public void startPostFightCooldown(Player player) {
        this.postFightCooldowns.put(player.getUniqueId(), 100);
        this.scheduleCooldownTask(player);
    }

    private void scheduleCooldownTask(Player player) {
        final UUID uuid = player.getUniqueId();
        int taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Integer remaining = (Integer)FightManager.this.postFightCooldowns.get(uuid);
                if (remaining == null) {
                    return;
                }
                if (remaining <= 1) {
                    FightManager.this.postFightCooldowns.remove(uuid);
                } else {
                    FightManager.this.postFightCooldowns.put(uuid, remaining - 1);
                }
            }
        }, 1L, 1L);
    }

    public boolean isInPostFightCooldown(Player player) {
        return this.postFightCooldowns.containsKey(player.getUniqueId());
    }

    private void forceCloseInventory(Player player) {
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        ep.activeContainer = ep.defaultContainer;
        ep.activeContainer.windowId = 0;
        ep.netServerHandler.sendPacket((Packet)new Packet101CloseWindow(0));
    }

    public void cancelFight(Player player) {
        Fight fight = this.activeFights.get(player.getUniqueId());
        if (fight == null) {
            return;
        }
        Player otherPlayer = fight.getOtherPlayer(player);
        this.activeFights.remove(player.getUniqueId());
        this.activeFights.remove(otherPlayer.getUniqueId());
        this.arenaManager.releaseArena(fight.getArena());
        Location playerOriginal = this.originalLocations.remove(player.getUniqueId());
        Location otherOriginal = this.originalLocations.remove(otherPlayer.getUniqueId());
        if (playerOriginal != null) {
            player.teleport(playerOriginal);
            this.healAndFeedPlayer(player);
        }
        if (otherOriginal != null) {
            otherPlayer.teleport(otherOriginal);
            this.healAndFeedPlayer(otherPlayer);
        }
        this.stopAllSpectators();
        String message = ChatColor.RED + "Fight cancelled!";
        player.sendMessage(message);
        otherPlayer.sendMessage(message);
    }

    public boolean isInFight(Player player) {
        return this.activeFights.containsKey(player.getUniqueId());
    }

    public Fight getFight(Player player) {
        return this.activeFights.get(player.getUniqueId());
    }

    private void healAndFeedPlayer(Player player) {
        player.setHealth(20);
    }

    public void cleanup() {
        for (Fight fight : this.activeFights.values()) {
            Player player1 = fight.getPlayer1();
            Player player2 = fight.getPlayer2();
            Location loc1 = this.originalLocations.get(player1.getUniqueId());
            Location loc2 = this.originalLocations.get(player2.getUniqueId());
            if (loc1 != null && player1.isOnline()) {
                player1.teleport(loc1);
            }
            if (loc2 != null && player2.isOnline()) {
                player2.teleport(loc2);
            }
            this.arenaManager.releaseArena(fight.getArena());
        }
        this.activeFights.clear();
        this.originalLocations.clear();
        this.stopAllSpectators();
    }

    public boolean hasPendingChallenge(Player player) {
        UUID uuid = player.getUniqueId();
        for (FightChallenge challenge : this.pendingChallenges.values()) {
            if (!challenge.getChallengerId().equals(uuid) && !challenge.getTargetId().equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public boolean sendChallenge(Player challenger, Player target, double wager) {
        if (this.hasPendingChallenge(challenger) || this.hasPendingChallenge(target)) {
            return false;
        }
        FightChallenge challenge = new FightChallenge(challenger.getUniqueId(), target.getUniqueId(), wager);
        this.pendingChallenges.put(challenger.getUniqueId(), challenge);
        return true;
    }

    public boolean acceptChallenge(Player target) {
        UUID targetId = target.getUniqueId();
        FightChallenge foundChallenge = null;
        for (FightChallenge challenge : this.pendingChallenges.values()) {
            if (!challenge.getTargetId().equals(targetId)) continue;
            foundChallenge = challenge;
            break;
        }
        if (foundChallenge == null) {
            return false;
        }
        UUID challengerId = foundChallenge.getChallengerId();
        double wager = foundChallenge.getWager();
        Player challenger = this.plugin.getServer().getPlayer(challengerId);
        if (challenger == null || !challenger.isOnline()) {
            this.pendingChallenges.values().remove(foundChallenge);
            return false;
        }
        this.pendingChallenges.values().remove(foundChallenge);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (challenger.isOnline() && target.isOnline()) {
                challenger.sendMessage(ChatColor.YELLOW + "Fight starts in 15 seconds...");
                target.sendMessage(ChatColor.YELLOW + "Fight starts in 15 seconds...");
            }
        }, 300L);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (challenger.isOnline() && target.isOnline()) {
                this.startFight(challenger, target, wager);
            }
        }, 600L);
        return true;
    }

    public void cancelChallenge(Player player) {
        UUID uuid = player.getUniqueId();
        this.pendingChallenges.entrySet().removeIf(entry -> ((UUID)entry.getKey()).equals(uuid) || ((FightChallenge)entry.getValue()).getTargetId().equals(uuid));
    }

    public boolean startSpectating(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.spectatorOriginalLocations.containsKey(uuid)) {
            player.sendMessage(ChatColor.RED + "You are already spectating.");
            return false;
        }
        Fight fight = null;
        for (Fight f : this.activeFights.values()) {
            if (f.getPlayer1().getUniqueId().equals(uuid) || f.getPlayer2().getUniqueId().equals(uuid)) continue;
            fight = f;
            break;
        }
        if (fight == null) {
            player.sendMessage(ChatColor.RED + "No ongoing fight to spectate.");
            return false;
        }
        Arena arena = fight.getArena();
        Location specSpawn = arena.getSpectatorSpawn();
        if (specSpawn == null) {
            player.sendMessage(ChatColor.RED + "No spectator spawn set for this arena.");
            return false;
        }
        this.spectatorOriginalLocations.put(uuid, player.getLocation().clone());
        player.teleport(specSpawn);
        player.sendMessage(ChatColor.YELLOW + "You are now spectating the fight between " + fight.getPlayer1().getName() + " and " + fight.getPlayer2().getName() + ".");
        return true;
    }

    public boolean startSpectating(Player player, String arenaName) {
        UUID uuid = player.getUniqueId();
        if (this.spectatorOriginalLocations.containsKey(uuid)) {
            player.sendMessage(ChatColor.RED + "You are already spectating.");
            return false;
        }
        Arena arena = this.arenaManager.getArena(arenaName);
        if (arena == null) {
            player.sendMessage(ChatColor.RED + "Arena '" + arenaName + "' does not exist.");
            return false;
        }
        Location specSpawn = arena.getSpectatorSpawn();
        if (specSpawn == null) {
            player.sendMessage(ChatColor.RED + "Spectator spawn is not set for arena '" + arenaName + "'.");
            return false;
        }
        this.spectatorOriginalLocations.put(uuid, player.getLocation().clone());
        player.teleport(specSpawn);
        player.sendMessage(ChatColor.YELLOW + "You are now spectating arena: " + ChatColor.AQUA + arenaName);
        player.sendMessage(ChatColor.YELLOW + "Use /spectate to return to your original location.");
        return true;
    }

    public boolean stopSpectating(Player player) {
        UUID uuid = player.getUniqueId();
        Location original = this.spectatorOriginalLocations.remove(uuid);
        if (original != null) {
            player.teleport(original);
            player.sendMessage(ChatColor.YELLOW + "Returned from spectating.");
            return true;
        }
        player.sendMessage(ChatColor.RED + "You are not spectating.");
        return false;
    }

    public void stopAllSpectators() {
        for (UUID uuid : new HashMap<UUID, Location>(this.spectatorOriginalLocations).keySet()) {
            Player player = this.plugin.getServer().getPlayer(uuid);
            if (player == null || !player.isOnline()) continue;
            this.stopSpectating(player);
        }
    }

    public boolean isSpectating(Player player) {
        return this.spectatorOriginalLocations.containsKey(player.getUniqueId());
    }

    public static int getInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void loadStats() {
        this.stats = new HashMap<String, Object>();
        if (!this.statsFile.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(this.statsFile);){
            Yaml yaml = new Yaml();
            Object data = yaml.load((InputStream)fis);
            if (data instanceof Map) {
                this.stats = (Map)data;
            }
        }
        catch (Exception e) {
            this.plugin.getServer().getLogger().warning("Failed to load stats.yml: " + e.getMessage());
        }
    }

    private void saveStats() {
        try (FileWriter writer = new FileWriter(this.statsFile);){
            Yaml yaml = new Yaml();
            yaml.dump(this.stats, (Writer)writer);
        }
        catch (Exception e) {
            this.plugin.getServer().getLogger().warning("Failed to save stats.yml: " + e.getMessage());
        }
    }

    public void incrementStat(UUID uuid, String key, String username) {
        String uuidKey = uuid.toString();
        HashMap<String, String> playerStats = (HashMap<String, String>)this.stats.get(uuidKey);
        if (playerStats == null) {
            playerStats = new HashMap<String, String>();
            this.stats.put(uuidKey, playerStats);
        }
        playerStats.put("username", username);
        PlayerDataManager.setPlayer(uuid, username);
        int current = 0;
        Object val = playerStats.get(key);
        if (val instanceof Number) {
            current = ((Number)val).intValue();
        }
        playerStats.put(key, (String)((Object)Integer.valueOf(current + 1)));
        this.saveStats();
    }

    public Map<String, Integer> getTopPlayersByWins() {
        HashMap<String, Integer> winsMap = new HashMap<String, Integer>();
        for (Map.Entry<String, Object> entry : this.stats.entrySet()) {
            String uuidStr = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Map)) continue;
            Map playerStats = (Map)value;
            Object winsObj = playerStats.get("wins");
            String storedName = (String)playerStats.get("username");
            if (!(winsObj instanceof Number) || storedName == null) continue;
            winsMap.put(storedName, ((Number)winsObj).intValue());
        }
        return winsMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public List<String> getPlayerStats(UUID uuid) {
        Object raw = this.stats.get(uuid.toString());
        if (!(raw instanceof Map)) {
            return Collections.singletonList(ChatColor.RED + "No stats found for " + uuid + ".");
        }
        Map playerStats = (Map)raw;
        int wins = FightManager.getInt(playerStats.get("wins"));
        int losses = FightManager.getInt(playerStats.get("losses"));
        String displayName = PlayerDataManager.getUsername(uuid);
        if (displayName == null) {
            displayName = uuid.toString();
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(ChatColor.GOLD + "=== Stats for " + ChatColor.AQUA + displayName + ChatColor.GOLD + " ===");
        lines.add(ChatColor.YELLOW + "Wins: " + ChatColor.GREEN + wins);
        lines.add(ChatColor.YELLOW + "Losses: " + ChatColor.RED + losses);
        return lines;
    }

    public List<String> getPlayerStatsByName(String name) {
        UUID uuid = null;
        for (String key : this.stats.keySet()) {
            Map entry;
            String storedName;
            Object raw = this.stats.get(key);
            if (!(raw instanceof Map) || (storedName = (String)(entry = (Map)raw).get("username")) == null || !storedName.equalsIgnoreCase(name)) continue;
            try {
                uuid = UUID.fromString(key);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        if (uuid == null) {
            return Collections.singletonList(ChatColor.RED + "No stats found for " + name + ".");
        }
        Object raw = this.stats.get(uuid.toString());
        if (!(raw instanceof Map)) {
            return Collections.singletonList(ChatColor.RED + "No stats found for " + name + ".");
        }
        Map playerStats = (Map)raw;
        int wins = FightManager.getInt(playerStats.get("wins"));
        int losses = FightManager.getInt(playerStats.get("losses"));
        String displayName = (String)playerStats.get("username");
        if (displayName == null) {
            displayName = uuid.toString().substring(0, 8);
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(ChatColor.GOLD + "=== Stats for " + ChatColor.AQUA + displayName + ChatColor.GOLD + " ===");
        lines.add(ChatColor.YELLOW + "Wins: " + ChatColor.GREEN + wins);
        lines.add(ChatColor.YELLOW + "Losses: " + ChatColor.RED + losses);
        return lines;
    }

    private static class FightChallenge {
        private final UUID challengerId;
        private final UUID targetId;
        private final double wager;

        public FightChallenge(UUID challengerId, UUID targetId, double wager) {
            this.challengerId = challengerId;
            this.targetId = targetId;
            this.wager = wager;
        }

        public UUID getChallengerId() {
            return this.challengerId;
        }

        public UUID getTargetId() {
            return this.targetId;
        }

        public double getWager() {
            return this.wager;
        }
    }
}

