/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Arena;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.garsooon.arenafighter.Arena.ArenaManager;
import org.garsooon.arenafighter.Commands.ArenaCommand;
import org.garsooon.arenafighter.Commands.FightAboutCommand;
import org.garsooon.arenafighter.Commands.FightCommand;
import org.garsooon.arenafighter.Commands.SpectateBetCommand;
import org.garsooon.arenafighter.Commands.SpectateCommand;
import org.garsooon.arenafighter.Economy.Method;
import org.garsooon.arenafighter.Economy.Methods;
import org.garsooon.arenafighter.Fight.FightManager;
import org.garsooon.arenafighter.Listeners.PlayerCommandListener;
import org.garsooon.arenafighter.Listeners.PlayerDeathListener;
import org.garsooon.arenafighter.Listeners.PlayerDropListener;
import org.garsooon.arenafighter.Listeners.PlayerQuitListener;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ArenaFighter
extends JavaPlugin {
    private ArenaManager arenaManager;
    private FightManager fightManager;
    private Method economy;
    private Set<String> blockedCommands = new HashSet<String>();
    private boolean arenaEnabled = true;
    private Map<String, Object> configData;

    public void onEnable() {
        this.createDefaultConfig();
        this.loadArenaEnabledFlag();
        this.arenaManager = new ArenaManager(this);
        boolean economyLoaded = Methods.setMethod(this.getServer().getPluginManager());
        if (!economyLoaded) {
            Bukkit.getLogger().warning("[ArenaFighter Eco] No economy plugin loaded, Wagers Disabled!");
            this.economy = null;
        } else {
            this.economy = Methods.getMethod();
            Bukkit.getLogger().info("[ArenaFighter Eco] Method loaded: " + this.economy.getName() + " v" + this.economy.getVersion());
        }
        this.fightManager = new FightManager(this, this.arenaManager, this.economy);
        FightCommand fightCommand = new FightCommand((Plugin)this, this.fightManager);
        this.getCommand("fight").setExecutor((CommandExecutor)fightCommand);
        this.getCommand("arena").setExecutor((CommandExecutor)new ArenaCommand(this.arenaManager, this));
        this.getCommand("spectate").setExecutor((CommandExecutor)new SpectateCommand(this.fightManager));
        this.getCommand("bet").setExecutor((CommandExecutor)new SpectateBetCommand(this.fightManager));
        this.getCommand("fightabout").setExecutor((CommandExecutor)new FightAboutCommand(this));
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerDeathListener(this.fightManager), (Plugin)this);
        pm.registerEvents((Listener)new PlayerQuitListener(this.fightManager, fightCommand), (Plugin)this);
        pm.registerEvents((Listener)new PlayerDropListener(this.fightManager), (Plugin)this);
        pm.registerEvents((Listener)new PlayerCommandListener(this, this.fightManager), (Plugin)this);
        this.loadBlockedCommands();
        this.arenaManager.loadArenas();
        Bukkit.getLogger().info("[ArenaFighter] ArenaFighter plugin has been enabled!");
    }

    public void onDisable() {
        if (this.fightManager != null) {
            this.fightManager.cleanup();
        }
        Bukkit.getLogger().info("[ArenaFighter] ArenaFighter plugin has been disabled!");
    }

    public ArenaManager getArenaManager() {
        return this.arenaManager;
    }

    public FightManager getFightManager() {
        return this.fightManager;
    }

    public Set<String> getBlockedCommands() {
        return this.blockedCommands;
    }

    public boolean isArenaEnabled() {
        return this.arenaEnabled;
    }

    public void setArenaEnabled(boolean enabled) {
        Map<String, Boolean> arenaSection;
        this.arenaEnabled = enabled;
        if (this.configData == null) {
            this.configData = new LinkedHashMap<String, Object>();
        }
        if (this.configData.containsKey("arena") && this.configData.get("arena") instanceof Map) {
            arenaSection = (Map)this.configData.get("arena");
        } else {
            arenaSection = new LinkedHashMap<String, Boolean>();
            this.configData.put("arena", arenaSection);
        }
        arenaSection.put("enabled", enabled);
        this.saveConfigFile();
    }

    private void loadArenaEnabledFlag() {
        Map<String, Boolean> arenaSection;
        File configFile = new File(this.getDataFolder(), "config.yml");
        Yaml yaml = new Yaml();
        this.configData = null;
        try (FileInputStream input = new FileInputStream(configFile);){
            this.configData = (Map)yaml.load((InputStream)input);
        }
        catch (Exception e) {
            this.configData = new LinkedHashMap<String, Object>();
        }
        if (this.configData == null) {
            this.configData = new LinkedHashMap<String, Object>();
        }
        boolean needSave = false;
        if (this.configData.containsKey("arena") && this.configData.get("arena") instanceof Map) {
            arenaSection = (Map)this.configData.get("arena");
        } else {
            arenaSection = new LinkedHashMap();
            this.configData.put("arena", arenaSection);
            needSave = true;
        }
        if (!arenaSection.containsKey("enabled")) {
            arenaSection.put("enabled", true);
            this.arenaEnabled = true;
            needSave = true;
        } else {
            Object value = arenaSection.get("enabled");
            boolean bl = this.arenaEnabled = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(String.valueOf(value));
        }
        if (needSave) {
            this.saveConfigFile();
        }
    }

    private void saveConfigFile() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        try (FileWriter writer = new FileWriter(configFile);){
            yaml.dump(this.configData, (Writer)writer);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("Failed to save config.yml: " + e.getMessage());
        }
    }

    private void createDefaultConfig() {
        File configFile;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!(configFile = new File(this.getDataFolder(), "config.yml")).exists()) {
            try {
                configFile.createNewFile();
                FileWriter writer = new FileWriter(configFile);
                writer.write("# ArenaFighter Configuration\n");
                writer.write("# To configure your arenas, run /arena create <arena_name>\n");
                writer.write("# then you can modify it in arenas.properties in this folder\n");
                writer.write("\n");
                writer.write("# Arena system enabled/disabled\n");
                writer.write("arena:\n");
                writer.write("  enabled: true\n");
                writer.write("\n");
                writer.write("punishment:\n");
                writer.write("  duration-minute: 5\n");
                writer.write("\n");
                writer.write("# Command blocking for players during a fight\n");
                writer.write("blocked-commands:\n");
                writer.write("  - \"/spectate\"\n");
                writer.write("  - \"/spawn\"\n");
                writer.write("  - \"/home\"\n");
                writer.write("  - \"/homes\"\n");
                writer.write("  - \"/sethome\"\n");
                writer.write("  - \"/warp\"\n");
                writer.write("  - \"/tp\"\n");
                writer.write("  - \"/tpa\"\n");
                writer.write("  - \"/tpaccept\"\n");
                writer.write("  - \"/tphere\"\n");
                writer.write("  - \"/heal\"\n");
                writer.close();
                Bukkit.getLogger().info("Created default config.yml");
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("Could not create default config: " + e.getMessage());
            }
        }
        Bukkit.getLogger().info("Configuration file ready for loading");
    }

    private void loadBlockedCommands() {
        try {
            File configFile = new File(this.getDataFolder(), "config.yml");
            if (!configFile.exists()) {
                Bukkit.getLogger().warning("Config file does not exist!");
                return;
            }
            Yaml yaml = new Yaml();
            try (FileInputStream input = new FileInputStream(configFile);){
                Object loaded = yaml.load((InputStream)input);
                if (!(loaded instanceof Map)) {
                    Bukkit.getLogger().warning("Invalid config.yml format");
                    return;
                }
                Map map = (Map)loaded;
                Object blocked = map.get("blocked-commands");
                if (blocked instanceof List) {
                    for (Object cmd : (List)blocked) {
                        if (!(cmd instanceof String)) continue;
                        this.blockedCommands.add(((String)cmd).toLowerCase());
                    }
                } else {
                    Bukkit.getLogger().warning("blocked-commands missing or invalid");
                }
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("Failed to load config.yml: " + e.getMessage());
        }
    }
}

