/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Commands;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.garsooon.arenafighter.Arena.Arena;
import org.garsooon.arenafighter.Arena.ArenaFighter;
import org.garsooon.arenafighter.Arena.ArenaManager;

public class ArenaCommand
implements CommandExecutor {
    private final ArenaManager arenaManager;
    private final ArenaFighter plugin;

    public ArenaCommand(ArenaManager arenaManager, ArenaFighter plugin) {
        this.arenaManager = arenaManager;
        this.plugin = plugin;
    }

    public ArenaCommand(ArenaManager arenaManager) {
        this(arenaManager, null);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelpMessage(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "enable": {
                return this.handleEnable(player);
            }
            case "disable": {
                return this.handleDisable(player);
            }
            case "create": {
                return this.handleCreate(player, args);
            }
            case "remove": {
                return this.handleRemove(player, args);
            }
            case "list": {
                return this.handleList(player);
            }
            case "setspawn": {
                return this.handleSetSpawn(player, args);
            }
            case "tp": {
                return this.handleTeleport(player, args);
            }
            case "help": {
                this.sendHelpMessage(player);
                return true;
            }
        }
        this.sendHelpMessage(player);
        return true;
    }

    private boolean handleEnable(Player player) {
        if (!player.hasPermission("arenafighter.admin")) {
            player.sendMessage(ChatColor.RED + "You don't have permission to enable ArenaFighter!");
            return true;
        }
        if (this.plugin != null) {
            this.plugin.setArenaEnabled(true);
            player.sendMessage(ChatColor.GREEN + "Arena Fighter enabled!");
        }
        return true;
    }

    private boolean handleDisable(Player player) {
        if (!player.hasPermission("arenafighter.admin")) {
            player.sendMessage(ChatColor.RED + "You don't have permission to disable ArenaFighter!");
            return true;
        }
        if (this.plugin != null) {
            this.plugin.setArenaEnabled(false);
            player.sendMessage(ChatColor.RED + "Arena Fighter disabled!");
        }
        return true;
    }

    private boolean handleCreate(Player player, String[] args) {
        if (!player.hasPermission("arenafighter.admin")) {
            player.sendMessage(ChatColor.RED + "You don't have permission to create arenas!");
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(ChatColor.RED + "Usage: /arena create <name>");
            return true;
        }
        String arenaName = args[1];
        Location currentLoc = player.getLocation();
        Location spawn1 = currentLoc.clone();
        Location spawn2 = currentLoc.clone().add(10.0, 0.0, 0.0);
        Location spectatorSpawn = currentLoc.clone().add(5.0, 0.0, 0.0);
        this.arenaManager.createArena(arenaName, spawn1, spawn2, spectatorSpawn);
        player.sendMessage(ChatColor.GREEN + "Arena '" + arenaName + "' created successfully!");
        player.sendMessage(ChatColor.YELLOW + "Spawn 1: " + this.locationToString(spawn1));
        player.sendMessage(ChatColor.YELLOW + "Spawn 2: " + this.locationToString(spawn2));
        player.sendMessage(ChatColor.YELLOW + "Spectator Spawn: " + this.locationToString(spectatorSpawn));
        player.sendMessage(ChatColor.GRAY + "Note: Spawn 2 was automatically set 10 blocks east of Spawn 1.");
        player.sendMessage(ChatColor.GRAY + "Spectator spawn set 5 blocks east of Spawn 1.");
        player.sendMessage(ChatColor.GRAY + "You can manually edit the config file to adjust spawn locations.");
        return true;
    }

    private boolean handleRemove(Player player, String[] args) {
        if (!player.hasPermission("arenafighter.admin")) {
            player.sendMessage(ChatColor.RED + "You don't have permission to remove arenas!");
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(ChatColor.RED + "Usage: /arena remove <name>");
            return true;
        }
        String arenaName = args[1];
        Arena arena = this.arenaManager.getArena(arenaName);
        if (arena == null) {
            player.sendMessage(ChatColor.RED + "Arena '" + arenaName + "' does not exist!");
            return true;
        }
        if (arena.isOccupied()) {
            player.sendMessage(ChatColor.RED + "Cannot remove arena '" + arenaName + "' - it's currently in use!");
            return true;
        }
        this.arenaManager.removeArena(arenaName);
        player.sendMessage(ChatColor.GREEN + "Arena '" + arenaName + "' removed successfully!");
        return true;
    }

    private boolean handleList(Player player) {
        List<String> arenaNames = this.arenaManager.getArenaNames();
        if (arenaNames.isEmpty()) {
            player.sendMessage(ChatColor.YELLOW + "No arenas configured.");
            return true;
        }
        player.sendMessage(ChatColor.GOLD + "=== Available Arenas ===");
        for (String name : arenaNames) {
            Arena arena = this.arenaManager.getArena(name);
            String status = arena.isOccupied() ? ChatColor.RED + "[OCCUPIED]" : ChatColor.GREEN + "[AVAILABLE]";
            player.sendMessage(ChatColor.YELLOW + "- " + ChatColor.WHITE + name + " " + status);
        }
        return true;
    }

    private boolean handleSetSpawn(Player player, String[] args) {
        if (!player.hasPermission("arenafighter.admin")) {
            player.sendMessage(ChatColor.RED + "You don't have permission to set spawns!");
            return true;
        }
        if (args.length < 3) {
            player.sendMessage(ChatColor.RED + "Usage: /arena setspawn <name> <spawn1|spawn2|spectator>");
            return true;
        }
        String arenaName = args[1];
        String spawnType = args[2].toLowerCase();
        Arena arena = this.arenaManager.getArena(arenaName);
        if (arena == null) {
            player.sendMessage(ChatColor.RED + "Arena '" + arenaName + "' does not exist!");
            return true;
        }
        Location loc = player.getLocation();
        switch (spawnType) {
            case "spawn1": {
                arena.setSpawn1(loc);
                player.sendMessage(ChatColor.GREEN + "Set spawn1 for arena '" + arenaName + "' to your current location.");
                break;
            }
            case "spawn2": {
                arena.setSpawn2(loc);
                player.sendMessage(ChatColor.GREEN + "Set spawn2 for arena '" + arenaName + "' to your current location.");
                break;
            }
            case "spectator": {
                arena.setSpectatorSpawn(loc);
                player.sendMessage(ChatColor.GREEN + "Set spectator spawn for arena '" + arenaName + "' to your current location.");
                break;
            }
            default: {
                player.sendMessage(ChatColor.RED + "Invalid spawn. Use spawn1, spawn2, or spectator.");
                return true;
            }
        }
        this.arenaManager.saveArenaToConfig(arena.getName(), arena.getSpawn1(), arena.getSpawn2(), arena.getSpectatorSpawn());
        return true;
    }

    private boolean handleTeleport(Player player, String[] args) {
        Location teleportLocation;
        if (!player.hasPermission("arenafighter.admin")) {
            player.sendMessage(ChatColor.RED + "You don't have permission to teleport to arenas!");
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(ChatColor.RED + "Usage: /arena tp <name> [spawn1|spawn2]");
            return true;
        }
        String arenaName = args[1];
        Arena arena = this.arenaManager.getArena(arenaName);
        if (arena == null) {
            player.sendMessage(ChatColor.RED + "Arena '" + arenaName + "' does not exist!");
            return true;
        }
        if (args.length >= 3 && args[2].equalsIgnoreCase("spawn2")) {
            teleportLocation = arena.getSpawn2();
            player.sendMessage(ChatColor.GREEN + "Teleported to " + arenaName + " spawn 2!");
        } else {
            teleportLocation = arena.getSpawn1();
            player.sendMessage(ChatColor.GREEN + "Teleported to " + arenaName + " spawn 1!");
        }
        player.teleport(teleportLocation);
        return true;
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage(ChatColor.GOLD + "=== Arena Fighter Commands ===");
        player.sendMessage(ChatColor.YELLOW + "/arena enable" + ChatColor.WHITE + " - Enable Arena Fighter");
        player.sendMessage(ChatColor.YELLOW + "/arena disable" + ChatColor.WHITE + " - Disable Arena Fighter");
        player.sendMessage(ChatColor.YELLOW + "/arena create <name>" + ChatColor.WHITE + " - Create a new arena");
        player.sendMessage(ChatColor.YELLOW + "/arena remove <name>" + ChatColor.WHITE + " - Remove an arena");
        player.sendMessage(ChatColor.YELLOW + "/arena list" + ChatColor.WHITE + " - List all arenas");
        player.sendMessage(ChatColor.YELLOW + "/arena setspawn <name> <spawn1|spawn2|spectator>");
        player.sendMessage(ChatColor.WHITE + " - Set spawn point");
        player.sendMessage(ChatColor.YELLOW + "/arena tp <name> [spawn1|spawn2]" + ChatColor.WHITE + " - Teleport to an arena");
        player.sendMessage(ChatColor.YELLOW + "/arena help" + ChatColor.WHITE + " - Show this help message");
    }

    private String locationToString(Location location) {
        return String.format("World: %s, X: %.1f, Y: %.1f, Z: %.1f", location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }
}

