/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Commands;

import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.garsooon.arenafighter.Data.Bet;
import org.garsooon.arenafighter.Economy.Method;
import org.garsooon.arenafighter.Economy.Methods;
import org.garsooon.arenafighter.Fight.Fight;
import org.garsooon.arenafighter.Fight.FightManager;

public class SpectateBetCommand
implements CommandExecutor {
    private final FightManager fightManager;
    private final Method economy;

    public SpectateBetCommand(FightManager fightManager) {
        this.fightManager = fightManager;
        this.economy = Methods.getMethod();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double amount;
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (this.economy == null) {
            player.sendMessage(ChatColor.RED + "Economy plugin not detected. Betting is disabled.");
            return true;
        }
        if (args.length != 2) {
            player.sendMessage(ChatColor.RED + "Usage: /bet <fighter> <amount>");
            return true;
        }
        String fighterName = args[0];
        try {
            String[] split = args[1].split("\\.");
            if (split.length == 2 && split[1].length() > 2) {
                player.sendMessage(ChatColor.RED + "Bets can only have up to two decimals.");
                return true;
            }
            amount = Double.parseDouble(args[1]);
            if ((amount = Bet.roundDownTwoDecimals(amount)) <= 0.0) {
                player.sendMessage(ChatColor.RED + "Bet amount must be greater than 0.");
                return true;
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage(ChatColor.RED + "Invalid amount.");
            return true;
        }
        Fight fight = null;
        for (Fight f : this.fightManager.getActiveFights()) {
            if (!f.isFighter(fighterName)) continue;
            fight = f;
            break;
        }
        if (fight == null) {
            player.sendMessage(ChatColor.RED + "There is no active fight with that fighter.");
            return true;
        }
        if (fight.hasStarted()) {
            player.sendMessage(ChatColor.RED + "You cannot bet, the fight has already started.");
            return true;
        }
        if (!this.economy.hasEnough(player.getName(), amount, player.getWorld())) {
            player.sendMessage(ChatColor.RED + "You don't have enough money to bet that amount.");
            return true;
        }
        if (fight.containsPlayer(player)) {
            player.sendMessage(ChatColor.RED + "You cannot bet on a fight you are participating in.");
            return true;
        }
        if (!fight.placeBet(player.getName(), fighterName, amount)) {
            player.sendMessage(ChatColor.RED + "You have already placed a bet.");
            return true;
        }
        if (!this.economy.withdrawPlayer(player.getName(), amount, player.getWorld())) {
            player.sendMessage(ChatColor.RED + "Failed to withdraw funds.");
            return true;
        }
        String msg = ChatColor.AQUA + player.getName() + ChatColor.YELLOW + " placed a bet of " + ChatColor.GOLD + amount + ChatColor.YELLOW + " on " + ChatColor.GREEN + fighterName + ChatColor.YELLOW + "!";
        player.getServer().broadcastMessage(msg);
        return true;
    }
}

