/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Economy.methods;

import com.earth2me.essentials.api.Economy;
import com.johnymuffin.beta.fundamentals.api.EconomyAPI;
import com.johnymuffin.beta.fundamentals.api.FundamentalsAPI;
import com.johnymuffin.beta.fundamentals.util.Utils;
import com.projectposeidon.api.PoseidonUUID;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.garsooon.arenafighter.Economy.Method;

public class Fundamentals
implements Method {
    private Fundamentals fundamentals;

    @Override
    public Fundamentals getPlugin() {
        return this.fundamentals;
    }

    @Override
    public String getName() {
        return "Fundamentals";
    }

    @Override
    public String getVersion() {
        return "1.0.6";
    }

    @Override
    public int fractionalDigits() {
        return -1;
    }

    @Override
    public String format(double amount) {
        return amount + " Currency";
    }

    @Override
    public boolean hasBanks() {
        return false;
    }

    @Override
    public boolean hasBank(String bank, World world) {
        return false;
    }

    @Override
    public boolean hasAccount(String name, World world) {
        return Economy.playerExists((String)name);
    }

    @Override
    public boolean hasBankAccount(String bank, String name, World world) {
        return false;
    }

    @Override
    public Method.MethodAccount getAccount(String name, World world) {
        if (!this.hasAccount(name, world)) {
            return null;
        }
        return new EEcoAccount(name);
    }

    @Override
    public Method.MethodBankAccount getBankAccount(String bank, String name, World world) {
        return null;
    }

    @Override
    public boolean isCompatible(Plugin plugin) {
        try {
            Class.forName("com.johnymuffin.beta.fundamentals.api.EconomyAPI");
        }
        catch (Exception e) {
            return false;
        }
        return plugin.getDescription().getName().equalsIgnoreCase("fundamentals") && plugin instanceof Fundamentals;
    }

    @Override
    public void setPlugin(Plugin plugin) {
        this.fundamentals = (Fundamentals)plugin;
    }

    public static class EEcoAccount
    implements Method.MethodAccount {
        private String name;
        private UUID uuid;

        public EEcoAccount(String name) {
            this.name = name;
            this.uuid = Utils.getUUIDFromUsername((String)this.name);
            if (this.uuid == null) {
                this.uuid = PoseidonUUID.getPlayerGracefulUUID((String)this.name);
            }
        }

        @Override
        public double balance(World world) {
            Double balance = 0.0;
            try {
                EconomyAPI.BalanceWrapper balanceWrapper = FundamentalsAPI.getEconomy().getBalance(this.uuid, world.getName());
                if (balanceWrapper.getEconomyResult() == EconomyAPI.EconomyResult.successful) {
                    balance = balanceWrapper.getBalance();
                } else {
                    System.out.println("[REGISTER] Failed to grab balance from Fundamentals for " + this.uuid + ": " + balanceWrapper.getEconomyResult().toString());
                }
            }
            catch (Exception ex) {
                System.out.println("[REGISTER] Exception occurred with Fundamentals Economy: " + ex.getMessage());
            }
            return balance;
        }

        @Override
        public boolean set(double amount, World world) {
            try {
                EconomyAPI.EconomyResult balanceWrapper = FundamentalsAPI.getEconomy().setBalance(this.uuid, amount, world.getName());
                if (balanceWrapper == EconomyAPI.EconomyResult.successful) {
                    return true;
                }
                System.out.println("[REGISTER] Failed to set balance from Fundamentals for " + this.uuid + ": " + balanceWrapper.toString());
                return false;
            }
            catch (Exception ex) {
                System.out.println("[REGISTER] Exception occurred with Fundamentals Economy: " + ex.getMessage());
                return false;
            }
        }

        @Override
        public boolean add(double amount, World world) {
            return this.set(this.balance(world) + amount, world);
        }

        @Override
        public boolean subtract(double amount, World world) {
            return this.set(this.balance(world) - amount, world);
        }

        @Override
        public boolean multiply(double amount, World world) {
            return this.set(this.balance(world) * amount, world);
        }

        @Override
        public boolean divide(double amount, World world) {
            return this.set(this.balance(world) / amount, world);
        }

        @Override
        public boolean hasEnough(double amount, World world) {
            return amount <= this.balance(world);
        }

        @Override
        public boolean hasOver(double amount, World world) {
            return amount <= this.balance(world);
        }

        @Override
        public boolean hasUnder(double amount, World world) {
            return amount > this.balance(world);
        }

        @Override
        public boolean isNegative(World world) {
            return false;
        }

        @Override
        public boolean remove() {
            return false;
        }
    }
}

