/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Listeners;

import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.garsooon.arenafighter.Commands.FightCommand;
import org.garsooon.arenafighter.Fight.Fight;
import org.garsooon.arenafighter.Fight.FightManager;

public class PlayerQuitListener
implements Listener {
    private final FightManager fightManager;
    private final FightCommand fightCommand;

    public PlayerQuitListener(FightManager fightManager, FightCommand fightCommand) {
        this.fightManager = fightManager;
        this.fightCommand = fightCommand;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player quitter = event.getPlayer();
        if (this.fightManager.isInFight(quitter)) {
            Fight fight = this.fightManager.getFight(quitter);
            if (fight != null) {
                Player winner = fight.getOtherPlayer(quitter);
                double wager = fight.getWager();
                if (winner != null && winner.isOnline()) {
                    this.fightManager.getPlugin().getServer().broadcastMessage(ChatColor.GOLD + winner.getName() + ChatColor.YELLOW + " wins! " + ChatColor.RED + quitter.getName() + ChatColor.YELLOW + " chickened out and left.");
                    this.fightManager.deposit(winner, wager * 2.0);
                }
            }
            this.fightManager.cancelFight(quitter);
            this.fightManager.punishQuitter(quitter);
        }
        this.fightCommand.cancelChallengesInvolving(quitter.getName());
    }
}

