/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Arena;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.garsooon.arenafighter.Arena.ArenaManager;
import org.garsooon.arenafighter.Commands.ArenaCommand;
import org.garsooon.arenafighter.Commands.FightAboutCommand;
import org.garsooon.arenafighter.Commands.FightCommand;
import org.garsooon.arenafighter.Commands.SpectateBetCommand;
import org.garsooon.arenafighter.Commands.SpectateCommand;
import org.garsooon.arenafighter.Economy.Method;
import org.garsooon.arenafighter.Economy.Methods;
import org.garsooon.arenafighter.Fight.FightManager;
import org.garsooon.arenafighter.Listeners.PlayerDeathListener;
import org.garsooon.arenafighter.Listeners.PlayerDropListener;
import org.garsooon.arenafighter.Listeners.PlayerQuitListener;

public class ArenaFighter
extends JavaPlugin {
    private ArenaManager arenaManager;
    private FightManager fightManager;
    private Method economy;

    public void onEnable() {
        this.arenaManager = new ArenaManager(this);
        boolean economyLoaded = Methods.setMethod(this.getServer().getPluginManager());
        if (!economyLoaded) {
            Bukkit.getLogger().warning("[ArenaFighter Eco] No economy plugin loaded, Wagers Disabled!");
            this.economy = null;
        } else {
            this.economy = Methods.getMethod();
            Bukkit.getLogger().info("[ArenaFighter Eco] Method loaded: " + this.economy.getName() + " v" + this.economy.getVersion());
        }
        this.fightManager = new FightManager(this, this.arenaManager, this.economy);
        FightCommand fightCommand = new FightCommand((Plugin)this, this.fightManager);
        this.getCommand("fight").setExecutor((CommandExecutor)fightCommand);
        this.getCommand("arena").setExecutor((CommandExecutor)new ArenaCommand(this.arenaManager));
        this.getCommand("spectate").setExecutor((CommandExecutor)new SpectateCommand(this.fightManager));
        this.getCommand("bet").setExecutor((CommandExecutor)new SpectateBetCommand(this.fightManager));
        this.getCommand("fightabout").setExecutor((CommandExecutor)new FightAboutCommand(this));
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerDeathListener(this.fightManager), (Plugin)this);
        pm.registerEvents((Listener)new PlayerQuitListener(this.fightManager, fightCommand), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDropListener(this.fightManager), (Plugin)this);
        this.createDefaultConfig();
        this.arenaManager.loadArenas();
        Bukkit.getLogger().info("[ArenaFighter] ArenaFighter plugin has been enabled!");
    }

    public void onDisable() {
        if (this.fightManager != null) {
            this.fightManager.cleanup();
        }
        Bukkit.getLogger().info("[ArenaFighter] ArenaFighter plugin has been disabled!");
    }

    public ArenaManager getArenaManager() {
        return this.arenaManager;
    }

    public FightManager getFightManager() {
        return this.fightManager;
    }

    private void createDefaultConfig() {
        File configFile;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!(configFile = new File(this.getDataFolder(), "config.yml")).exists()) {
            try {
                configFile.createNewFile();
                FileWriter writer = new FileWriter(configFile);
                writer.write("# ArenaFighter Configuration\n");
                writer.write("# To configure your arenas, run /arena create <arena_name>\n");
                writer.write("# then you can modify it in arenas.properties in this folder\n");
                writer.write("      punishment:\n");
                writer.write("        duration-minute: 5\n");
                writer.close();
                Bukkit.getLogger().info("Created default config.yml");
            }
            catch (IOException e) {
                Bukkit.getLogger().warning("Could not create default config: " + e.getMessage());
            }
        }
        Bukkit.getLogger().info("Configuration file ready for loading");
    }
}

