/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Economy;

import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public interface Method {
    public Object getPlugin();

    public String getName();

    public String getVersion();

    public int fractionalDigits();

    public String format(double var1);

    public boolean hasBanks();

    public boolean hasBank(String var1, World var2);

    public boolean hasAccount(String var1, World var2);

    public boolean hasBankAccount(String var1, String var2, World var3);

    public MethodAccount getAccount(String var1, World var2);

    public MethodBankAccount getBankAccount(String var1, String var2, World var3);

    public boolean isCompatible(Plugin var1);

    public void setPlugin(Plugin var1);

    default public double getBalance(String name, World world) {
        MethodAccount acc = this.getAccount(name, world);
        return acc != null ? acc.balance(world) : 0.0;
    }

    default public boolean hasEnough(String name, double amount, World world) {
        MethodAccount acc = this.getAccount(name, world);
        return acc != null && acc.hasEnough(amount, world);
    }

    default public boolean withdrawPlayer(String name, double amount, World world) {
        MethodAccount acc = this.getAccount(name, world);
        return acc != null && acc.subtract(amount, world);
    }

    default public boolean depositPlayer(String name, double amount, World world) {
        MethodAccount acc = this.getAccount(name, world);
        return acc != null && acc.add(amount, world);
    }

    public static interface MethodBankAccount {
        public double balance();

        public String getBankName();

        public int getBankId();

        public boolean set(double var1);

        public boolean add(double var1);

        public boolean subtract(double var1);

        public boolean multiply(double var1);

        public boolean divide(double var1);

        public boolean hasEnough(double var1);

        public boolean hasOver(double var1);

        public boolean hasUnder(double var1);

        public boolean isNegative();

        public boolean remove();

        public String toString();
    }

    public static interface MethodAccount {
        public double balance(World var1);

        public boolean set(double var1, World var3);

        public boolean add(double var1, World var3);

        public boolean subtract(double var1, World var3);

        public boolean multiply(double var1, World var3);

        public boolean divide(double var1, World var3);

        public boolean hasEnough(double var1, World var3);

        public boolean hasOver(double var1, World var3);

        public boolean hasUnder(double var1, World var3);

        public boolean isNegative(World var1);

        public boolean remove();

        public String toString();
    }
}

