/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.arenafighter.Fight;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.garsooon.arenafighter.Arena.Arena;
import org.garsooon.arenafighter.Arena.ArenaFighter;
import org.garsooon.arenafighter.Arena.ArenaManager;
import org.garsooon.arenafighter.Economy.Method;
import org.garsooon.arenafighter.Fight.Fight;
import org.yaml.snakeyaml.Yaml;

public class FightManager {
    private final ArenaFighter plugin;
    private final ArenaManager arenaManager;
    private final Map<UUID, Fight> activeFights;
    private final Map<UUID, Location> originalLocations;
    private final Map<UUID, ItemStack[]> originalInventories = new HashMap<UUID, ItemStack[]>();
    private final Map<UUID, ItemStack[]> originalArmor = new HashMap<UUID, ItemStack[]>();
    private final Map<UUID, FightChallenge> pendingChallenges;
    private final Map<UUID, Location> spectatorOriginalLocations;
    private final Map<UUID, Long> punishments = new HashMap<UUID, Long>();
    private final long punishmentDurationMillis;
    private final Method economy;

    public FightManager(ArenaFighter plugin, ArenaManager arenaManager, Method economy) {
        this.plugin = plugin;
        this.arenaManager = arenaManager;
        this.economy = economy;
        this.activeFights = new HashMap<UUID, Fight>();
        this.originalLocations = new HashMap<UUID, Location>();
        this.pendingChallenges = new HashMap<UUID, FightChallenge>();
        this.spectatorOriginalLocations = new HashMap<UUID, Location>();
        this.punishmentDurationMillis = this.loadPunishmentDuration(plugin.getDataFolder());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long loadPunishmentDuration(File dataFolder) {
        File configFile = new File(dataFolder, "config.yml");
        long defaultMinutes = 5L;
        if (!configFile.exists()) {
            return defaultMinutes * 60L * 1000L;
        }
        try (FileInputStream input = new FileInputStream(configFile);){
            Yaml yaml = new Yaml();
            Object data = yaml.load((InputStream)input);
            if (!(data instanceof Map)) return defaultMinutes * 60L * 1000L;
            Map root = (Map)data;
            Object punishmentObj = root.get("punishment");
            if (!(punishmentObj instanceof Map)) return defaultMinutes * 60L * 1000L;
            Map punishmentMap = (Map)punishmentObj;
            Object minutesObj = punishmentMap.get("duration-minutes");
            if (!(minutesObj instanceof Number)) return defaultMinutes * 60L * 1000L;
            long l = ((Number)minutesObj).longValue() * 60L * 1000L;
            return l;
        }
        catch (Exception e) {
            this.plugin.getServer().getLogger().warning("Failed to load punishment duration: " + e.getMessage());
        }
        return defaultMinutes * 60L * 1000L;
    }

    public void punishQuitter(Player quitter) {
        long expireAt = System.currentTimeMillis() + this.punishmentDurationMillis;
        this.punishments.put(quitter.getUniqueId(), expireAt);
    }

    public long getRemainingPunishment(Player player) {
        Long expireTime = this.punishments.get(player.getUniqueId());
        if (expireTime == null) {
            return 0L;
        }
        return Math.max(0L, expireTime - System.currentTimeMillis());
    }

    public boolean isPunished(Player player) {
        UUID uuid = player.getUniqueId();
        Long expire = this.punishments.get(uuid);
        if (expire == null) {
            return false;
        }
        if (System.currentTimeMillis() > expire) {
            this.punishments.remove(uuid);
            return false;
        }
        return true;
    }

    public long getPunishmentDurationMillis() {
        return this.punishmentDurationMillis;
    }

    public int getPunishmentDurationMinutes() {
        return (int)(this.punishmentDurationMillis / 1000L / 60L);
    }

    public ArenaFighter getPlugin() {
        return this.plugin;
    }

    private boolean tryWithdraw(Player player, double amount) {
        if (amount <= 0.0) {
            return true;
        }
        boolean success = this.economy.withdrawPlayer(player.getName(), amount, player.getWorld());
        if (!success) {
            player.sendMessage(ChatColor.RED + "You do not have enough money to wager " + amount);
        }
        return success;
    }

    public void deposit(Player player, double amount) {
        if (amount <= 0.0) {
            return;
        }
        this.economy.depositPlayer(player.getName(), amount, player.getWorld());
    }

    public boolean hasSufficientFunds(Player player, double amount) {
        return this.economy != null && this.economy.hasEnough(player.getName(), amount, player.getWorld());
    }

    public Fight getFightByArena(String arenaName) {
        for (Fight fight : this.activeFights.values()) {
            if (!fight.getArena().getName().equalsIgnoreCase(arenaName)) continue;
            return fight;
        }
        return null;
    }

    public Collection<Fight> getActiveFights() {
        return this.activeFights.values();
    }

    private void ejectPlayer(Player player) {
        if (player.isInsideVehicle()) {
            player.leaveVehicle();
        }
        CraftPlayer cp = (CraftPlayer)player;
        EntityPlayer eh = cp.getHandle();
        if (eh.sleeping) {
            eh.a(true, true, true);
        }
    }

    public boolean startFight(Player player1, Player player2, double wager) {
        Arena arena;
        if (this.isInFight(player1) || this.isInFight(player2)) {
            return false;
        }
        if (wager > 0.0) {
            if (!this.hasSufficientFunds(player1, wager)) {
                player1.sendMessage(ChatColor.RED + "You no longer have enough money to enter this fight.");
                player2.sendMessage(ChatColor.RED + player1.getName() + " no longer has enough money. Fight canceled.");
                return false;
            }
            if (!this.hasSufficientFunds(player2, wager)) {
                player2.sendMessage(ChatColor.RED + "You no longer have enough money to enter this fight.");
                player1.sendMessage(ChatColor.RED + player2.getName() + " no longer has enough money. Fight canceled.");
                return false;
            }
        }
        if (wager > 0.0) {
            if (!this.tryWithdraw(player1, wager)) {
                return false;
            }
            if (!this.tryWithdraw(player2, wager)) {
                this.deposit(player1, wager);
                return false;
            }
        }
        if ((arena = this.arenaManager.getAvailableArena()) == null) {
            if (wager > 0.0) {
                this.deposit(player1, wager);
                this.deposit(player2, wager);
            }
            return false;
        }
        this.originalLocations.put(player1.getUniqueId(), player1.getLocation().clone());
        this.originalLocations.put(player2.getUniqueId(), player2.getLocation().clone());
        Fight fight = new Fight(player1, player2, arena, wager);
        this.activeFights.put(player1.getUniqueId(), fight);
        this.activeFights.put(player2.getUniqueId(), fight);
        this.arenaManager.occupyArena(arena);
        this.originalInventories.put(player1.getUniqueId(), (ItemStack[])player1.getInventory().getContents().clone());
        this.originalInventories.put(player2.getUniqueId(), (ItemStack[])player2.getInventory().getContents().clone());
        this.originalArmor.put(player1.getUniqueId(), (ItemStack[])player1.getInventory().getArmorContents().clone());
        this.originalArmor.put(player2.getUniqueId(), (ItemStack[])player2.getInventory().getArmorContents().clone());
        this.ejectPlayer(player1);
        this.ejectPlayer(player2);
        player1.teleport(arena.getSpawn1());
        player2.teleport(arena.getSpawn2());
        this.healAndFeedPlayer(player1);
        this.healAndFeedPlayer(player2);
        String message = ChatColor.YELLOW + "Fight started! " + ChatColor.WHITE + player1.getName() + ChatColor.YELLOW + " vs " + ChatColor.WHITE + player2.getName() + ChatColor.YELLOW + " in arena " + ChatColor.GREEN + arena.getName();
        if (wager > 0.0) {
            message = message + ChatColor.YELLOW + " with a wager of " + ChatColor.GOLD + wager;
        }
        fight.clearBets();
        this.plugin.getServer().broadcastMessage(message);
        return true;
    }

    public void endFight(Player winner, Player loser) {
        Fight fight = this.activeFights.get(winner.getUniqueId());
        if (fight == null) {
            return;
        }
        this.activeFights.remove(winner.getUniqueId());
        this.activeFights.remove(loser.getUniqueId());
        this.arenaManager.releaseArena(fight.getArena());
        Location winnerOriginal = this.originalLocations.remove(winner.getUniqueId());
        Location loserOriginal = this.originalLocations.remove(loser.getUniqueId());
        if (winnerOriginal != null) {
            winner.teleport(winnerOriginal);
            this.restoreOriginalInventoryAndArmor(winner);
            this.healAndFeedPlayer(winner);
        }
        if (loserOriginal != null) {
            loser.teleport(loserOriginal);
            this.restoreOriginalInventoryAndArmor(loser);
            this.healAndFeedPlayer(loser);
        }
        this.stopAllSpectators();
        double wager = fight.getWager();
        if (wager > 0.0) {
            this.deposit(winner, wager * 2.0);
            winner.sendMessage(ChatColor.GREEN + "You have won " + wager * 2.0 + " from the wager!");
        }
        fight.resolveBets(winner.getName());
        String message = ChatColor.GOLD + winner.getName() + ChatColor.YELLOW + " has defeated " + ChatColor.RED + loser.getName() + ChatColor.YELLOW + " in arena " + ChatColor.GREEN + fight.getArena().getName();
        if (wager > 0.0) {
            message = message + ChatColor.YELLOW + " and won a wager of " + ChatColor.GOLD + wager * 2.0;
        }
        message = message + ChatColor.YELLOW + "!";
        this.plugin.getServer().broadcastMessage(message);
    }

    private void restoreOriginalInventoryAndArmor(final Player player) {
        final UUID uuid = player.getUniqueId();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (FightManager.this.originalInventories.containsKey(uuid)) {
                    player.getInventory().setContents((ItemStack[])FightManager.this.originalInventories.remove(uuid));
                }
                if (FightManager.this.originalArmor.containsKey(uuid)) {
                    player.getInventory().setArmorContents((ItemStack[])FightManager.this.originalArmor.remove(uuid));
                }
                player.updateInventory();
            }
        }, 3L);
    }

    public void cancelFight(Player player) {
        Fight fight = this.activeFights.get(player.getUniqueId());
        if (fight == null) {
            return;
        }
        Player otherPlayer = fight.getOtherPlayer(player);
        this.activeFights.remove(player.getUniqueId());
        this.activeFights.remove(otherPlayer.getUniqueId());
        this.arenaManager.releaseArena(fight.getArena());
        Location playerOriginal = this.originalLocations.remove(player.getUniqueId());
        Location otherOriginal = this.originalLocations.remove(otherPlayer.getUniqueId());
        if (playerOriginal != null) {
            player.teleport(playerOriginal);
            this.healAndFeedPlayer(player);
        }
        if (otherOriginal != null) {
            otherPlayer.teleport(otherOriginal);
            this.healAndFeedPlayer(otherPlayer);
        }
        this.stopAllSpectators();
        String message = ChatColor.RED + "Fight cancelled!";
        player.sendMessage(message);
        otherPlayer.sendMessage(message);
    }

    public boolean isInFight(Player player) {
        return this.activeFights.containsKey(player.getUniqueId());
    }

    public Fight getFight(Player player) {
        return this.activeFights.get(player.getUniqueId());
    }

    private void healAndFeedPlayer(Player player) {
        player.setHealth(20);
    }

    public void cleanup() {
        for (Fight fight : this.activeFights.values()) {
            Player player1 = fight.getPlayer1();
            Player player2 = fight.getPlayer2();
            Location loc1 = this.originalLocations.get(player1.getUniqueId());
            Location loc2 = this.originalLocations.get(player2.getUniqueId());
            if (loc1 != null && player1.isOnline()) {
                player1.teleport(loc1);
            }
            if (loc2 != null && player2.isOnline()) {
                player2.teleport(loc2);
            }
            this.arenaManager.releaseArena(fight.getArena());
        }
        this.activeFights.clear();
        this.originalLocations.clear();
        this.stopAllSpectators();
    }

    public boolean hasPendingChallenge(Player player) {
        UUID uuid = player.getUniqueId();
        for (FightChallenge challenge : this.pendingChallenges.values()) {
            if (!challenge.getChallengerId().equals(uuid) && !challenge.getTargetId().equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public boolean sendChallenge(Player challenger, Player target, double wager) {
        if (this.hasPendingChallenge(challenger) || this.hasPendingChallenge(target)) {
            return false;
        }
        FightChallenge challenge = new FightChallenge(challenger.getUniqueId(), target.getUniqueId(), wager);
        this.pendingChallenges.put(challenger.getUniqueId(), challenge);
        return true;
    }

    public boolean acceptChallenge(Player target) {
        UUID targetId = target.getUniqueId();
        FightChallenge foundChallenge = null;
        for (FightChallenge challenge : this.pendingChallenges.values()) {
            if (!challenge.getTargetId().equals(targetId)) continue;
            foundChallenge = challenge;
            break;
        }
        if (foundChallenge == null) {
            return false;
        }
        UUID challengerId = foundChallenge.getChallengerId();
        double wager = foundChallenge.getWager();
        Player challenger = this.plugin.getServer().getPlayer(challengerId);
        if (challenger == null || !challenger.isOnline()) {
            this.pendingChallenges.values().remove(foundChallenge);
            return false;
        }
        this.pendingChallenges.values().remove(foundChallenge);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (challenger.isOnline() && target.isOnline()) {
                challenger.sendMessage(ChatColor.YELLOW + "Fight starts in 15 seconds...");
                target.sendMessage(ChatColor.YELLOW + "Fight starts in 15 seconds...");
            }
        }, 300L);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (challenger.isOnline() && target.isOnline()) {
                this.startFight(challenger, target, wager);
            }
        }, 600L);
        return true;
    }

    public void cancelChallenge(Player player) {
        UUID uuid = player.getUniqueId();
        this.pendingChallenges.entrySet().removeIf(entry -> ((UUID)entry.getKey()).equals(uuid) || ((FightChallenge)entry.getValue()).getTargetId().equals(uuid));
    }

    public boolean startSpectating(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.spectatorOriginalLocations.containsKey(uuid)) {
            player.sendMessage(ChatColor.RED + "You are already spectating.");
            return false;
        }
        Fight fight = null;
        for (Fight f : this.activeFights.values()) {
            if (f.getPlayer1().getUniqueId().equals(uuid) || f.getPlayer2().getUniqueId().equals(uuid)) continue;
            fight = f;
            break;
        }
        if (fight == null) {
            player.sendMessage(ChatColor.RED + "No ongoing fight to spectate.");
            return false;
        }
        Arena arena = fight.getArena();
        Location specSpawn = arena.getSpectatorSpawn();
        if (specSpawn == null) {
            player.sendMessage(ChatColor.RED + "No spectator spawn set for this arena.");
            return false;
        }
        this.spectatorOriginalLocations.put(uuid, player.getLocation().clone());
        player.teleport(specSpawn);
        player.sendMessage(ChatColor.YELLOW + "You are now spectating the fight between " + fight.getPlayer1().getName() + " and " + fight.getPlayer2().getName() + ".");
        return true;
    }

    public boolean startSpectating(Player player, String arenaName) {
        UUID uuid = player.getUniqueId();
        if (this.spectatorOriginalLocations.containsKey(uuid)) {
            player.sendMessage(ChatColor.RED + "You are already spectating.");
            return false;
        }
        Arena arena = this.arenaManager.getArena(arenaName);
        if (arena == null) {
            player.sendMessage(ChatColor.RED + "Arena '" + arenaName + "' does not exist.");
            return false;
        }
        Location specSpawn = arena.getSpectatorSpawn();
        if (specSpawn == null) {
            player.sendMessage(ChatColor.RED + "Spectator spawn is not set for arena '" + arenaName + "'.");
            return false;
        }
        this.spectatorOriginalLocations.put(uuid, player.getLocation().clone());
        player.teleport(specSpawn);
        player.sendMessage(ChatColor.YELLOW + "You are now spectating arena: " + ChatColor.AQUA + arenaName);
        player.sendMessage(ChatColor.YELLOW + "Use /spectate to return to your original location.");
        return true;
    }

    public boolean stopSpectating(Player player) {
        UUID uuid = player.getUniqueId();
        Location original = this.spectatorOriginalLocations.remove(uuid);
        if (original != null) {
            player.teleport(original);
            player.sendMessage(ChatColor.YELLOW + "Returned from spectating.");
            return true;
        }
        player.sendMessage(ChatColor.RED + "You are not spectating.");
        return false;
    }

    public void stopAllSpectators() {
        for (UUID uuid : new HashMap<UUID, Location>(this.spectatorOriginalLocations).keySet()) {
            Player player = this.plugin.getServer().getPlayer(uuid);
            if (player == null || !player.isOnline()) continue;
            this.stopSpectating(player);
        }
    }

    public boolean isSpectating(Player player) {
        return this.spectatorOriginalLocations.containsKey(player.getUniqueId());
    }

    private static class FightChallenge {
        private final UUID challengerId;
        private final UUID targetId;
        private final double wager;

        public FightChallenge(UUID challengerId, UUID targetId, double wager) {
            this.challengerId = challengerId;
            this.targetId = targetId;
            this.wager = wager;
        }

        public UUID getChallengerId() {
            return this.challengerId;
        }

        public UUID getTargetId() {
            return this.targetId;
        }

        public double getWager() {
            return this.wager;
        }
    }
}

