/*
 * Decompiled with CFR 0.152.
 */
package poggercity.noSat;

import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class NoSat
extends JavaPlugin
implements Listener {
    private boolean pluginEnabled = true;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("NoSat plugin has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("NoSat plugin has been disabled!");
    }

    private void loadConfig() {
        this.reloadConfig();
        this.pluginEnabled = this.getConfig().getBoolean("enabled", true);
        this.getLogger().info("NoSat plugin is " + (this.pluginEnabled ? "enabled" : "disabled") + " via config");
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        if (!this.pluginEnabled) {
            return;
        }
        Player player = event.getPlayer();
        player.setSaturation(0.0f);
        this.getLogger().info("Set " + player.getName() + "'s saturation to 0 after world change from " + event.getFrom().getName() + " to " + player.getWorld().getName());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("nosatreload")) {
            if (sender.hasPermission("nosat.reload")) {
                this.loadConfig();
                sender.sendMessage("\u00a7aNoSat configuration reloaded!");
                return true;
            }
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        return false;
    }
}

