/*
 * Decompiled with CFR 0.152.
 */
package com.playernotifier.config;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class RadarManager {
    private static final File SETTINGS_FILE = new File("config/playernotifier_settings.json");
    private static final File BLACKLIST_FILE = new File("config/playernotifier_blacklist.json");
    private static final File WHITELIST_FILE = new File("config/playernotifier_whitelist.json");
    private static final Gson GSON = new Gson();
    private static Set<String> blacklistedPlayers = Collections.synchronizedSet(new HashSet());
    private static Set<String> whitelistedPlayers = Collections.synchronizedSet(new HashSet());
    public static final RadarList blacklist = new RadarList(BLACKLIST_FILE, blacklistedPlayers);
    public static final RadarList whitelist = new RadarList(WHITELIST_FILE, whitelistedPlayers);
    private static Settings settings = new Settings();
    public static RadarList currentList = blacklist;

    public static void initialize() {
        RadarManager.loadLists();
        RadarManager.loadSettings();
    }

    public static void loadLists() {
        blacklist.loadList();
        whitelist.loadList();
    }

    public static void saveLists() {
        blacklist.saveList();
        whitelist.saveList();
    }

    public static void loadSettings() {
        if (SETTINGS_FILE.exists()) {
            try (FileReader reader = new FileReader(SETTINGS_FILE);){
                Settings loaded = (Settings)GSON.fromJson((Reader)reader, Settings.class);
                if (loaded != null) {
                    settings = loaded;
                    currentList = "blacklist".equals(RadarManager.settings.radarMode) ? blacklist : whitelist;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveSettings() {
        SETTINGS_FILE.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(SETTINGS_FILE);){
            GSON.toJson((Object)settings, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setRadarMode(String radarMode) {
        if ("blacklist".equals(radarMode) || "whitelist".equals(radarMode)) {
            currentList = "blacklist".equals(radarMode) ? blacklist : whitelist;
            RadarManager.settings.radarMode = radarMode;
        }
    }

    public static String getRadarMode() {
        return RadarManager.settings.radarMode;
    }

    public static void setRadarEnabled(boolean radarEnabled) {
        RadarManager.settings.radarEnabled = radarEnabled;
    }

    public static boolean getRadarEnabled() {
        return RadarManager.settings.radarEnabled;
    }

    @Environment(value=EnvType.CLIENT)
    public static class RadarList {
        private File file;
        private Set<String> list;

        RadarList(File file, Set<String> list) {
            this.file = file;
            this.list = list;
        }

        public void addPlayer(UUID playerUUID) {
            this.list.add(playerUUID.toString());
            this.saveList();
        }

        public void removePlayer(UUID playerUUID) {
            this.list.remove(playerUUID.toString());
            this.saveList();
        }

        public void loadList() {
            if (this.file.exists()) {
                try (FileReader reader = new FileReader(this.file);){
                    Type type = new TypeToken<Set<String>>(){}.getType();
                    Set loaded = (Set)GSON.fromJson((Reader)reader, type);
                    this.list.clear();
                    if (loaded != null) {
                        this.list.addAll(loaded);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.list.clear();
                }
            }
        }

        public void saveList() {
            this.ensureDirectory();
            try (FileWriter writer = new FileWriter(this.file);){
                GSON.toJson(this.list, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public boolean isPlayerListed(UUID playerUUID) {
            return this.list.contains(playerUUID.toString());
        }

        public Set<String> getList() {
            return this.list;
        }

        private void ensureDirectory() {
            File parent = this.file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class Settings {
        String radarMode = "blacklist";
        boolean radarEnabled = true;

        private Settings() {
        }
    }
}

