/*
 * Decompiled with CFR 0.152.
 */
package com.playernotifier;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.playernotifier.PlayerUtils;
import com.playernotifier.config.RadarManager;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class RadarBlacklistCommand {
    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"radarlist").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String radarMode = RadarManager.getRadarMode();
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"player");
            PlayerUtils.getPlayerUUID(playerName).thenAccept(playerUUID -> {
                if (playerUUID == null) {
                    RadarBlacklistCommand.sendError("playernotifier." + radarMode + ".not_found", playerName);
                    return;
                }
                if (RadarManager.currentList.isPlayerListed((UUID)playerUUID)) {
                    RadarBlacklistCommand.sendFeedback("playernotifier." + radarMode + ".already", playerName);
                } else {
                    RadarManager.currentList.addPlayer((UUID)playerUUID);
                    RadarBlacklistCommand.sendFeedback("playernotifier." + radarMode + ".added", playerName);
                }
            });
            return 1;
        })))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String radarMode = RadarManager.getRadarMode();
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"player");
            PlayerUtils.getPlayerUUID(playerName).thenAccept(playerUUID -> {
                if (playerUUID == null) {
                    RadarBlacklistCommand.sendError("playernotifier." + radarMode + ".not_found", playerName);
                    return;
                }
                if (!RadarManager.currentList.isPlayerListed((UUID)playerUUID)) {
                    RadarBlacklistCommand.sendFeedback("playernotifier." + radarMode + ".not", playerName);
                } else {
                    RadarManager.currentList.removePlayer((UUID)playerUUID);
                    RadarBlacklistCommand.sendFeedback("playernotifier." + radarMode + ".removed", playerName);
                }
            });
            return 1;
        })))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"uuid").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"playerUUID", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String radarMode = RadarManager.getRadarMode();
            String uuidString = StringArgumentType.getString((CommandContext)context, (String)"playerUUID");
            try {
                UUID playerUUID = UUID.fromString(uuidString);
                if (RadarManager.currentList.isPlayerListed(playerUUID)) {
                    RadarBlacklistCommand.sendFeedback("playernotifier." + radarMode + ".uuid_already", playerUUID.toString());
                } else {
                    RadarManager.currentList.addPlayer(playerUUID);
                    RadarBlacklistCommand.sendFeedback("playernotifier." + radarMode + ".uuid_added", playerUUID.toString());
                }
            }
            catch (IllegalArgumentException e) {
                RadarBlacklistCommand.sendError("playernotifier." + radarMode + ".invalid_uuid", new Object[0]);
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"playerUUID", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String radarMode = RadarManager.getRadarMode();
            String uuidString = StringArgumentType.getString((CommandContext)context, (String)"playerUUID");
            try {
                UUID playerUUID = UUID.fromString(uuidString);
                if (!RadarManager.currentList.isPlayerListed(playerUUID)) {
                    RadarBlacklistCommand.sendFeedback("playernotifier." + radarMode + ".uuid_not", playerUUID.toString());
                } else {
                    RadarManager.currentList.removePlayer(playerUUID);
                    RadarBlacklistCommand.sendFeedback("playernotifier." + radarMode + ".uuid_removed", playerUUID.toString());
                }
            }
            catch (IllegalArgumentException e) {
                RadarBlacklistCommand.sendError("playernotifier." + radarMode + ".invalid_uuid", new Object[0]);
            }
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mode").then(ClientCommandManager.literal((String)"blacklist").executes(context -> {
            String radarMode = RadarManager.getRadarMode();
            if (radarMode == "blacklist") {
                RadarBlacklistCommand.sendFeedback("playernotifier.mode.already_blacklist", new Object[0]);
            } else {
                RadarManager.setRadarMode("blacklist");
                RadarBlacklistCommand.sendFeedback("playernotifier.mode.set.blacklist", new Object[0]);
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"whitelist").executes(context -> {
            String radarMode = RadarManager.getRadarMode();
            if (radarMode == "whitelist") {
                RadarBlacklistCommand.sendFeedback("playernotifier.mode.already_whitelist", new Object[0]);
            } else {
                RadarManager.setRadarMode("whitelist");
                RadarBlacklistCommand.sendFeedback("playernotifier.mode.set.whitelist", new Object[0]);
            }
            return 1;
        }))).executes(context -> {
            String radarMode = RadarManager.getRadarMode();
            RadarBlacklistCommand.sendFeedback("playernotifier.mode." + radarMode, new Object[0]);
            return 1;
        }))));
    }

    private static void sendFeedback(String translationKey, Object ... args) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43469((String)translationKey, (Object[])args), false);
        }
    }

    private static void sendError(String translationKey, Object ... args) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43469((String)translationKey, (Object[])args).method_27692(class_124.field_1061), false);
        }
    }
}

