/*
 * Decompiled with CFR 0.152.
 */
package com.playernotifier;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class GameProfileCompat {
    private static Function<GameProfile, UUID> idGetter = GameProfileCompat.attemptGetter("id", "getId");
    private static Function<GameProfile, String> nameGetter = GameProfileCompat.attemptGetter("name", "getName");

    private static <T> Function<GameProfile, T> attemptGetter(String primary, String fallback) {
        try {
            Method m = GameProfile.class.getMethod(primary, new Class[0]);
            return profile -> {
                try {
                    return m.invoke(profile, new Object[0]);
                }
                catch (Exception e) {
                    return null;
                }
            };
        }
        catch (NoSuchMethodException e) {
            try {
                Method m1 = GameProfile.class.getMethod(fallback, new Class[0]);
                return profile -> {
                    try {
                        return m1.invoke(profile, new Object[0]);
                    }
                    catch (Exception ex) {
                        return null;
                    }
                };
            }
            catch (Exception ex) {
                return profile -> null;
            }
        }
    }

    public static UUID getId(GameProfile profile) {
        return idGetter.apply(profile);
    }

    public static String getName(GameProfile profile) {
        return nameGetter.apply(profile);
    }
}

