/*
 * Decompiled with CFR 0.152.
 */
package com.playernotifier;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_640;

@Environment(value=EnvType.CLIENT)
public class PlayerUtils {
    private static final Map<String, Optional<UUID>> uuidCache = new ConcurrentHashMap<String, Optional<UUID>>();

    public static CompletableFuture<UUID> getPlayerUUID(String playerName) {
        if (playerName == null || playerName.isBlank()) {
            return CompletableFuture.completedFuture(null);
        }
        String normalized = playerName.toLowerCase();
        if (uuidCache.containsKey(normalized)) {
            return CompletableFuture.completedFuture(uuidCache.get(normalized).orElse(null));
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && client.method_1562() != null) {
            for (class_640 entry : client.method_1562().method_2880()) {
                if (!entry.method_2966().getName().equalsIgnoreCase(playerName)) continue;
                UUID uuid = entry.method_2966().getId();
                uuidCache.put(normalized, Optional.of(uuid));
                return CompletableFuture.completedFuture(uuid);
            }
        }
        return CompletableFuture.supplyAsync(() -> {
            UUID fetched = PlayerUtils.fetchUUIDFromMojang(playerName);
            uuidCache.put(normalized, Optional.ofNullable(fetched));
            return fetched;
        });
    }

    /*
     * Exception decompiling
     */
    private static UUID fetchUUIDFromMojang(String playerName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static UUID fromUndashedUUID(String id) {
        return UUID.fromString(id.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
    }
}

