/*
 * Decompiled with CFR 0.152.
 */
package com.playernotifier;

import com.playernotifier.RadarBlacklistCommand;
import com.playernotifier.config.ConfigWrapper;
import com.playernotifier.config.MidnightConfigInit;
import com.playernotifier.config.RadarManager;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

@Environment(value=EnvType.CLIENT)
public class PlayerNotifierClient
implements ClientModInitializer {
    public static final String MOD_ID = "playernotifier";
    private final Set<class_1657> loadedPlayers = new HashSet<class_1657>();
    private int ticks = 0;
    private int timesPlayed = 0;
    private boolean alarming = false;

    public void onInitializeClient() {
        if (FabricLoader.getInstance().isModLoaded("midnightlib")) {
            MidnightConfig.init((String)MOD_ID, MidnightConfigInit.class);
        }
        RadarBlacklistCommand.register();
        RadarManager.initialize();
        ClientTickEvents.END_WORLD_TICK.register(world -> {
            if (world != null) {
                class_310 client = class_310.method_1551();
                if (client.field_1687 != null) {
                    HashSet currentPlayers = new HashSet(client.field_1687.method_18456());
                    for (class_1657 player : currentPlayers) {
                        UUID playerUUID = player.method_7334().getId();
                        if (!"blacklist".equals(RadarManager.getRadarMode()) ? !RadarManager.whitelist.isPlayerListed(playerUUID) : RadarManager.blacklist.isPlayerListed(playerUUID)) continue;
                        if (player.equals((Object)client.field_1724) || this.loadedPlayers.contains(player)) continue;
                        String playerName = player.method_7334().getName();
                        class_2561 playerDisplayName = player.method_5477();
                        if (playerUUID == null || playerUUID.version() != 4 || playerName == null || playerName.replaceAll("\u00a7.", "").trim().isEmpty()) continue;
                        if (ConfigWrapper.showChat()) {
                            client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"playernotifier.playerEnteredChunks", (Object[])new Object[]{ConfigWrapper.showDisplayNames() ? playerDisplayName : playerName}), false);
                        }
                        if (ConfigWrapper.showHUD()) {
                            client.field_1705.method_1758((class_2561)class_2561.method_43469((String)"playernotifier.playerEnteredChunks", (Object[])new Object[]{ConfigWrapper.showDisplayNames() ? playerDisplayName : playerName}), false);
                        }
                        if (!ConfigWrapper.playSound()) continue;
                        this.alarm();
                    }
                    this.loadedPlayers.clear();
                    this.loadedPlayers.addAll(currentPlayers);
                }
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (this.alarming) {
                if (client.field_1724 == null) {
                    this.stopAlarm();
                    return;
                }
                ++this.ticks;
                if (this.ticks % ConfigWrapper.soundInterval() == 0) {
                    client.field_1724.method_5783((class_3414)class_3417.field_14793.comp_349(), (float)ConfigWrapper.soundVolume() / 100.0f, (float)ConfigWrapper.soundPitch() / 100.0f);
                    ++this.timesPlayed;
                }
                if (this.timesPlayed == ConfigWrapper.timesToPlaySound()) {
                    this.stopAlarm();
                }
            }
        });
    }

    public void alarm() {
        this.alarming = true;
    }

    public void stopAlarm() {
        this.alarming = false;
        this.timesPlayed = 0;
        this.ticks = 0;
    }
}

