/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.plushables.block;

import com.khazoda.plushables.block.interaction.InteractionEffectData;
import com.khazoda.plushables.block.tooltip.TooltipData;
import com.khazoda.plushables.block.util.VoxelShapeHelper;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public abstract class BasePlushable
extends class_2383
implements class_3737 {
    public static final class_4970.class_2251 defaultSettings = class_4970.class_2251.method_9637().method_9626(class_2498.field_11543).method_9632(0.1f).method_22488().method_50012(class_3619.field_15971);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 ON_COOLDOWN = class_2746.method_11825((String)"on_cooldown");
    final class_265 blockShape = this.useShape();
    final class_265[] blockShapes = VoxelShapeHelper.calculateBlockShapes(this.blockShape);
    protected final InteractionEffectData effectData;
    protected final TooltipData tooltipData;

    public BasePlushable(class_4970.class_2251 settings) {
        this(settings, TooltipData.DEFAULT, InteractionEffectData.DEFAULT);
    }

    public BasePlushable(class_4970.class_2251 settings, InteractionEffectData effectData) {
        this(settings, TooltipData.DEFAULT, effectData);
    }

    public BasePlushable(class_4970.class_2251 settings, TooltipData tooltipData) {
        this(settings, tooltipData, InteractionEffectData.DEFAULT);
    }

    public BasePlushable(class_4970.class_2251 settings, TooltipData tooltipData, InteractionEffectData effectData) {
        super(settings.method_9631(blockState -> effectData.lightLevel()));
        this.effectData = effectData;
        this.tooltipData = tooltipData;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)ON_COOLDOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        return (Boolean)state.method_11654((class_2769)ON_COOLDOWN) != false ? class_1269.field_21466 : (this.playInteractionEffects(level, state, hitResult, (class_1297)player) ? class_1269.field_52422 : class_1269.field_5811);
    }

    public boolean playInteractionEffects(class_1937 level, class_2680 state, class_3965 hitResult, class_1297 entity) {
        class_2338 blockPos = hitResult.method_17777();
        level.method_8396(null, blockPos, this.effectData.soundEvent(), class_3419.field_15245, this.effectData.soundVolume(), this.effectData.soundPitch());
        if (level.method_8608() && this.effectData.particleEffect() != null) {
            class_5819 random = level.method_8409();
            for (int i = 0; i < this.effectData.particleCount(); ++i) {
                double spread = this.effectData.particleSpread();
                double x = (double)blockPos.method_10263() + 0.5 + (random.method_43058() - 0.5) * spread;
                double y = (double)blockPos.method_10264() + 0.75 + (random.method_43058() - 0.5) * spread;
                double z = (double)blockPos.method_10260() + 0.5 + (random.method_43058() - 0.5) * spread;
                level.method_8406(this.effectData.particleEffect(), x, y, z, 0.0, 0.0, 0.0);
            }
        }
        this.startCooldown(state, level, blockPos);
        level.method_33596(entity, (class_6880)class_5712.field_28174, blockPos);
        return true;
    }

    public void startCooldown(class_2680 state, class_1937 level, class_2338 pos) {
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)ON_COOLDOWN, (Comparable)Boolean.valueOf(true)), 3);
        level.method_8408(pos, (class_2248)this);
        level.method_64310(pos, (class_2248)this, this.effectData.cooldownPeriod());
    }

    protected void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)ON_COOLDOWN, (Comparable)Boolean.valueOf(false)), 3);
        level.method_8408(pos, (class_2248)this);
    }

    public TooltipData getTooltipData() {
        return this.tooltipData;
    }

    public class_265 useShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_31943((double)0.0, (double)0.0, (double)0.0, (double)0.8, (double)0.8, (double)0.8));
        return shape;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        return VoxelShapeHelper.getSidedOutlineShape(direction, this.blockShape, this.blockShapes);
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ON_COOLDOWN, field_11177, WATERLOGGED});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)ON_COOLDOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12481, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(context.method_8045().method_8316(context.method_8037()).method_39360((class_3611)class_3612.field_15910)));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 level, class_10225 scheduledTickAccess, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(level));
        }
        return super.method_9559(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657((class_2769)field_11177, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)field_11177)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)field_11177)));
    }

    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }
}

